/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.local.utils.CustomSerDeUtils;
import org.apache.pinot.segment.local.utils.HyperLogLogUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class DistinctCountHLLValueAggregator
implements ValueAggregator<Object, HyperLogLog> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    private final int _log2m;
    private int _maxByteSize;

    public DistinctCountHLLValueAggregator(List<ExpressionContext> arguments) {
        this._log2m = arguments.isEmpty() ? 8 : arguments.get(0).getLiteral().getIntValue();
    }

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.DISTINCTCOUNTHLL;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public HyperLogLog getInitialAggregatedValue(Object rawValue) {
        HyperLogLog initialValue;
        if (rawValue instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            initialValue = this.deserializeAggregatedValue(bytes);
            this._maxByteSize = bytes.length;
        } else {
            initialValue = new HyperLogLog(this._log2m);
            initialValue.offer(rawValue);
            this._maxByteSize = HyperLogLogUtils.byteSize(initialValue);
        }
        return initialValue;
    }

    @Override
    public HyperLogLog applyRawValue(HyperLogLog value, Object rawValue) {
        if (rawValue instanceof byte[]) {
            try {
                value.addAll(this.deserializeAggregatedValue((byte[])rawValue));
            }
            catch (CardinalityMergeException e) {
                throw new RuntimeException(e);
            }
        } else {
            value.offer(rawValue);
        }
        return value;
    }

    @Override
    public HyperLogLog applyAggregatedValue(HyperLogLog value, HyperLogLog aggregatedValue) {
        try {
            value.addAll(aggregatedValue);
            return value;
        }
        catch (CardinalityMergeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HyperLogLog cloneAggregatedValue(HyperLogLog value) {
        return this.deserializeAggregatedValue(this.serializeAggregatedValue(value));
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return this._maxByteSize > 0 ? this._maxByteSize : HyperLogLogUtils.byteSize(this._log2m);
    }

    @Override
    public byte[] serializeAggregatedValue(HyperLogLog value) {
        return CustomSerDeUtils.HYPER_LOG_LOG_SER_DE.serialize(value);
    }

    @Override
    public HyperLogLog deserializeAggregatedValue(byte[] bytes) {
        return CustomSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(bytes);
    }

    @VisibleForTesting
    public int getLog2m() {
        return this._log2m;
    }
}

