/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.local.utils.CustomSerDeUtils;
import org.apache.pinot.segment.local.utils.HyperLogLogPlusUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class DistinctCountHLLPlusValueAggregator
implements ValueAggregator<Object, HyperLogLogPlus> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    private final int _p;
    private final int _sp;
    private int _maxByteSize;

    public DistinctCountHLLPlusValueAggregator(List<ExpressionContext> arguments) {
        if (arguments.size() == 1) {
            this._p = arguments.get(0).getLiteral().getIntValue();
            this._sp = 0;
        } else if (arguments.size() == 2) {
            this._p = arguments.get(0).getLiteral().getIntValue();
            this._sp = arguments.get(1).getLiteral().getIntValue();
        } else {
            this._p = 14;
            this._sp = 0;
        }
    }

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.DISTINCTCOUNTHLLPLUS;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public HyperLogLogPlus getInitialAggregatedValue(Object rawValue) {
        HyperLogLogPlus initialValue;
        if (rawValue instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            initialValue = this.deserializeAggregatedValue(bytes);
            this._maxByteSize = bytes.length;
        } else {
            initialValue = new HyperLogLogPlus(this._p, this._sp);
            initialValue.offer(rawValue);
            this._maxByteSize = HyperLogLogPlusUtils.byteSize(this._p, this._sp);
        }
        return initialValue;
    }

    @Override
    public HyperLogLogPlus applyRawValue(HyperLogLogPlus value, Object rawValue) {
        if (rawValue instanceof byte[]) {
            try {
                value.addAll(this.deserializeAggregatedValue((byte[])rawValue));
            }
            catch (CardinalityMergeException e) {
                throw new RuntimeException(e);
            }
        } else {
            value.offer(rawValue);
        }
        return value;
    }

    @Override
    public HyperLogLogPlus applyAggregatedValue(HyperLogLogPlus value, HyperLogLogPlus aggregatedValue) {
        try {
            value.addAll(aggregatedValue);
            return value;
        }
        catch (CardinalityMergeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HyperLogLogPlus cloneAggregatedValue(HyperLogLogPlus value) {
        return this.deserializeAggregatedValue(this.serializeAggregatedValue(value));
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return this._maxByteSize > 0 ? this._maxByteSize : HyperLogLogPlusUtils.byteSize(this._p, this._sp);
    }

    @Override
    public byte[] serializeAggregatedValue(HyperLogLogPlus value) {
        return CustomSerDeUtils.HYPER_LOG_LOG_PLUS_SER_DE.serialize(value);
    }

    @Override
    public HyperLogLogPlus deserializeAggregatedValue(byte[] bytes) {
        return CustomSerDeUtils.HYPER_LOG_LOG_PLUS_SER_DE.deserialize(bytes);
    }

    @VisibleForTesting
    public int getP() {
        return this._p;
    }

    @VisibleForTesting
    public int getSp() {
        return this._sp;
    }
}

