/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.mutablefst;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableArc;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableFST;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableState;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.utils.MutableFSTUtils;

public class MutableFSTImpl
implements MutableFST {
    private MutableState _start = new MutableState(true);

    @Override
    public MutableState getStartState() {
        return this._start;
    }

    @Override
    public void setStartState(MutableState start) {
        Preconditions.checkState((this._start != null ? 1 : 0) != 0, (Object)"Cannot override a start state");
        this._start = start;
    }

    public MutableState newStartState() {
        return this.newStartState();
    }

    public MutableArc addArc(MutableState startState, int outputSymbol, MutableState endState) {
        MutableArc newArc = new MutableArc(outputSymbol, endState);
        startState.addArc(newArc);
        endState.addIncomingState(startState);
        return newArc;
    }

    @Override
    public void throwIfInvalid() {
        Preconditions.checkNotNull((Object)this._start, (Object)"must have a start state");
    }

    @Override
    public void addPath(String word, int outputSymbol) {
        MutableState state = this.getStartState();
        if (state == null) {
            throw new IllegalStateException("Start state cannot be null");
        }
        List<MutableArc> arcs = state.getArcs();
        boolean isFound = false;
        for (MutableArc arc : arcs) {
            if (arc.getNextState().getLabel() != word.charAt(0)) continue;
            state = arc.getNextState();
            isFound = true;
            break;
        }
        int foundPos = -1;
        if (isFound) {
            Pair<MutableState, Integer> pair = this.findPointOfDiversion(state, word);
            if (pair == null) {
                return;
            }
            foundPos = (Integer)pair.getRight();
            state = (MutableState)pair.getLeft();
        }
        for (int i = foundPos + 1; i < word.length(); ++i) {
            MutableState nextState = new MutableState();
            nextState.setLabel(word.charAt(i));
            int currentOutputSymbol = -1;
            if (i == word.length() - 1) {
                currentOutputSymbol = outputSymbol;
            }
            MutableArc mutableArc = new MutableArc(currentOutputSymbol, nextState);
            state.addArc(mutableArc);
            state = nextState;
        }
        state.setIsTerminal(true);
    }

    private Pair<MutableState, Integer> findPointOfDiversion(MutableState mutableState, String word) {
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        MutableState currentState = mutableState;
        int pos = 0;
        queue.add(Pair.of((Object)mutableState, (Object)0));
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.remove();
            currentState = (MutableState)pair.getLeft();
            pos = (Integer)pair.getRight();
            if (pos == word.length() - 1) {
                return null;
            }
            if (currentState.getLabel() != word.charAt(pos)) {
                throw new IllegalStateException("Current state needs to be part of word path");
            }
            List<MutableArc> arcs = currentState.getArcs();
            for (MutableArc arc : arcs) {
                if (arc.getNextState().getLabel() != word.charAt(pos + 1)) continue;
                queue.add(Pair.of((Object)arc.getNextState(), (Object)(pos + 1)));
            }
        }
        return Pair.of((Object)currentState, (Object)pos);
    }

    static <T> void compactNulls(ArrayList<T> list) {
        list.removeIf(Objects::isNull);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Fst(start=").append(this._start).append(")");
        List<MutableArc> arcs = this._start.getArcs();
        for (MutableArc arc : arcs) {
            sb.append("  ").append(arc.toString()).append("\n");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        return MutableFSTUtils.fstEquals(this, o);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this._start != null ? this._start.hashCode() : 0);
        return result;
    }
}

