/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.google.common.hash.Hashing;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.apache.pinot.spi.config.table.HashFunction;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.utils.ByteArray;

public class HashUtils {
    private HashUtils() {
    }

    public static byte[] hashMurmur3(byte[] bytes) {
        return Hashing.murmur3_128().hashBytes(bytes).asBytes();
    }

    public static byte[] hashMD5(byte[] bytes) {
        return Hashing.md5().hashBytes(bytes).asBytes();
    }

    public static byte[] hashUUID(PrimaryKey primaryKey) {
        Object[] values = primaryKey.getValues();
        byte[] result = new byte[values.length * 16];
        ByteBuffer byteBuffer = ByteBuffer.wrap(result).order(ByteOrder.BIG_ENDIAN);
        for (Object value : values) {
            UUID uuid;
            if (value == null) {
                throw new IllegalArgumentException("Found null value in primary key");
            }
            try {
                uuid = UUID.fromString(value.toString());
            }
            catch (Throwable t) {
                return primaryKey.asBytes();
            }
            byteBuffer.putLong(uuid.getMostSignificantBits());
            byteBuffer.putLong(uuid.getLeastSignificantBits());
        }
        return result;
    }

    public static Object hashPrimaryKey(PrimaryKey primaryKey, HashFunction hashFunction) {
        switch (hashFunction) {
            case NONE: {
                return primaryKey;
            }
            case MD5: {
                return new ByteArray(HashUtils.hashMD5(primaryKey.asBytes()));
            }
            case MURMUR3: {
                return new ByteArray(HashUtils.hashMurmur3(primaryKey.asBytes()));
            }
            case UUID: {
                return new ByteArray(HashUtils.hashUUID(primaryKey));
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized hash function %s", hashFunction));
    }
}

