/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.readers.LazyRow;
import org.apache.pinot.segment.local.upsert.merger.PartialUpsertMerger;
import org.apache.pinot.segment.local.upsert.merger.PartialUpsertMergerFactory;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class PartialUpsertHandler {
    private final List<String> _primaryKeyColumns;
    private final List<String> _comparisonColumns;
    private final TreeMap<String, FieldSpec> _fieldSpecMap;
    private final PartialUpsertMerger _partialUpsertMerger;
    private final Map<String, Object> _defaultNullValues = new HashMap<String, Object>();

    public PartialUpsertHandler(Schema schema, List<String> comparisonColumns, UpsertConfig upsertConfig) {
        this._primaryKeyColumns = schema.getPrimaryKeyColumns();
        this._comparisonColumns = comparisonColumns;
        this._fieldSpecMap = schema.getFieldSpecMap();
        this._partialUpsertMerger = PartialUpsertMergerFactory.getPartialUpsertMerger(this._primaryKeyColumns, comparisonColumns, upsertConfig);
        for (Map.Entry entry : schema.getFieldSpecMap().entrySet()) {
            String column = (String)entry.getKey();
            FieldSpec fieldSpec = (FieldSpec)entry.getValue();
            if (fieldSpec.isSingleValueField()) {
                this._defaultNullValues.put(column, fieldSpec.getDefaultNullValue());
                continue;
            }
            this._defaultNullValues.put(column, new Object[]{fieldSpec.getDefaultNullValue()});
        }
    }

    public void merge(LazyRow previousRow, GenericRow newRow, Map<String, Object> resultHolder) {
        this._partialUpsertMerger.merge(previousRow, newRow, resultHolder);
        for (Map.Entry<String, Object> entry : resultHolder.entrySet()) {
            String column = entry.getKey();
            if (this._primaryKeyColumns.contains(column) || this._comparisonColumns.contains(column)) continue;
            this.setMergedValue(newRow, column, entry.getValue());
        }
        for (String column : this._comparisonColumns) {
            if (!newRow.isNullValue(column) || previousRow.isNullValue(column)) continue;
            newRow.putValue(column, previousRow.getValue(column));
            newRow.removeNullValueField(column);
        }
    }

    private void setMergedValue(GenericRow row, String column, @Nullable Object mergedValue) {
        if (mergedValue != null) {
            row.removeNullValueField(column);
            row.putValue(column, mergedValue);
        } else {
            row.putDefaultNullValue(column, this._defaultNullValues.get(column));
        }
    }
}

