/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.readers;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.apache.pinot.spi.data.FieldSpec;

public class PinotSegmentColumnReader
implements Closeable {
    private final ForwardIndexReader _forwardIndexReader;
    private final ForwardIndexReaderContext _forwardIndexReaderContext;
    private final Dictionary _dictionary;
    private final NullValueVectorReader _nullValueVectorReader;
    private final int[] _dictIdBuffer;
    private final int _maxNumValuesPerMVEntry;

    public PinotSegmentColumnReader(IndexSegment indexSegment, String column) {
        DataSource dataSource = indexSegment.getDataSource(column);
        Preconditions.checkArgument((dataSource != null ? 1 : 0) != 0, (String)"Failed to find data source for column: %s", (Object)column);
        this._forwardIndexReader = dataSource.getForwardIndex();
        Preconditions.checkArgument((this._forwardIndexReader != null ? 1 : 0) != 0, (String)"Forward index disabled for column: %s", (Object)column);
        this._forwardIndexReaderContext = this._forwardIndexReader.createContext();
        this._dictionary = dataSource.getDictionary();
        this._nullValueVectorReader = dataSource.getNullValueVector();
        if (this._forwardIndexReader.isSingleValue()) {
            this._dictIdBuffer = null;
            this._maxNumValuesPerMVEntry = -1;
        } else {
            this._maxNumValuesPerMVEntry = dataSource.getDataSourceMetadata().getMaxNumValuesPerMVEntry();
            Preconditions.checkState((this._maxNumValuesPerMVEntry >= 0 ? 1 : 0) != 0, (Object)"maxNumValuesPerMVEntry is negative for an MV column.");
            this._dictIdBuffer = new int[this._maxNumValuesPerMVEntry];
        }
    }

    public PinotSegmentColumnReader(ForwardIndexReader forwardIndexReader, @Nullable Dictionary dictionary, @Nullable NullValueVectorReader nullValueVectorReader, int maxNumValuesPerMVEntry) {
        this._forwardIndexReader = forwardIndexReader;
        this._forwardIndexReaderContext = this._forwardIndexReader.createContext();
        this._dictionary = dictionary;
        this._nullValueVectorReader = nullValueVectorReader;
        this._maxNumValuesPerMVEntry = maxNumValuesPerMVEntry;
        this._dictIdBuffer = (int[])(this._forwardIndexReader.isSingleValue() ? null : new int[maxNumValuesPerMVEntry]);
    }

    public boolean isSingleValue() {
        return this._forwardIndexReader.isSingleValue();
    }

    public boolean hasDictionary() {
        return this._dictionary != null;
    }

    public Dictionary getDictionary() {
        return this._dictionary;
    }

    public int getDictId(int docId) {
        return this._forwardIndexReader.getDictId(docId, this._forwardIndexReaderContext);
    }

    public Object getValue(int docId) {
        if (this._dictionary != null) {
            if (this._forwardIndexReader.isSingleValue()) {
                return this._dictionary.get(this._forwardIndexReader.getDictId(docId, this._forwardIndexReaderContext));
            }
            int numValues = this._forwardIndexReader.getDictIdMV(docId, this._dictIdBuffer, this._forwardIndexReaderContext);
            FieldSpec.DataType storedType = this._dictionary.getValueType();
            switch (storedType) {
                case INT: {
                    Integer[] values = new Integer[numValues];
                    this._dictionary.readIntValues(this._dictIdBuffer, numValues, values);
                    return values;
                }
                case LONG: {
                    Long[] values = new Long[numValues];
                    this._dictionary.readLongValues(this._dictIdBuffer, numValues, values);
                    return values;
                }
                case FLOAT: {
                    Float[] values = new Float[numValues];
                    this._dictionary.readFloatValues(this._dictIdBuffer, numValues, values);
                    return values;
                }
                case DOUBLE: {
                    Double[] values = new Double[numValues];
                    this._dictionary.readDoubleValues(this._dictIdBuffer, numValues, values);
                    return values;
                }
                case STRING: {
                    String[] values = new String[numValues];
                    this._dictionary.readStringValues(this._dictIdBuffer, numValues, values);
                    return values;
                }
                case BYTES: {
                    byte[][] values = new byte[numValues][];
                    this._dictionary.readBytesValues(this._dictIdBuffer, numValues, (byte[][])values);
                    return values;
                }
            }
            throw new IllegalStateException("Unsupported MV type: " + storedType);
        }
        FieldSpec.DataType storedType = this._forwardIndexReader.getStoredType();
        if (this._forwardIndexReader.isSingleValue()) {
            switch (storedType) {
                case INT: {
                    return this._forwardIndexReader.getInt(docId, this._forwardIndexReaderContext);
                }
                case LONG: {
                    return this._forwardIndexReader.getLong(docId, this._forwardIndexReaderContext);
                }
                case FLOAT: {
                    return Float.valueOf(this._forwardIndexReader.getFloat(docId, this._forwardIndexReaderContext));
                }
                case DOUBLE: {
                    return this._forwardIndexReader.getDouble(docId, this._forwardIndexReaderContext);
                }
                case BIG_DECIMAL: {
                    return this._forwardIndexReader.getBigDecimal(docId, this._forwardIndexReaderContext);
                }
                case STRING: {
                    return this._forwardIndexReader.getString(docId, this._forwardIndexReaderContext);
                }
                case BYTES: {
                    return this._forwardIndexReader.getBytes(docId, this._forwardIndexReaderContext);
                }
            }
            throw new IllegalStateException("Unsupported SV type: " + storedType);
        }
        switch (storedType) {
            case INT: {
                return ArrayUtils.toObject((int[])this._forwardIndexReader.getIntMV(docId, this._forwardIndexReaderContext));
            }
            case LONG: {
                return ArrayUtils.toObject((long[])this._forwardIndexReader.getLongMV(docId, this._forwardIndexReaderContext));
            }
            case FLOAT: {
                return ArrayUtils.toObject((float[])this._forwardIndexReader.getFloatMV(docId, this._forwardIndexReaderContext));
            }
            case DOUBLE: {
                return ArrayUtils.toObject((double[])this._forwardIndexReader.getDoubleMV(docId, this._forwardIndexReaderContext));
            }
            case STRING: {
                return this._forwardIndexReader.getStringMV(docId, this._forwardIndexReaderContext);
            }
            case BYTES: {
                return this._forwardIndexReader.getBytesMV(docId, this._forwardIndexReaderContext);
            }
        }
        throw new IllegalStateException("Unsupported MV type: " + storedType);
    }

    public boolean isNull(int docId) {
        return this._nullValueVectorReader != null && this._nullValueVectorReader.isNull(docId);
    }

    @Override
    public void close() throws IOException {
        if (this._forwardIndexReaderContext != null) {
            this._forwardIndexReaderContext.close();
        }
    }
}

