/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.readers;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public class CompactedPinotSegmentRecordReader
implements RecordReader {
    private final PinotSegmentRecordReader _pinotSegmentRecordReader;
    private final RoaringBitmap _validDocIdsBitmap;
    private final String _deleteRecordColumn;
    private final GenericRow _nextRow = new GenericRow();
    private PeekableIntIterator _validDocIdsIterator;
    private boolean _nextRowReturned = true;

    public CompactedPinotSegmentRecordReader(File indexDir, RoaringBitmap validDocIds) {
        this(indexDir, validDocIds, null);
    }

    public CompactedPinotSegmentRecordReader(File indexDir, RoaringBitmap validDocIds, @Nullable String deleteRecordColumn) {
        this._pinotSegmentRecordReader = new PinotSegmentRecordReader();
        this._pinotSegmentRecordReader.init(indexDir, null, null);
        this._validDocIdsBitmap = validDocIds;
        this._validDocIdsIterator = validDocIds.getIntIterator();
        this._deleteRecordColumn = deleteRecordColumn;
    }

    public void init(File dataFile, @Nullable Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) throws IOException {
    }

    public boolean hasNext() {
        if (!this._validDocIdsIterator.hasNext() && this._nextRowReturned) {
            return false;
        }
        if (!this._nextRowReturned) {
            return true;
        }
        while (this._validDocIdsIterator.hasNext()) {
            int docId = this._validDocIdsIterator.next();
            this._nextRow.clear();
            this._pinotSegmentRecordReader.getRecord(docId, this._nextRow);
            if (this._deleteRecordColumn != null && BooleanUtils.toBoolean((Object)this._nextRow.getValue(this._deleteRecordColumn))) continue;
            this._nextRowReturned = false;
            return true;
        }
        return false;
    }

    public GenericRow next() throws IOException {
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) throws IOException {
        Preconditions.checkState((!this._nextRowReturned ? 1 : 0) != 0);
        reuse.init(this._nextRow);
        this._nextRowReturned = true;
        return reuse;
    }

    public void rewind() throws IOException {
        this._pinotSegmentRecordReader.rewind();
        this._nextRowReturned = true;
        this._validDocIdsIterator = this._validDocIdsBitmap.getIntIterator();
    }

    public void close() throws IOException {
        this._pinotSegmentRecordReader.close();
    }
}

