/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexType;
import org.apache.pinot.segment.local.segment.index.loader.BaseIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.RangeIndexConfig;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.CombinedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeIndexHandler
extends BaseIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RangeIndexHandler.class);
    private final Set<String> _columnsToAddIdx;

    @VisibleForTesting
    public RangeIndexHandler(SegmentDirectory segmentDirectory, IndexLoadingConfig indexLoadingConfig) {
        super(segmentDirectory, indexLoadingConfig);
        this._columnsToAddIdx = indexLoadingConfig.getRangeIndexColumns();
    }

    public RangeIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> fieldIndexConfigs, @Nullable TableConfig tableConfig) {
        super(segmentDirectory, fieldIndexConfigs, tableConfig);
        this._columnsToAddIdx = FieldIndexConfigsUtil.columnsWithIndexEnabled((IndexType)StandardIndexes.range(), (Map)this._fieldIndexConfigs);
    }

    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._columnsToAddIdx);
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.range());
        boolean rangeIndexUpdated = false;
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Need to remove existing range index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            rangeIndexUpdated = true;
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (columnMetadata == null) continue;
            if (columnMetadata.isSorted()) {
                LOGGER.info("Skipping creation of range index for segment: {}, column: {} as it is a sorted column", (Object)segmentName, (Object)column);
                continue;
            }
            LOGGER.info("Need to create new range index for segment: {}, column: {}", (Object)segmentName, (Object)column);
            rangeIndexUpdated = true;
        }
        return rangeIndexUpdated;
    }

    public void updateIndices(SegmentDirectory.Writer segmentWriter) throws Exception {
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._columnsToAddIdx);
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.range());
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Removing existing range index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, StandardIndexes.range());
            LOGGER.info("Removed existing range index from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (columnMetadata == null || columnMetadata.isSorted()) continue;
            this.createRangeIndexForColumn(segmentWriter, columnMetadata);
        }
    }

    private void createRangeIndexForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        String columnName = columnMetadata.getColumnName();
        File inProgress = new File(indexDir, columnName + ".range.inprogress");
        File rangeIndexFile = new File(indexDir, columnName + ".bitmap.range");
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)rangeIndexFile);
        }
        columnMetadata = this.createForwardIndexIfNeeded(segmentWriter, columnName, true);
        LOGGER.info("Creating new range index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
        if (columnMetadata.hasDictionary()) {
            this.handleDictionaryBasedColumn(segmentWriter, columnMetadata);
        } else {
            this.handleNonDictionaryBasedColumn(segmentWriter, columnMetadata);
        }
        if (this._segmentDirectory.getSegmentMetadata().getVersion() == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(segmentWriter, columnName, rangeIndexFile, StandardIndexes.range());
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created range index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
    }

    private void handleDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        int numDocs = columnMetadata.getTotalDocs();
        try (ForwardIndexReader<?> forwardIndexReader = ForwardIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             CombinedInvertedIndexCreator rangeIndexCreator = this.newRangeIndexCreator(columnMetadata);){
            if (columnMetadata.isSingleValue()) {
                for (int i = 0; i < numDocs; ++i) {
                    rangeIndexCreator.add(forwardIndexReader.getDictId(i, readerContext));
                }
            } else {
                int[] dictIds = new int[columnMetadata.getMaxNumberOfMultiValues()];
                for (int i = 0; i < numDocs; ++i) {
                    int length = forwardIndexReader.getDictIdMV(i, dictIds, readerContext);
                    rangeIndexCreator.add(dictIds, length);
                }
            }
            rangeIndexCreator.seal();
        }
    }

    private void handleNonDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        int numDocs = columnMetadata.getTotalDocs();
        try (ForwardIndexReader<?> forwardIndexReader = ForwardIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             CombinedInvertedIndexCreator rangeIndexCreator = this.newRangeIndexCreator(columnMetadata);){
            block40: {
                block39: {
                    if (!columnMetadata.isSingleValue()) break block39;
                    switch (columnMetadata.getDataType()) {
                        case INT: {
                            for (int i = 0; i < numDocs; ++i) {
                                rangeIndexCreator.add(forwardIndexReader.getInt(i, readerContext));
                            }
                            break block40;
                        }
                        case LONG: {
                            for (int i = 0; i < numDocs; ++i) {
                                rangeIndexCreator.add(forwardIndexReader.getLong(i, readerContext));
                            }
                            break block40;
                        }
                        case FLOAT: {
                            for (int i = 0; i < numDocs; ++i) {
                                rangeIndexCreator.add(forwardIndexReader.getFloat(i, readerContext));
                            }
                            break block40;
                        }
                        case DOUBLE: {
                            for (int i = 0; i < numDocs; ++i) {
                                rangeIndexCreator.add(forwardIndexReader.getDouble(i, readerContext));
                            }
                            break block40;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported data type: " + columnMetadata.getDataType());
                        }
                    }
                }
                int maxNumValuesPerMVEntry = columnMetadata.getMaxNumberOfMultiValues();
                switch (columnMetadata.getDataType()) {
                    case INT: {
                        int[] intValues = new int[maxNumValuesPerMVEntry];
                        for (int i = 0; i < numDocs; ++i) {
                            int length = forwardIndexReader.getIntMV(i, intValues, readerContext);
                            rangeIndexCreator.add(intValues, length);
                        }
                        break;
                    }
                    case LONG: {
                        long[] longValues = new long[maxNumValuesPerMVEntry];
                        for (int i = 0; i < numDocs; ++i) {
                            int length = forwardIndexReader.getLongMV(i, longValues, readerContext);
                            rangeIndexCreator.add(longValues, length);
                        }
                        break;
                    }
                    case FLOAT: {
                        float[] floatValues = new float[maxNumValuesPerMVEntry];
                        for (int i = 0; i < numDocs; ++i) {
                            int length = forwardIndexReader.getFloatMV(i, floatValues, readerContext);
                            rangeIndexCreator.add(floatValues, length);
                        }
                        break;
                    }
                    case DOUBLE: {
                        double[] doubleValues = new double[maxNumValuesPerMVEntry];
                        for (int i = 0; i < numDocs; ++i) {
                            int length = forwardIndexReader.getDoubleMV(i, doubleValues, readerContext);
                            rangeIndexCreator.add(doubleValues, length);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported data type: " + columnMetadata.getDataType());
                    }
                }
            }
            rangeIndexCreator.seal();
        }
    }

    private CombinedInvertedIndexCreator newRangeIndexCreator(ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build();
        RangeIndexConfig config = (RangeIndexConfig)((FieldIndexConfigs)this._fieldIndexConfigs.get(columnMetadata.getColumnName())).getConfig(StandardIndexes.range());
        return (CombinedInvertedIndexCreator)StandardIndexes.range().createIndexCreator((IndexCreationContext)context, (IndexConfig)config);
    }
}

