/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.dictionary.DictionaryIndexType;
import org.apache.pinot.segment.local.segment.index.inverted.InvertedIndexType;
import org.apache.pinot.segment.local.segment.index.loader.ForwardIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.readers.BitmapInvertedIndexReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.V1Constants;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.ForwardIndexConfig;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.utils.SegmentMetadataUtils;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvertedIndexAndDictionaryBasedForwardIndexCreator
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvertedIndexAndDictionaryBasedForwardIndexCreator.class);
    private static final int NUM_VALUES_THRESHOLD_FOR_MMAP_BUFFER = 500000000;
    private static final String FORWARD_INDEX_VALUE_BUFFER_SUFFIX = ".fwd.idx.val.buf";
    private static final String FORWARD_INDEX_LENGTH_BUFFER_SUFFIX = ".fwd.idx.len.buf";
    private static final String FORWARD_INDEX_MAX_SIZE_BUFFER_SUFFIX = ".fwd.idx.maxsize.buf";
    private final String _columnName;
    private final ForwardIndexConfig _forwardIndexConfig;
    private final SegmentDirectory.Writer _segmentWriter;
    private final boolean _isTemporaryForwardIndex;
    private final SegmentDirectory _segmentDirectory;
    private final ColumnMetadata _columnMetadata;
    private final boolean _singleValue;
    private final int _cardinality;
    private final int _numDocs;
    private final int _maxNumberOfMultiValues;
    private final FieldSpec.DataType _storedType;
    private final int _totalNumberOfEntries;
    private final boolean _dictionaryEnabled;
    private final boolean _useMMapBuffer;
    private final File _forwardIndexFile;
    private final File _forwardIndexValueBufferFile;
    private final File _forwardIndexLengthBufferFile;
    private final File _forwardIndexMaxSizeBufferFile;
    private SegmentMetadata _segmentMetadata;
    private PinotDataBuffer _forwardIndexValueBuffer;
    private PinotDataBuffer _forwardIndexLengthBuffer;
    private int _nextValueId;
    private PinotDataBuffer _forwardIndexMaxSizeBuffer;

    public InvertedIndexAndDictionaryBasedForwardIndexCreator(String columnName, SegmentDirectory segmentDirectory, boolean dictionaryEnabled, ForwardIndexConfig fwdConf, SegmentDirectory.Writer segmentWriter, boolean isTemporaryForwardIndex) throws IOException {
        this._columnName = columnName;
        this._segmentDirectory = segmentDirectory;
        this._segmentMetadata = segmentDirectory.getSegmentMetadata();
        this._segmentWriter = segmentWriter;
        this._isTemporaryForwardIndex = isTemporaryForwardIndex;
        this._columnMetadata = this._segmentMetadata.getColumnMetadataFor(columnName);
        this._singleValue = this._columnMetadata.isSingleValue();
        this._cardinality = this._columnMetadata.getCardinality();
        this._numDocs = this._columnMetadata.getTotalDocs();
        this._totalNumberOfEntries = this._columnMetadata.getTotalNumberOfEntries();
        this._maxNumberOfMultiValues = this._columnMetadata.getMaxNumberOfMultiValues();
        this._storedType = this._columnMetadata.getFieldSpec().getDataType().getStoredType();
        this._dictionaryEnabled = dictionaryEnabled;
        int numValues = this._singleValue ? this._numDocs : this._totalNumberOfEntries;
        this._useMMapBuffer = numValues > 500000000;
        File indexDir = this._segmentMetadata.getIndexDir();
        String fileExtension = this._dictionaryEnabled ? (this._singleValue ? ".sv.unsorted.fwd" : ".mv.fwd") : (this._singleValue ? ".sv.raw.fwd" : ".mv.raw.fwd");
        this._forwardIndexConfig = fwdConf;
        this._forwardIndexFile = new File(indexDir, columnName + fileExtension);
        this._forwardIndexValueBufferFile = new File(indexDir, columnName + FORWARD_INDEX_VALUE_BUFFER_SUFFIX);
        this._forwardIndexLengthBufferFile = new File(indexDir, columnName + FORWARD_INDEX_LENGTH_BUFFER_SUFFIX);
        this._forwardIndexMaxSizeBufferFile = new File(indexDir, columnName + FORWARD_INDEX_MAX_SIZE_BUFFER_SUFFIX);
        try {
            this._forwardIndexValueBuffer = this.createTempBuffer((long)numValues * 4L, this._forwardIndexValueBufferFile);
            if (!this._singleValue) {
                int i;
                this._forwardIndexLengthBuffer = this.createTempBuffer((long)this._numDocs * 4L, this._forwardIndexLengthBufferFile);
                for (i = 0; i < this._numDocs; ++i) {
                    this._forwardIndexLengthBuffer.putInt((long)i * 4L, 0);
                }
                this._forwardIndexMaxSizeBuffer = this.createTempBuffer((long)this._numDocs * 4L, this._forwardIndexMaxSizeBufferFile);
                for (i = 0; i < this._numDocs; ++i) {
                    this._forwardIndexMaxSizeBuffer.putInt((long)i * 4L, 0);
                }
            }
        }
        catch (Exception e) {
            this.destroyBuffer(this._forwardIndexValueBuffer, this._forwardIndexValueBufferFile);
            this.destroyBuffer(this._forwardIndexLengthBuffer, this._forwardIndexLengthBufferFile);
            this.destroyBuffer(this._forwardIndexMaxSizeBuffer, this._forwardIndexMaxSizeBufferFile);
            throw new IOException("Couldn't create temp buffers to construct forward index", e);
        }
    }

    public void regenerateForwardIndex() throws IOException {
        File indexDir = this._segmentMetadata.getIndexDir();
        String segmentName = this._segmentMetadata.getName();
        File inProgress = new File(indexDir, this._columnName + ".fwd.inprogress");
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)this._forwardIndexFile);
        }
        LOGGER.info("Creating a new forward index for segment: {}, column: {}, isTemporary: {}", new Object[]{segmentName, this._columnName, this._isTemporaryForwardIndex});
        Map<String, String> metadataProperties = this._singleValue ? this.createForwardIndexForSVColumn() : this.createForwardIndexForMVColumn();
        LoaderUtils.writeIndexToV3Format(this._segmentWriter, this._columnName, this._forwardIndexFile, StandardIndexes.forward());
        try {
            LOGGER.info("Created forward index from inverted index and dictionary. Updating metadata properties for segment: {}, column: {}, property list: {}, is temporary: {}", new Object[]{segmentName, this._columnName, metadataProperties, this._isTemporaryForwardIndex});
            this._segmentMetadata = SegmentMetadataUtils.updateMetadataProperties((SegmentDirectory)this._segmentDirectory, metadataProperties);
        }
        catch (Exception e) {
            throw new IOException(String.format("Failed to update metadata properties for segment: %s, column: %s", segmentName, this._columnName), e);
        }
        if (!this._isTemporaryForwardIndex && !this._dictionaryEnabled) {
            LOGGER.info("Clean up indexes no longer needed or which need to be rewritten for segment: {}, column: {}", (Object)segmentName, (Object)this._columnName);
            this._segmentWriter.removeIndex(this._columnName, StandardIndexes.dictionary());
            ForwardIndexHandler.removeDictRelatedIndexes(this._columnName, this._segmentWriter);
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created a new forward index for segment: {}, column: {}, isTemporary: {}", new Object[]{segmentName, this._columnName, this._isTemporaryForwardIndex});
    }

    private Map<String, String> createForwardIndexForSVColumn() throws IOException {
        try (BitmapInvertedIndexReader invertedIndexReader = (BitmapInvertedIndexReader)InvertedIndexType.ReaderFactory.INSTANCE.createSkippingForward((SegmentDirectory.Reader)this._segmentWriter, this._columnMetadata);){
            HashMap<String, String> hashMap;
            block13: {
                Dictionary dictionary = DictionaryIndexType.read((SegmentDirectory.Reader)this._segmentWriter, this._columnMetadata);
                try {
                    boolean isFixedWidth = this._columnMetadata.getFieldSpec().getDataType().isFixedWidth();
                    int lengthOfLongestEntry = isFixedWidth ? -1 : 0;
                    for (int dictId = 0; dictId < this._cardinality; ++dictId) {
                        ImmutableRoaringBitmap docIdsBitmap = invertedIndexReader.getDocIds(dictId);
                        int finalDictId = dictId;
                        docIdsBitmap.stream().forEach(docId -> InvertedIndexAndDictionaryBasedForwardIndexCreator.putInt(this._forwardIndexValueBuffer, docId, finalDictId));
                        if (isFixedWidth) continue;
                        lengthOfLongestEntry = this.trackLengthOfLongestEntry(dictionary, lengthOfLongestEntry, dictId);
                    }
                    IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(this._segmentMetadata.getIndexDir()).withColumnMetadata(this._columnMetadata).withForwardIndexDisabled(false).withDictionary(this._dictionaryEnabled).withLengthOfLongestEntry(lengthOfLongestEntry).build();
                    this.writeToForwardIndex(dictionary, (IndexCreationContext)context);
                    HashMap<String, String> metadataProperties = new HashMap<String, String>();
                    metadataProperties.put(V1Constants.MetadataKeys.Column.getKeyFor((String)this._columnName, (String)"hasDictionary"), String.valueOf(this._dictionaryEnabled));
                    metadataProperties.put(V1Constants.MetadataKeys.Column.getKeyFor((String)this._columnName, (String)"lengthOfEachEntry"), String.valueOf(this._dictionaryEnabled ? this._columnMetadata.getColumnMaxLength() : 0));
                    hashMap = metadataProperties;
                    if (dictionary == null) break block13;
                }
                catch (Throwable throwable) {
                    if (dictionary != null) {
                        try {
                            dictionary.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dictionary.close();
            }
            return hashMap;
        }
    }

    private Map<String, String> createForwardIndexForMVColumn() throws IOException {
        try (BitmapInvertedIndexReader invertedIndexReader = (BitmapInvertedIndexReader)InvertedIndexType.ReaderFactory.INSTANCE.createSkippingForward((SegmentDirectory.Reader)this._segmentWriter, this._columnMetadata);){
            HashMap<String, String> hashMap;
            block19: {
                Dictionary dictionary = DictionaryIndexType.read((SegmentDirectory.Reader)this._segmentWriter, this._columnMetadata);
                try {
                    int[] nArray;
                    int lengthOfLongestEntry;
                    int[] maxNumberOfMultiValues = new int[]{0};
                    boolean isFixedWidth = this._columnMetadata.getFieldSpec().getDataType().isFixedWidth();
                    int n = lengthOfLongestEntry = isFixedWidth ? -1 : 0;
                    if (isFixedWidth) {
                        int[] nArray2 = new int[1];
                        nArray = nArray2;
                        nArray2[0] = -1;
                    } else {
                        int[] nArray3 = new int[1];
                        nArray = nArray3;
                        nArray3[0] = 0;
                    }
                    int[] maxRowLengthInBytes = nArray;
                    for (int dictId = 0; dictId < this._cardinality; ++dictId) {
                        ImmutableRoaringBitmap docIdsBitmap = invertedIndexReader.getDocIds(dictId);
                        docIdsBitmap.stream().forEach(docId -> {
                            int newRowLength = InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexLengthBuffer, docId) + 1;
                            maxNumberOfMultiValues[0] = Math.max(maxNumberOfMultiValues[0], newRowLength);
                            InvertedIndexAndDictionaryBasedForwardIndexCreator.putInt(this._forwardIndexLengthBuffer, docId, newRowLength);
                            ++this._nextValueId;
                        });
                        if (isFixedWidth) continue;
                        lengthOfLongestEntry = this.trackLengthOfLongestEntry(dictionary, lengthOfLongestEntry, dictId);
                    }
                    if (this._nextValueId < this._totalNumberOfEntries) {
                        LOGGER.warn("Total number of entries: {} less than expected total number of entries: {}, multi-value column: {} duplicates detected, duplicate entries within each row lost! Expected maxNumberOfMultiValues: {}, actual maxNumberOfMultiValues: {}", new Object[]{this._nextValueId, this._totalNumberOfEntries, this._columnName, this._maxNumberOfMultiValues, maxNumberOfMultiValues[0]});
                    } else {
                        Preconditions.checkState((this._nextValueId == this._totalNumberOfEntries ? 1 : 0) != 0, (Object)String.format("Number of entries found %d cannot be higher than expected total number of entries: %d for column: %s", this._nextValueId, this._totalNumberOfEntries, this._columnName));
                        Preconditions.checkState((maxNumberOfMultiValues[0] == this._maxNumberOfMultiValues ? 1 : 0) != 0, (Object)String.format("Actual maxNumberOfMultiValues: %d doesn't match expected maxNumberOfMultiValues: %d for column %s", maxNumberOfMultiValues[0], this._maxNumberOfMultiValues, this._columnName));
                    }
                    int forwardValueIndex = 0;
                    for (int docId2 = 0; docId2 < this._numDocs; ++docId2) {
                        int length = InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexLengthBuffer, docId2);
                        InvertedIndexAndDictionaryBasedForwardIndexCreator.putInt(this._forwardIndexLengthBuffer, docId2, forwardValueIndex);
                        forwardValueIndex += length;
                    }
                    int dictId = 0;
                    while (dictId < this._cardinality) {
                        ImmutableRoaringBitmap docIdsBitmap = invertedIndexReader.getDocIds(dictId);
                        int finalDictId = dictId++;
                        docIdsBitmap.stream().forEach(docId -> {
                            int index = InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexLengthBuffer, docId);
                            InvertedIndexAndDictionaryBasedForwardIndexCreator.putInt(this._forwardIndexValueBuffer, index, finalDictId);
                            InvertedIndexAndDictionaryBasedForwardIndexCreator.putInt(this._forwardIndexLengthBuffer, docId, index + 1);
                            if (!isFixedWidth) {
                                this.trackMaxRowLengthInBytes(dictionary, maxRowLengthInBytes, docId, finalDictId);
                            }
                        });
                    }
                    IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(this._segmentMetadata.getIndexDir()).withColumnMetadata(this._columnMetadata).withForwardIndexDisabled(false).withDictionary(this._dictionaryEnabled).withTotalNumberOfEntries(this._nextValueId).withMaxNumberOfMultiValueElements(maxNumberOfMultiValues[0]).withMaxRowLengthInBytes(maxRowLengthInBytes[0]).withLengthOfLongestEntry(lengthOfLongestEntry).build();
                    this.writeToForwardIndex(dictionary, (IndexCreationContext)context);
                    HashMap<String, String> metadataProperties = new HashMap<String, String>();
                    metadataProperties.put(V1Constants.MetadataKeys.Column.getKeyFor((String)this._columnName, (String)"hasDictionary"), String.valueOf(this._dictionaryEnabled));
                    metadataProperties.put(V1Constants.MetadataKeys.Column.getKeyFor((String)this._columnName, (String)"lengthOfEachEntry"), String.valueOf(this._dictionaryEnabled ? this._columnMetadata.getColumnMaxLength() : 0));
                    metadataProperties.put(V1Constants.MetadataKeys.Column.getKeyFor((String)this._columnName, (String)"maxNumberOfMultiValues"), String.valueOf(maxNumberOfMultiValues[0]));
                    metadataProperties.put(V1Constants.MetadataKeys.Column.getKeyFor((String)this._columnName, (String)"totalNumberOfEntries"), String.valueOf(this._nextValueId));
                    hashMap = metadataProperties;
                    if (dictionary == null) break block19;
                }
                catch (Throwable throwable) {
                    if (dictionary != null) {
                        try {
                            dictionary.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dictionary.close();
            }
            return hashMap;
        }
    }

    private int trackLengthOfLongestEntry(Dictionary dictionary, int lengthOfLongestEntry, int dictId) {
        int updatedLengthOfLongestEntry;
        switch (this._storedType) {
            case STRING: {
                updatedLengthOfLongestEntry = Math.max(dictionary.getStringValue(dictId).getBytes(StandardCharsets.UTF_8).length, lengthOfLongestEntry);
                break;
            }
            case BYTES: {
                ByteArray value = new ByteArray(dictionary.getBytesValue(dictId));
                updatedLengthOfLongestEntry = Math.max(value.length(), lengthOfLongestEntry);
                break;
            }
            case BIG_DECIMAL: {
                updatedLengthOfLongestEntry = Math.max(BigDecimalUtils.byteSize((BigDecimal)dictionary.getBigDecimalValue(dictId)), lengthOfLongestEntry);
                break;
            }
            default: {
                throw new IllegalStateException("Trying to calculate lengthOfLongestEntry for invalid stored type: " + this._storedType);
            }
        }
        return updatedLengthOfLongestEntry;
    }

    private void trackMaxRowLengthInBytes(Dictionary dictionary, int[] maxRowLengthInBytes, int docId, int dictId) {
        int curSizeOfRow = InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexMaxSizeBuffer, docId);
        switch (this._storedType) {
            case STRING: {
                int newSizeOfEntry = dictionary.getStringValue(dictId).length() + curSizeOfRow;
                InvertedIndexAndDictionaryBasedForwardIndexCreator.putInt(this._forwardIndexMaxSizeBuffer, docId, newSizeOfEntry);
                maxRowLengthInBytes[0] = Math.max(newSizeOfEntry, maxRowLengthInBytes[0]);
                break;
            }
            case BYTES: {
                ByteArray value = new ByteArray(dictionary.getBytesValue(dictId));
                int newSizeOfEntry = value.length() + curSizeOfRow;
                InvertedIndexAndDictionaryBasedForwardIndexCreator.putInt(this._forwardIndexMaxSizeBuffer, docId, newSizeOfEntry);
                maxRowLengthInBytes[0] = Math.max(newSizeOfEntry, maxRowLengthInBytes[0]);
                break;
            }
            case BIG_DECIMAL: {
                int newSizeOfEntry = BigDecimalUtils.byteSize((BigDecimal)dictionary.getBigDecimalValue(dictId)) + curSizeOfRow;
                InvertedIndexAndDictionaryBasedForwardIndexCreator.putInt(this._forwardIndexMaxSizeBuffer, docId, newSizeOfEntry);
                maxRowLengthInBytes[0] = Math.max(newSizeOfEntry, maxRowLengthInBytes[0]);
                break;
            }
            default: {
                throw new IllegalStateException("Trying to calculate maxRowLengthInBytes for invalid stored type: " + this._storedType);
            }
        }
    }

    private void writeToForwardIndex(Dictionary dictionary, IndexCreationContext context) throws IOException {
        block57: {
            try (ForwardIndexCreator creator = (ForwardIndexCreator)StandardIndexes.forward().createIndexCreator(context, (IndexConfig)this._forwardIndexConfig);){
                if (this._dictionaryEnabled) {
                    if (this._singleValue) {
                        for (int docId = 0; docId < this._numDocs; ++docId) {
                            creator.putDictId(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, docId));
                        }
                    } else {
                        int startIdx = 0;
                        for (int docId = 0; docId < this._numDocs; ++docId) {
                            int endIdx = InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexLengthBuffer, docId);
                            int[] values = new int[endIdx - startIdx];
                            int valuesIdx = 0;
                            for (int i = startIdx; i < endIdx; ++i) {
                                values[valuesIdx++] = InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, i);
                            }
                            creator.putDictIdMV(values);
                            startIdx = endIdx;
                        }
                    }
                    break block57;
                }
                switch (creator.getValueType()) {
                    case INT: {
                        if (this._singleValue) {
                            for (int docId = 0; docId < this._numDocs; ++docId) {
                                creator.putInt(dictionary.getIntValue(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, docId)));
                            }
                        } else {
                            int startIdx = 0;
                            for (int docId = 0; docId < this._numDocs; ++docId) {
                                int endIdx = InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexLengthBuffer, docId);
                                int[] values = new int[endIdx - startIdx];
                                int valuesIdx = 0;
                                for (int i = startIdx; i < endIdx; ++i) {
                                    values[valuesIdx++] = dictionary.getIntValue(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, i));
                                }
                                creator.putIntMV(values);
                                startIdx = endIdx;
                            }
                        }
                        break;
                    }
                    case LONG: {
                        if (this._singleValue) {
                            for (int docId = 0; docId < this._numDocs; ++docId) {
                                creator.putLong(dictionary.getLongValue(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, docId)));
                            }
                        } else {
                            int startIdx = 0;
                            for (int docId = 0; docId < this._numDocs; ++docId) {
                                int endIdx = InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexLengthBuffer, docId);
                                long[] values = new long[endIdx - startIdx];
                                int valuesIdx = 0;
                                for (int i = startIdx; i < endIdx; ++i) {
                                    values[valuesIdx++] = dictionary.getLongValue(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, i));
                                }
                                creator.putLongMV(values);
                                startIdx = endIdx;
                            }
                        }
                        break;
                    }
                    case FLOAT: {
                        if (this._singleValue) {
                            for (int docId = 0; docId < this._numDocs; ++docId) {
                                creator.putFloat(dictionary.getFloatValue(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, docId)));
                            }
                        } else {
                            int startIdx = 0;
                            for (int docId = 0; docId < this._numDocs; ++docId) {
                                int endIdx = InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexLengthBuffer, docId);
                                float[] values = new float[endIdx - startIdx];
                                int valuesIdx = 0;
                                for (int i = startIdx; i < endIdx; ++i) {
                                    values[valuesIdx++] = dictionary.getFloatValue(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, i));
                                }
                                creator.putFloatMV(values);
                                startIdx = endIdx;
                            }
                        }
                        break;
                    }
                    case DOUBLE: {
                        if (this._singleValue) {
                            for (int docId = 0; docId < this._numDocs; ++docId) {
                                creator.putDouble(dictionary.getDoubleValue(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, docId)));
                            }
                        } else {
                            int startIdx = 0;
                            for (int docId = 0; docId < this._numDocs; ++docId) {
                                int endIdx = InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexLengthBuffer, docId);
                                double[] values = new double[endIdx - startIdx];
                                int valuesIdx = 0;
                                for (int i = startIdx; i < endIdx; ++i) {
                                    values[valuesIdx++] = dictionary.getDoubleValue(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, i));
                                }
                                creator.putDoubleMV(values);
                                startIdx = endIdx;
                            }
                        }
                        break;
                    }
                    case STRING: {
                        if (this._singleValue) {
                            for (int docId = 0; docId < this._numDocs; ++docId) {
                                creator.putString(dictionary.getStringValue(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, docId)));
                            }
                        } else {
                            int startIdx = 0;
                            for (int docId = 0; docId < this._numDocs; ++docId) {
                                int endIdx = InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexLengthBuffer, docId);
                                String[] values = new String[endIdx - startIdx];
                                int valuesIdx = 0;
                                for (int i = startIdx; i < endIdx; ++i) {
                                    values[valuesIdx++] = dictionary.getStringValue(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, i));
                                }
                                creator.putStringMV(values);
                                startIdx = endIdx;
                            }
                        }
                        break;
                    }
                    case BYTES: {
                        if (this._singleValue) {
                            for (int docId = 0; docId < this._numDocs; ++docId) {
                                creator.putBytes(dictionary.getBytesValue(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, docId)));
                            }
                        } else {
                            int startIdx = 0;
                            for (int docId = 0; docId < this._numDocs; ++docId) {
                                int endIdx = InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexLengthBuffer, docId);
                                byte[][] values = new byte[endIdx - startIdx][];
                                int valuesIdx = 0;
                                for (int i = startIdx; i < endIdx; ++i) {
                                    values[valuesIdx++] = dictionary.getBytesValue(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, i));
                                }
                                creator.putBytesMV((byte[][])values);
                                startIdx = endIdx;
                            }
                        }
                        break;
                    }
                    case BIG_DECIMAL: {
                        Preconditions.checkState((boolean)this._singleValue, (Object)"BIG_DECIMAL type not supported for multi-value columns");
                        for (int docId = 0; docId < this._numDocs; ++docId) {
                            creator.putBigDecimal(dictionary.getBigDecimalValue(InvertedIndexAndDictionaryBasedForwardIndexCreator.getInt(this._forwardIndexValueBuffer, docId)));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid type" + creator.getValueType() + " cannot create forward index");
                    }
                }
            }
            catch (Exception e) {
                throw new IOException(String.format("Cannot create the forward index from inverted index for column %s", this._columnName), e);
            }
            finally {
                this.destroyBuffer(this._forwardIndexValueBuffer, this._forwardIndexValueBufferFile);
                this.destroyBuffer(this._forwardIndexLengthBuffer, this._forwardIndexLengthBufferFile);
                this.destroyBuffer(this._forwardIndexMaxSizeBuffer, this._forwardIndexMaxSizeBufferFile);
            }
        }
    }

    private static void putInt(PinotDataBuffer buffer, long index, int value) {
        buffer.putInt(index << 2, value);
    }

    private static int getInt(PinotDataBuffer buffer, long index) {
        return buffer.getInt(index << 2);
    }

    private PinotDataBuffer createTempBuffer(long size, File mmapFile) throws IOException {
        if (this._useMMapBuffer) {
            return PinotDataBuffer.mapFile((File)mmapFile, (boolean)false, (long)0L, (long)size, (ByteOrder)PinotDataBuffer.NATIVE_ORDER, (String)("InvertedIndexAndDictionaryBasedForwardIndexCreator: temp mmapped buffer for " + mmapFile.getName()));
        }
        return PinotDataBuffer.allocateDirect((long)size, (ByteOrder)PinotDataBuffer.NATIVE_ORDER, (String)("InvertedIndexAndDictionaryBasedForwardIndexCreator: temp direct buffer for " + mmapFile.getName()));
    }

    private void destroyBuffer(PinotDataBuffer buffer, File mmapFile) throws IOException {
        if (buffer != null) {
            buffer.close();
        }
        if (mmapFile.exists()) {
            FileUtils.forceDelete((File)mmapFile);
        }
    }

    @Override
    public void close() throws Exception {
        this.destroyBuffer(this._forwardIndexValueBuffer, this._forwardIndexValueBufferFile);
        this.destroyBuffer(this._forwardIndexLengthBuffer, this._forwardIndexLengthBufferFile);
        this.destroyBuffer(this._forwardIndexMaxSizeBuffer, this._forwardIndexMaxSizeBufferFile);
    }
}

