/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.datasource;

import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.H3IndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.apache.pinot.segment.spi.index.reader.RangeIndexReader;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.segment.spi.index.reader.VectorIndexReader;

public abstract class BaseDataSource
implements DataSource {
    private final DataSourceMetadata _dataSourceMetadata;
    private final ColumnIndexContainer _indexContainer;

    public BaseDataSource(DataSourceMetadata dataSourceMetadata, ColumnIndexContainer indexContainer) {
        this._dataSourceMetadata = dataSourceMetadata;
        this._indexContainer = indexContainer;
    }

    public DataSourceMetadata getDataSourceMetadata() {
        return this._dataSourceMetadata;
    }

    public <R extends IndexReader> R getIndex(IndexType<?, R, ?> type) {
        return (R)type.getIndexReader(this._indexContainer);
    }

    public ForwardIndexReader<?> getForwardIndex() {
        return (ForwardIndexReader)this.getIndex(StandardIndexes.forward());
    }

    @Nullable
    public Dictionary getDictionary() {
        return (Dictionary)this.getIndex(StandardIndexes.dictionary());
    }

    @Nullable
    public InvertedIndexReader<?> getInvertedIndex() {
        return (InvertedIndexReader)this.getIndex(StandardIndexes.inverted());
    }

    @Nullable
    public RangeIndexReader<?> getRangeIndex() {
        return (RangeIndexReader)this.getIndex(StandardIndexes.range());
    }

    @Nullable
    public TextIndexReader getTextIndex() {
        return (TextIndexReader)this.getIndex(StandardIndexes.text());
    }

    @Nullable
    public TextIndexReader getFSTIndex() {
        return (TextIndexReader)this.getIndex(StandardIndexes.fst());
    }

    @Nullable
    public JsonIndexReader getJsonIndex() {
        return (JsonIndexReader)this.getIndex(StandardIndexes.json());
    }

    @Nullable
    public H3IndexReader getH3Index() {
        return (H3IndexReader)this.getIndex(StandardIndexes.h3());
    }

    @Nullable
    public BloomFilterReader getBloomFilter() {
        return (BloomFilterReader)this.getIndex(StandardIndexes.bloomFilter());
    }

    @Nullable
    public NullValueVectorReader getNullValueVector() {
        return (NullValueVectorReader)this.getIndex(StandardIndexes.nullValueVector());
    }

    @Nullable
    public VectorIndexReader getVectorIndex() {
        return (VectorIndexReader)this.getIndex(StandardIndexes.vector());
    }
}

