/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.bloom;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.pinot.segment.local.segment.index.readers.bloom.GuavaBloomFilterReaderUtils;
import org.apache.pinot.segment.spi.index.creator.BloomFilterCreator;
import org.apache.pinot.spi.config.table.BloomFilterConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnHeapGuavaBloomFilterCreator
implements BloomFilterCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnHeapGuavaBloomFilterCreator.class);
    public static final int TYPE_VALUE = 1;
    public static final int VERSION = 1;
    private final File _bloomFilterFile;
    private final BloomFilter<String> _bloomFilter;
    private final FieldSpec.DataType _dataType;

    @Deprecated
    public OnHeapGuavaBloomFilterCreator(File indexDir, String columnName, int cardinality, BloomFilterConfig bloomFilterConfig) {
        this(indexDir, columnName, cardinality, bloomFilterConfig, null);
    }

    public OnHeapGuavaBloomFilterCreator(File indexDir, String columnName, int cardinality, BloomFilterConfig bloomFilterConfig, FieldSpec.DataType dataType) {
        this._dataType = dataType;
        this._bloomFilterFile = new File(indexDir, columnName + ".bloom");
        double fpp = bloomFilterConfig.getFpp();
        int maxSizeInBytes = bloomFilterConfig.getMaxSizeInBytes();
        if (maxSizeInBytes > 0) {
            double minFpp = GuavaBloomFilterReaderUtils.computeFPP(maxSizeInBytes, cardinality);
            fpp = Math.max(fpp, minFpp);
        }
        LOGGER.info("Creating bloom filter with cardinality: {}, fpp: {}", (Object)cardinality, (Object)fpp);
        this._bloomFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)StandardCharsets.UTF_8), (int)cardinality, (double)fpp);
    }

    public FieldSpec.DataType getDataType() {
        return this._dataType;
    }

    public void add(String value) {
        this._bloomFilter.put((Object)value);
    }

    public void seal() throws IOException {
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this._bloomFilterFile));){
            out.writeInt(1);
            out.writeInt(1);
            this._bloomFilter.writeTo((OutputStream)out);
        }
    }

    public void close() {
    }
}

