/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.function.scalar.JsonFunctions;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.ComplexTypeConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexTypeTransformer
implements RecordTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComplexTypeTransformer.class);
    public static final String DEFAULT_DELIMITER = ".";
    public static final ComplexTypeConfig.CollectionNotUnnestedToJson DEFAULT_COLLECTION_TO_JSON_MODE = ComplexTypeConfig.CollectionNotUnnestedToJson.NON_PRIMITIVE;
    private final List<String> _fieldsToUnnest;
    private final String _delimiter;
    private final ComplexTypeConfig.CollectionNotUnnestedToJson _collectionNotUnnestedToJson;
    private final Map<String, String> _prefixesToRename;
    private final boolean _continueOnError;

    public ComplexTypeTransformer(TableConfig tableConfig) {
        this(ComplexTypeTransformer.parseFieldsToUnnest(tableConfig), ComplexTypeTransformer.parseDelimiter(tableConfig), ComplexTypeTransformer.parseCollectionNotUnnestedToJson(tableConfig), ComplexTypeTransformer.parsePrefixesToRename(tableConfig), tableConfig);
    }

    @VisibleForTesting
    ComplexTypeTransformer(List<String> fieldsToUnnest, String delimiter) {
        this(fieldsToUnnest, delimiter, DEFAULT_COLLECTION_TO_JSON_MODE, Collections.emptyMap(), null);
    }

    @VisibleForTesting
    ComplexTypeTransformer(List<String> fieldsToUnnest, String delimiter, ComplexTypeConfig.CollectionNotUnnestedToJson collectionNotUnnestedToJson, Map<String, String> prefixesToRename, TableConfig tableConfig) {
        this._fieldsToUnnest = new ArrayList<String>(fieldsToUnnest);
        this._delimiter = delimiter;
        this._collectionNotUnnestedToJson = collectionNotUnnestedToJson;
        Collections.sort(this._fieldsToUnnest);
        this._prefixesToRename = prefixesToRename;
        this._continueOnError = tableConfig != null && tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().isContinueOnError();
    }

    private static List<String> parseFieldsToUnnest(TableConfig tableConfig) {
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig().getFieldsToUnnest() != null) {
            return tableConfig.getIngestionConfig().getComplexTypeConfig().getFieldsToUnnest();
        }
        return new ArrayList<String>();
    }

    private static String parseDelimiter(TableConfig tableConfig) {
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig().getDelimiter() != null) {
            return tableConfig.getIngestionConfig().getComplexTypeConfig().getDelimiter();
        }
        return DEFAULT_DELIMITER;
    }

    @Nullable
    public static ComplexTypeTransformer getComplexTypeTransformer(TableConfig tableConfig) {
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig() != null) {
            return new ComplexTypeTransformer(tableConfig);
        }
        return null;
    }

    private static ComplexTypeConfig.CollectionNotUnnestedToJson parseCollectionNotUnnestedToJson(TableConfig tableConfig) {
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig().getCollectionNotUnnestedToJson() != null) {
            return tableConfig.getIngestionConfig().getComplexTypeConfig().getCollectionNotUnnestedToJson();
        }
        return DEFAULT_COLLECTION_TO_JSON_MODE;
    }

    private static Map<String, String> parsePrefixesToRename(TableConfig tableConfig) {
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig().getPrefixesToRename() != null) {
            return tableConfig.getIngestionConfig().getComplexTypeConfig().getPrefixesToRename();
        }
        return Collections.emptyMap();
    }

    @Override
    public GenericRow transform(GenericRow record) {
        try {
            GenericRow originalRow = this._fieldsToUnnest.isEmpty() ? null : record.copy(this._fieldsToUnnest);
            this.flattenMap(record, new ArrayList<String>(record.getFieldToValueMap().keySet()));
            for (String field : this._fieldsToUnnest) {
                this.unnestCollection(record, field);
            }
            Object unnestedRows = record.getValue("$MULTIPLE_RECORDS_KEY$");
            if (originalRow != null && unnestedRows instanceof Collection) {
                for (GenericRow unnestedRow : (Collection)unnestedRows) {
                    for (String field : this._fieldsToUnnest) {
                        unnestedRow.putValue(field, originalRow.getValue(field));
                    }
                }
            }
            this.renamePrefixes(record);
        }
        catch (Exception e) {
            if (!this._continueOnError) {
                throw new RuntimeException("Caught exception while transforming complex types", e);
            }
            LOGGER.debug("Caught exception while transforming complex types for record: {}", (Object)record.toString(), (Object)e);
            record.putValue("$INCOMPLETE_RECORD_KEY$", (Object)true);
        }
        return record;
    }

    private GenericRow unnestCollection(GenericRow record, String column) {
        Object value = record.getValue("$MULTIPLE_RECORDS_KEY$");
        if (value == null) {
            ArrayList<GenericRow> list = new ArrayList<GenericRow>();
            this.unnestCollection(record, column, list);
            record.putValue("$MULTIPLE_RECORDS_KEY$", list);
        } else {
            Collection records = (Collection)value;
            ArrayList<GenericRow> list = new ArrayList<GenericRow>();
            for (GenericRow innerRecord : records) {
                this.unnestCollection(innerRecord, column, list);
            }
            record.putValue("$MULTIPLE_RECORDS_KEY$", list);
        }
        return record;
    }

    private void unnestCollection(GenericRow record, String column, List<GenericRow> list) {
        block7: {
            Object value;
            block8: {
                block6: {
                    value = record.getValue(column);
                    if (value != null) break block6;
                    list.add(record);
                    break block7;
                }
                if (!(value instanceof Collection)) break block8;
                if (((Collection)value).isEmpty()) {
                    list.add(record);
                } else {
                    for (Object obj : (Collection)value) {
                        GenericRow copy = this.flattenCollectionItem(record, obj, column);
                        list.add(copy);
                    }
                }
                break block7;
            }
            if (!ComplexTypeTransformer.isNonPrimitiveArray(value)) break block7;
            if (((Object[])value).length == 0) {
                list.add(record);
            } else {
                for (Object obj : (Object[])value) {
                    GenericRow copy = this.flattenCollectionItem(record, obj, column);
                    list.add(copy);
                }
            }
        }
    }

    private GenericRow flattenCollectionItem(GenericRow record, Object obj, String column) {
        GenericRow copy = record.copy();
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                String flattenName = this.concat(column, (String)entry.getKey());
                copy.putValue(flattenName, entry.getValue());
            }
        } else {
            copy.putValue(column, obj);
        }
        return copy;
    }

    @VisibleForTesting
    protected void flattenMap(GenericRow record, List<String> columns) {
        for (String column : columns) {
            String jsonString;
            Object value = record.getValue(column);
            if (value instanceof Map) {
                Map map = (Map)value;
                ArrayList mapColumns = new ArrayList();
                for (Map.Entry entry : new ArrayList(map.entrySet())) {
                    String flattenName = this.concat(column, (String)entry.getKey());
                    Object nestedValue = entry.getValue();
                    record.putValue(flattenName, nestedValue);
                    if (!(nestedValue instanceof Map) && !(nestedValue instanceof Collection) && !ComplexTypeTransformer.isNonPrimitiveArray(nestedValue)) continue;
                    mapColumns.add(flattenName);
                }
                this.flattenMap(record, mapColumns);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (this._fieldsToUnnest.contains(column)) {
                    for (Object inner : collection) {
                        if (!(inner instanceof Map)) continue;
                        Map innerMap = (Map)inner;
                        this.flattenMap(column, innerMap, new ArrayList<String>(innerMap.keySet()));
                    }
                    continue;
                }
                if (!this.shallConvertToJson(collection)) continue;
                try {
                    jsonString = JsonFunctions.jsonFormat((Object)collection);
                    record.putValue(column, (Object)jsonString);
                    continue;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(String.format("Caught exception while converting value to JSON string %s", value), e);
                }
            }
            if (!ComplexTypeTransformer.isNonPrimitiveArray(value)) continue;
            Object[] array = (Object[])value;
            if (this._fieldsToUnnest.contains(column)) {
                for (Object inner : array) {
                    if (!(inner instanceof Map)) continue;
                    Map innerMap = (Map)inner;
                    this.flattenMap(column, innerMap, new ArrayList<String>(innerMap.keySet()));
                }
                continue;
            }
            if (!this.shallConvertToJson(array)) continue;
            try {
                jsonString = JsonFunctions.jsonFormat((Object)array);
                record.putValue(column, (Object)jsonString);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(String.format("Caught exception while converting value to JSON string %s", value), e);
            }
        }
    }

    @VisibleForTesting
    protected void renamePrefixes(GenericRow record) {
        if (this._prefixesToRename.isEmpty()) {
            return;
        }
        ArrayList fields = new ArrayList(record.getFieldToValueMap().keySet());
        for (Map.Entry<String, String> entry : this._prefixesToRename.entrySet()) {
            for (String field : fields) {
                String prefix = entry.getKey();
                String replacementPrefix = entry.getValue();
                if (!field.startsWith(prefix)) continue;
                Object value = record.removeValue(field);
                String remainingColumnName = field.substring(prefix.length());
                String newName = replacementPrefix + remainingColumnName;
                if (newName.isEmpty() || record.getValue(newName) != null) {
                    throw new RuntimeException(String.format("Name conflict after attempting to rename field %s to %s", field, newName));
                }
                record.putValue(newName, value);
            }
        }
    }

    private boolean containPrimitives(Object[] value) {
        if (value.length == 0) {
            return true;
        }
        Object element = value[0];
        return !(element instanceof Map) && !(element instanceof Collection) && !ComplexTypeTransformer.isNonPrimitiveArray(element);
    }

    private boolean containPrimitives(Collection value) {
        if (value.isEmpty()) {
            return true;
        }
        Object element = value.iterator().next();
        return !(element instanceof Map) && !(element instanceof Collection) && !ComplexTypeTransformer.isNonPrimitiveArray(element);
    }

    protected static boolean isNonPrimitiveArray(Object obj) {
        return obj instanceof Object[];
    }

    private void flattenMap(String path, Map<String, Object> map, Collection<String> fields) {
        for (String field : fields) {
            String jsonString;
            Object value = map.get(field);
            String concatName = this.concat(path, field);
            if (value instanceof Map) {
                Map innerMap = (Map)value;
                ArrayList innerMapFields = new ArrayList();
                for (Map.Entry innerEntry : new ArrayList(innerMap.entrySet())) {
                    Object innerValue = innerEntry.getValue();
                    String innerConcatName = this.concat(field, (String)innerEntry.getKey());
                    map.put(innerConcatName, innerEntry.getValue());
                    if (!(innerValue instanceof Map) && !(innerValue instanceof Collection) && !ComplexTypeTransformer.isNonPrimitiveArray(innerValue)) continue;
                    innerMapFields.add(innerConcatName);
                }
                if (innerMapFields.isEmpty()) continue;
                this.flattenMap(path, map, innerMapFields);
                continue;
            }
            if (value instanceof Collection && this._fieldsToUnnest.contains(concatName)) {
                Collection collection = (Collection)value;
                if (this._fieldsToUnnest.contains(concatName)) {
                    for (Object inner : (Collection)value) {
                        if (!(inner instanceof Map)) continue;
                        Map innerMap = (Map)inner;
                        this.flattenMap(concatName, innerMap, new ArrayList<String>(innerMap.keySet()));
                    }
                    continue;
                }
                if (!this.shallConvertToJson(collection)) continue;
                try {
                    jsonString = JsonFunctions.jsonFormat((Object)collection);
                    map.put(field, jsonString);
                    continue;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(String.format("Caught exception while converting value to JSON string %s", value), e);
                }
            }
            if (!ComplexTypeTransformer.isNonPrimitiveArray(value)) continue;
            Object[] array = (Object[])value;
            if (this._fieldsToUnnest.contains(concatName)) {
                for (Object inner : (Object[])value) {
                    if (!(inner instanceof Map)) continue;
                    Map innerMap = (Map)inner;
                    this.flattenMap(concatName, innerMap, new ArrayList<String>(innerMap.keySet()));
                }
                continue;
            }
            if (!this.shallConvertToJson(array)) continue;
            try {
                jsonString = JsonFunctions.jsonFormat((Object)array);
                map.put(field, jsonString);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(String.format("Caught exception while converting value to JSON string %s", value), e);
            }
        }
    }

    private boolean shallConvertToJson(Object[] value) {
        switch (this._collectionNotUnnestedToJson) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
            case NON_PRIMITIVE: {
                return !this.containPrimitives(value);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported collectionNotUnnestedToJson %s", this._collectionNotUnnestedToJson));
    }

    private boolean shallConvertToJson(Collection value) {
        switch (this._collectionNotUnnestedToJson) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
            case NON_PRIMITIVE: {
                return !this.containPrimitives(value);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported collectionNotUnnestedToJson %s", this._collectionNotUnnestedToJson));
    }

    private String concat(String left, String right) {
        return String.join((CharSequence)this._delimiter, left, right);
    }
}

