/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.vector;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.pinot.segment.local.segment.creator.impl.vector.XKnnFloatVectorField;
import org.apache.pinot.segment.local.segment.store.VectorIndexUtils;
import org.apache.pinot.segment.spi.index.creator.VectorIndexConfig;
import org.apache.pinot.segment.spi.index.mutable.MutableIndex;
import org.apache.pinot.segment.spi.index.reader.VectorIndexReader;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableVectorIndex
implements VectorIndexReader,
MutableIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutableVectorIndex.class);
    public static final String VECTOR_INDEX_DOC_ID_COLUMN_NAME = "DocID";
    public static final long DEFAULT_COMMIT_INTERVAL_MS = 10000L;
    public static final long DEFAULT_COMMIT_DOCS = 1000L;
    private final int _vectorDimension;
    private final VectorSimilarityFunction _vectorSimilarityFunction;
    private final IndexWriter _indexWriter;
    private final String _vectorColumn;
    private final String _segmentName;
    private final long _commitIntervalMs;
    private final long _commitDocs;
    private final File _indexDir;
    private final FSDirectory _indexDirectory;
    private int _nextDocId;
    private long _lastCommitTime;

    public MutableVectorIndex(String segmentName, String vectorColumn, VectorIndexConfig vectorIndexConfig) {
        this._vectorColumn = vectorColumn;
        this._vectorDimension = vectorIndexConfig.getVectorDimension();
        this._segmentName = segmentName;
        this._commitIntervalMs = Long.parseLong(vectorIndexConfig.getProperties().getOrDefault("commitIntervalMs", String.valueOf(10000L)));
        this._commitDocs = Long.parseLong(vectorIndexConfig.getProperties().getOrDefault("commitDocs", String.valueOf(1000L)));
        this._vectorSimilarityFunction = VectorIndexUtils.toSimilarityFunction(vectorIndexConfig.getVectorDistanceFunction());
        try {
            this._indexDir = new File(FileUtils.getTempDirectory(), segmentName);
            this._indexDirectory = FSDirectory.open((Path)new File(this._indexDir, this._vectorColumn + ".vector.v99.hnsw.index").toPath());
            LOGGER.info("Creating mutable HNSW index for segment: {}, column: {} at path: {} with {}", new Object[]{segmentName, vectorColumn, this._indexDir.getAbsolutePath(), vectorIndexConfig.getProperties()});
            this._indexWriter = new IndexWriter((Directory)this._indexDirectory, VectorIndexUtils.getIndexWriterConfig(vectorIndexConfig));
            this._indexWriter.commit();
            this._lastCommitTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while instantiating the LuceneTextIndexCreator for column: " + vectorColumn, e);
        }
    }

    public void add(@Nonnull Object value, int dictId, int docId) {
        throw new UnsupportedOperationException("Mutable Vector indexes are not supported for single-valued columns");
    }

    public void add(@Nonnull Object[] values, @Nullable int[] dictIds, int docId) {
        float[] floatValues = new float[this._vectorDimension];
        for (int i = 0; i < values.length; ++i) {
            floatValues[i] = ((Float)values[i]).floatValue();
        }
        Document docToIndex = new Document();
        XKnnFloatVectorField xKnnFloatVectorField = new XKnnFloatVectorField(this._vectorColumn, floatValues, this._vectorSimilarityFunction);
        docToIndex.add((IndexableField)xKnnFloatVectorField);
        docToIndex.add((IndexableField)new StoredField(VECTOR_INDEX_DOC_ID_COLUMN_NAME, this._nextDocId++));
        try {
            this._indexWriter.addDocument((Iterable)docToIndex);
            if (this._lastCommitTime + this._commitIntervalMs < System.currentTimeMillis() || (long)this._nextDocId % this._commitDocs == 0L) {
                this._indexWriter.commit();
                this._lastCommitTime = System.currentTimeMillis();
                LOGGER.debug("Committed index for column: {}, segment: {}", (Object)this._vectorColumn, (Object)this._segmentName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while adding a new document to the Lucene index for column: " + this._vectorColumn, e);
        }
    }

    public MutableRoaringBitmap getDocIds(float[] vector, int topK) {
        MutableRoaringBitmap docIds;
        try {
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)this._indexDirectory));
            KnnFloatVectorQuery query = new KnnFloatVectorQuery(this._vectorColumn, vector, topK);
            docIds = new MutableRoaringBitmap();
            TopDocs search = indexSearcher.search((Query)query, topK);
            Arrays.stream(search.scoreDocs).map(scoreDoc -> scoreDoc.doc).forEach(arg_0 -> ((MutableRoaringBitmap)docIds).add(arg_0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return docIds;
    }

    public void close() {
        try {
            this._indexWriter.commit();
            this._indexWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.deleteQuietly((File)this._indexDir);
        }
    }
}

