/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.json;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.NotEqPredicate;
import org.apache.pinot.common.request.context.predicate.NotInPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.common.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.common.utils.regex.Pattern;
import org.apache.pinot.segment.spi.index.mutable.MutableJsonIndex;
import org.apache.pinot.spi.config.table.JsonIndexConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.apache.pinot.spi.trace.Tracing;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class MutableJsonIndexImpl
implements MutableJsonIndex {
    private final JsonIndexConfig _jsonIndexConfig;
    private final TreeMap<String, RoaringBitmap> _postingListMap;
    private final IntList _docIdMapping;
    private final ReentrantReadWriteLock.ReadLock _readLock;
    private final ReentrantReadWriteLock.WriteLock _writeLock;
    private int _nextDocId;
    private int _nextFlattenedDocId;

    public MutableJsonIndexImpl(JsonIndexConfig jsonIndexConfig) {
        this._jsonIndexConfig = jsonIndexConfig;
        this._postingListMap = new TreeMap();
        this._docIdMapping = new IntArrayList();
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this._readLock = readWriteLock.readLock();
        this._writeLock = readWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String jsonString) throws IOException {
        try {
            List flattenedRecords = JsonUtils.flatten((String)jsonString, (JsonIndexConfig)this._jsonIndexConfig);
            this._writeLock.lock();
            try {
                this.addFlattenedRecords(flattenedRecords);
            }
            finally {
                this._writeLock.unlock();
            }
        }
        finally {
            ++this._nextDocId;
        }
    }

    private void addFlattenedRecords(List<Map<String, String>> records) {
        int numRecords = records.size();
        Preconditions.checkState((this._nextFlattenedDocId + numRecords >= 0 ? 1 : 0) != 0, (String)"Got more than %s flattened records", (int)Integer.MAX_VALUE);
        for (int i = 0; i < numRecords; ++i) {
            this._docIdMapping.add(this._nextDocId);
        }
        for (Map<String, String> record : records) {
            for (Map.Entry<String, String> entry : record.entrySet()) {
                String key = entry.getKey();
                this._postingListMap.computeIfAbsent(key, k -> new RoaringBitmap()).add(this._nextFlattenedDocId);
                String keyValue = key + "\u0000" + entry.getValue();
                this._postingListMap.computeIfAbsent(keyValue, k -> new RoaringBitmap()).add(this._nextFlattenedDocId);
            }
            ++this._nextFlattenedDocId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableRoaringBitmap getMatchingDocIds(String filterString) {
        FilterContext filter;
        try {
            filter = RequestContextUtils.getFilter((Expression)CalciteSqlParser.compileToExpression((String)filterString));
            Preconditions.checkArgument((!filter.isConstant() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new BadQueryRequestException("Invalid json match filter: " + filterString);
        }
        this._readLock.lock();
        try {
            if (filter.getType() == FilterContext.Type.PREDICATE && this.isExclusive(filter.getPredicate().getType())) {
                RoaringBitmap matchingFlattenedDocIds = this.getMatchingFlattenedDocIds(filter.getPredicate());
                MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
                matchingFlattenedDocIds.forEach(flattenedDocId -> matchingDocIds.add(this._docIdMapping.getInt(flattenedDocId)));
                matchingDocIds.flip(0L, (long)this._nextDocId);
                MutableRoaringBitmap mutableRoaringBitmap = matchingDocIds;
                return mutableRoaringBitmap;
            }
            RoaringBitmap matchingFlattenedDocIds = this.getMatchingFlattenedDocIds(filter);
            MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
            matchingFlattenedDocIds.forEach(flattenedDocId -> matchingDocIds.add(this._docIdMapping.getInt(flattenedDocId)));
            MutableRoaringBitmap mutableRoaringBitmap = matchingDocIds;
            return mutableRoaringBitmap;
        }
        finally {
            this._readLock.unlock();
        }
    }

    private boolean isExclusive(Predicate.Type predicateType) {
        return predicateType == Predicate.Type.IS_NULL;
    }

    private RoaringBitmap getMatchingFlattenedDocIds(FilterContext filter) {
        switch (filter.getType()) {
            case AND: {
                List children = filter.getChildren();
                int numChildren = children.size();
                RoaringBitmap matchingDocIds = this.getMatchingFlattenedDocIds((FilterContext)children.get(0));
                for (int i = 1; i < numChildren; ++i) {
                    matchingDocIds.and(this.getMatchingFlattenedDocIds((FilterContext)children.get(i)));
                }
                return matchingDocIds;
            }
            case OR: {
                List children = filter.getChildren();
                int numChildren = children.size();
                RoaringBitmap matchingDocIds = this.getMatchingFlattenedDocIds((FilterContext)children.get(0));
                for (int i = 1; i < numChildren; ++i) {
                    matchingDocIds.or(this.getMatchingFlattenedDocIds((FilterContext)children.get(i)));
                }
                return matchingDocIds;
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                Preconditions.checkArgument((!this.isExclusive(predicate.getType()) ? 1 : 0) != 0, (String)"Exclusive predicate: %s cannot be nested", (Object)predicate);
                return this.getMatchingFlattenedDocIds(predicate);
            }
        }
        throw new IllegalStateException();
    }

    private RoaringBitmap getMatchingFlattenedDocIds(Predicate predicate) {
        ExpressionContext lhs = predicate.getLhs();
        Preconditions.checkArgument((lhs.getType() == ExpressionContext.Type.IDENTIFIER ? 1 : 0) != 0, (String)"Left-hand side of the predicate must be an identifier, got: %s (%s). Put double quotes around the identifier if needed.", (Object)lhs, (Object)lhs.getType());
        Object key = lhs.getIdentifier();
        key = ((String)key).charAt(0) == '$' ? ((String)key).substring(1) : "." + (String)key;
        Pair<String, RoaringBitmap> pair = this.getKeyAndFlattenedDocIds((String)key);
        key = (String)pair.getLeft();
        RoaringBitmap matchingDocIds = (RoaringBitmap)pair.getRight();
        if (matchingDocIds != null && matchingDocIds.isEmpty()) {
            return new RoaringBitmap();
        }
        Predicate.Type predicateType = predicate.getType();
        switch (predicateType) {
            case EQ: {
                String value = ((EqPredicate)predicate).getValue();
                String keyValuePair = (String)key + "\u0000" + value;
                RoaringBitmap matchingDocIdsForKeyValuePair = this._postingListMap.get(keyValuePair);
                if (matchingDocIdsForKeyValuePair != null) {
                    if (matchingDocIds == null) {
                        return matchingDocIdsForKeyValuePair.clone();
                    }
                    matchingDocIds.and(matchingDocIdsForKeyValuePair);
                    return matchingDocIds;
                }
                return new RoaringBitmap();
            }
            case NOT_EQ: {
                Map<String, RoaringBitmap> subMap = this.getMatchingKeysMap((String)key);
                if (subMap.isEmpty()) {
                    return new RoaringBitmap();
                }
                String notEqualValue = ((NotEqPredicate)predicate).getValue();
                RoaringBitmap result = null;
                for (Map.Entry<String, RoaringBitmap> entry : subMap.entrySet()) {
                    if (notEqualValue.equals(entry.getKey().substring(((String)key).length() + 1))) continue;
                    if (result == null) {
                        result = entry.getValue().clone();
                        continue;
                    }
                    result.or(entry.getValue());
                }
                if (result == null) {
                    return new RoaringBitmap();
                }
                if (matchingDocIds == null) {
                    return result;
                }
                matchingDocIds.and(result);
                return matchingDocIds;
            }
            case IN: {
                List values = ((InPredicate)predicate).getValues();
                RoaringBitmap matchingDocIdsForKeyValuePairs = new RoaringBitmap();
                for (String value : values) {
                    String keyValuePair = (String)key + "\u0000" + value;
                    RoaringBitmap matchingDocIdsForKeyValuePair = this._postingListMap.get(keyValuePair);
                    if (matchingDocIdsForKeyValuePair == null) continue;
                    matchingDocIdsForKeyValuePairs.or(matchingDocIdsForKeyValuePair);
                }
                if (matchingDocIds == null) {
                    return matchingDocIdsForKeyValuePairs;
                }
                matchingDocIds.and(matchingDocIdsForKeyValuePairs);
                return matchingDocIds;
            }
            case NOT_IN: {
                Map<String, RoaringBitmap> subMap = this.getMatchingKeysMap((String)key);
                if (subMap.isEmpty()) {
                    return new RoaringBitmap();
                }
                List notInValues = ((NotInPredicate)predicate).getValues();
                RoaringBitmap result = null;
                for (Map.Entry<String, RoaringBitmap> entry : subMap.entrySet()) {
                    if (notInValues.contains(entry.getKey().substring(((String)key).length() + 1))) continue;
                    if (result == null) {
                        result = entry.getValue().clone();
                        continue;
                    }
                    result.or(entry.getValue());
                }
                if (result == null) {
                    return new RoaringBitmap();
                }
                if (matchingDocIds == null) {
                    return result;
                }
                matchingDocIds.and(result);
                return matchingDocIds;
            }
            case IS_NOT_NULL: 
            case IS_NULL: {
                RoaringBitmap matchingDocIdsForKey = this._postingListMap.get(key);
                if (matchingDocIdsForKey != null) {
                    if (matchingDocIds == null) {
                        return matchingDocIdsForKey.clone();
                    }
                    matchingDocIds.and(matchingDocIdsForKey);
                    return matchingDocIds;
                }
                return new RoaringBitmap();
            }
            case REGEXP_LIKE: {
                Map<String, RoaringBitmap> subMap = this.getMatchingKeysMap((String)key);
                if (subMap.isEmpty()) {
                    return new RoaringBitmap();
                }
                Pattern pattern = ((RegexpLikePredicate)predicate).getPattern();
                RoaringBitmap result = null;
                for (Map.Entry<String, RoaringBitmap> entry : subMap.entrySet()) {
                    if (!pattern.matcher((CharSequence)entry.getKey().substring(((String)key).length() + 1)).matches()) continue;
                    if (result == null) {
                        result = entry.getValue().clone();
                        continue;
                    }
                    result.or(entry.getValue());
                }
                if (result == null) {
                    return new RoaringBitmap();
                }
                if (matchingDocIds == null) {
                    return result;
                }
                matchingDocIds.and(result);
                return matchingDocIds;
            }
            case RANGE: {
                Map<String, RoaringBitmap> subMap = this.getMatchingKeysMap((String)key);
                if (subMap.isEmpty()) {
                    return new RoaringBitmap();
                }
                RoaringBitmap result = null;
                RangePredicate rangePredicate = (RangePredicate)predicate;
                FieldSpec.DataType rangeDataType = rangePredicate.getRangeDataType();
                rangeDataType = rangeDataType.isNumeric() ? FieldSpec.DataType.DOUBLE : FieldSpec.DataType.STRING;
                boolean lowerUnbounded = rangePredicate.getLowerBound().equals("*");
                boolean upperUnbounded = rangePredicate.getUpperBound().equals("*");
                boolean lowerInclusive = lowerUnbounded || rangePredicate.isLowerInclusive();
                boolean upperInclusive = upperUnbounded || rangePredicate.isUpperInclusive();
                Object lowerBound = lowerUnbounded ? null : rangeDataType.convert(rangePredicate.getLowerBound());
                Object upperBound = upperUnbounded ? null : rangeDataType.convert(rangePredicate.getUpperBound());
                for (Map.Entry<String, RoaringBitmap> entry : subMap.entrySet()) {
                    boolean upperCompareResult;
                    boolean lowerCompareResult;
                    Object valueObj = rangeDataType.convert(entry.getKey().substring(((String)key).length() + 1));
                    boolean bl = lowerUnbounded || (lowerInclusive ? rangeDataType.compare(valueObj, lowerBound) >= 0 : rangeDataType.compare(valueObj, lowerBound) > 0) ? true : (lowerCompareResult = false);
                    boolean bl2 = upperUnbounded || (upperInclusive ? rangeDataType.compare(valueObj, upperBound) <= 0 : rangeDataType.compare(valueObj, upperBound) < 0) ? true : (upperCompareResult = false);
                    if (!lowerCompareResult || !upperCompareResult) continue;
                    if (result == null) {
                        result = entry.getValue().clone();
                        continue;
                    }
                    result.or(entry.getValue());
                }
                if (result == null) {
                    return new RoaringBitmap();
                }
                if (matchingDocIds == null) {
                    return result;
                }
                matchingDocIds.and(result);
                return matchingDocIds;
            }
        }
        throw new IllegalStateException("Unsupported json_match predicate type: " + predicate);
    }

    public void convertFlattenedDocIdsToDocIds(Map<String, RoaringBitmap> valueToFlattenedDocIds) {
        this._readLock.lock();
        try {
            valueToFlattenedDocIds.replaceAll((key, value) -> {
                RoaringBitmap docIds = new RoaringBitmap();
                value.forEach(flattenedDocId -> docIds.add(this._docIdMapping.getInt(flattenedDocId)));
                return docIds;
            });
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, RoaringBitmap> getMatchingFlattenedDocsMap(String jsonPathKey, @Nullable String filterString) {
        HashMap<String, RoaringBitmap> valueToMatchingFlattenedDocIdsMap = new HashMap<String, RoaringBitmap>();
        this._readLock.lock();
        try {
            RoaringBitmap filteredFlattenedDocIds = null;
            if (filterString != null) {
                FilterContext filter = RequestContextUtils.getFilter((Expression)CalciteSqlParser.compileToExpression((String)filterString));
                Preconditions.checkArgument((!filter.isConstant() ? 1 : 0) != 0, (Object)("Invalid json match filter: " + filterString));
                if (filter.getType() == FilterContext.Type.PREDICATE && this.isExclusive(filter.getPredicate().getType())) {
                    filteredFlattenedDocIds = this.getMatchingFlattenedDocIds(filter.getPredicate());
                    filteredFlattenedDocIds.flip(0L, (long)this._nextFlattenedDocId);
                } else {
                    filteredFlattenedDocIds = this.getMatchingFlattenedDocIds(filter);
                }
            }
            jsonPathKey = ((String)jsonPathKey).startsWith("$") ? ((String)jsonPathKey).substring(1) : "." + (String)jsonPathKey;
            Pair<String, RoaringBitmap> result = this.getKeyAndFlattenedDocIds((String)jsonPathKey);
            jsonPathKey = (String)result.getLeft();
            RoaringBitmap arrayIndexFlattenDocIds = (RoaringBitmap)result.getRight();
            if (arrayIndexFlattenDocIds != null && arrayIndexFlattenDocIds.isEmpty()) {
                HashMap<String, RoaringBitmap> hashMap = valueToMatchingFlattenedDocIdsMap;
                return hashMap;
            }
            Map<String, RoaringBitmap> subMap = this.getMatchingKeysMap((String)jsonPathKey);
            for (Map.Entry<String, RoaringBitmap> entry : subMap.entrySet()) {
                RoaringBitmap flattenedDocIds = entry.getValue().clone();
                if (filteredFlattenedDocIds != null) {
                    flattenedDocIds.and(filteredFlattenedDocIds);
                }
                if (arrayIndexFlattenDocIds != null) {
                    flattenedDocIds.and(arrayIndexFlattenDocIds);
                }
                if (flattenedDocIds.isEmpty()) continue;
                valueToMatchingFlattenedDocIdsMap.put(entry.getKey().substring(((String)jsonPathKey).length() + 1), flattenedDocIds);
                Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)valueToMatchingFlattenedDocIdsMap.size());
            }
            HashMap<String, RoaringBitmap> hashMap = valueToMatchingFlattenedDocIdsMap;
            return hashMap;
        }
        finally {
            this._readLock.unlock();
        }
    }

    private Pair<String, RoaringBitmap> getKeyAndFlattenedDocIds(String key) {
        int leftBracketIndex;
        RoaringBitmap matchingDocIds = null;
        while ((leftBracketIndex = ((String)key).indexOf(91)) >= 0) {
            int rightBracketIndex = ((String)key).indexOf(93, leftBracketIndex + 2);
            Preconditions.checkArgument((rightBracketIndex > 0 ? 1 : 0) != 0, (String)"Missing right bracket in key: %s", (Object)key);
            String leftPart = ((String)key).substring(0, leftBracketIndex);
            String arrayIndex = ((String)key).substring(leftBracketIndex + 1, rightBracketIndex);
            String rightPart = ((String)key).substring(rightBracketIndex + 1);
            if (!arrayIndex.equals("*")) {
                String searchKey = leftPart + ".$index\u0000" + arrayIndex;
                RoaringBitmap docIds = this._postingListMap.get(searchKey);
                if (docIds != null) {
                    if (matchingDocIds == null) {
                        matchingDocIds = docIds.clone();
                    } else {
                        matchingDocIds.and(docIds);
                    }
                } else {
                    return Pair.of(null, (Object)new RoaringBitmap());
                }
            }
            key = leftPart + "." + rightPart;
        }
        return Pair.of((Object)key, matchingDocIds);
    }

    private Map<String, RoaringBitmap> getMatchingKeysMap(String key) {
        return this._postingListMap.subMap(key + "\u0000", false, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001"}, (String)key)), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getValuesMV(int[] docIds, int length, Map<String, RoaringBitmap> valueToMatchingFlattenedDocs) {
        String[][] result = new String[length][];
        ArrayList<PriorityQueue<Pair>> docIdToFlattenedDocIdsAndValues = new ArrayList<PriorityQueue<Pair>>();
        for (int i = 0; i < length; ++i) {
            docIdToFlattenedDocIdsAndValues.add(new PriorityQueue<Pair>(Comparator.comparingInt(Pair::getRight)));
        }
        HashMap<Integer, Integer> docIdToPos = new HashMap<Integer, Integer>();
        for (int i = 0; i < length; ++i) {
            docIdToPos.put(docIds[i], i);
        }
        this._readLock.lock();
        try {
            for (Map.Entry<String, RoaringBitmap> entry : valueToMatchingFlattenedDocs.entrySet()) {
                String value = entry.getKey();
                RoaringBitmap matchingFlattenedDocIds = entry.getValue();
                matchingFlattenedDocIds.forEach(flattenedDocId -> {
                    int docId = this._docIdMapping.getInt(flattenedDocId);
                    if (docIdToPos.containsKey(docId)) {
                        ((PriorityQueue)docIdToFlattenedDocIdsAndValues.get((Integer)docIdToPos.get(docId))).add(Pair.of((Object)value, (Object)flattenedDocId));
                    }
                });
            }
        }
        finally {
            this._readLock.unlock();
        }
        for (int i = 0; i < length; ++i) {
            PriorityQueue pq = (PriorityQueue)docIdToFlattenedDocIdsAndValues.get(i);
            result[i] = new String[pq.size()];
            int j = 0;
            while (!pq.isEmpty()) {
                result[i][j++] = (String)((Pair)pq.poll()).getLeft();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValuesSV(int[] docIds, int length, Map<String, RoaringBitmap> valueToMatchingFlattenedDocs, boolean isFlattenedDocIds) {
        Int2ObjectOpenHashMap docIdToValues = new Int2ObjectOpenHashMap(length);
        RoaringBitmap docIdMask = RoaringBitmap.bitmapOf((int[])Arrays.copyOfRange(docIds, 0, length));
        this._readLock.lock();
        try {
            for (Map.Entry<String, RoaringBitmap> entry : valueToMatchingFlattenedDocs.entrySet()) {
                String value = entry.getKey();
                RoaringBitmap matchingDocIds = entry.getValue();
                if (isFlattenedDocIds) {
                    matchingDocIds.forEach(flattenedDocId -> {
                        int docId = this._docIdMapping.getInt(flattenedDocId);
                        if (docIdMask.contains(docId)) {
                            docIdToValues.put(docId, (Object)value);
                        }
                    });
                    continue;
                }
                RoaringBitmap intersection = RoaringBitmap.and((RoaringBitmap)entry.getValue(), (RoaringBitmap)docIdMask);
                if (intersection.isEmpty()) continue;
                Iterator iterator = intersection.iterator();
                while (iterator.hasNext()) {
                    int docId = (Integer)iterator.next();
                    docIdToValues.put(docId, (Object)entry.getKey());
                }
            }
        }
        finally {
            this._readLock.unlock();
        }
        String[] values = new String[length];
        for (int i = 0; i < length; ++i) {
            values[i] = (String)docIdToValues.get(docIds[i]);
        }
        return values;
    }

    public void close() {
    }
}

