/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.invertedindex;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;

public class RealtimeLuceneIndexingDelayTracker {
    private final Map<String, TableDelay> _tableToPartitionToDelayMs;
    private final ReentrantLock _lock = new ReentrantLock();

    private RealtimeLuceneIndexingDelayTracker() {
        this._tableToPartitionToDelayMs = new HashMap<String, TableDelay>();
    }

    public static RealtimeLuceneIndexingDelayTracker getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDelaySuppliers(String tableName, String segmentName, String columnName, int partition, Supplier<Integer> numDocsDelaySupplier, Supplier<Long> timeMsDelaySupplier) {
        this._lock.lock();
        try {
            TableDelay tableDelay = this._tableToPartitionToDelayMs.getOrDefault(tableName, new TableDelay(tableName));
            tableDelay.registerDelaySuppliers(segmentName, columnName, partition, numDocsDelaySupplier, timeMsDelaySupplier);
            this._tableToPartitionToDelayMs.put(tableName, tableDelay);
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String tableName, String segmentName, String columnName, int partition) {
        this._lock.lock();
        try {
            TableDelay tableDelay = this._tableToPartitionToDelayMs.get(tableName);
            if (tableDelay != null) {
                tableDelay.clearPartitionDelay(segmentName, columnName, partition);
                if (tableDelay.isEmpty()) {
                    this._tableToPartitionToDelayMs.remove(tableName);
                }
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    @VisibleForTesting
    public void reset() {
        this._tableToPartitionToDelayMs.clear();
    }

    private static class PartitionDelay {
        final int _partition;
        final Map<String, Supplier<Integer>> _columnNumDocsDelaySuppliers;
        final Map<String, Supplier<Long>> _columnTimeMsDelaySuppliers;

        PartitionDelay(int partition) {
            this._partition = partition;
            this._columnNumDocsDelaySuppliers = new HashMap<String, Supplier<Integer>>();
            this._columnTimeMsDelaySuppliers = new HashMap<String, Supplier<Long>>();
        }

        void registerDelaySuppliers(String segmentName, String columnName, Supplier<Integer> numDocsDelaySupplier, Supplier<Long> timeMsDelaySupplier) {
            this._columnNumDocsDelaySuppliers.put(this.getKey(segmentName, columnName), numDocsDelaySupplier);
            this._columnTimeMsDelaySuppliers.put(this.getKey(segmentName, columnName), timeMsDelaySupplier);
        }

        void clearSegmentDelay(String segmentName, String columnName) {
            this._columnNumDocsDelaySuppliers.remove(this.getKey(segmentName, columnName));
            this._columnTimeMsDelaySuppliers.remove(this.getKey(segmentName, columnName));
        }

        long getMaxTimeMsDelay() {
            return this._columnTimeMsDelaySuppliers.values().stream().map(Supplier::get).max(Long::compareTo).orElse(-1L);
        }

        long getMaxNumDocsDelay() {
            return this._columnNumDocsDelaySuppliers.values().stream().map(Supplier::get).max(Integer::compareTo).orElse(-1).intValue();
        }

        int numEntries() {
            return this._columnNumDocsDelaySuppliers.size();
        }

        String getKey(String segmentName, String columnName) {
            return segmentName + "." + columnName;
        }

        public String toString() {
            return "PartitionDelay{_partition=" + this._partition + "}";
        }
    }

    private static class TableDelay {
        final String _tableName;
        final Map<Integer, PartitionDelay> _partitionDelayMap;
        final ServerMetrics _serverMetrics;

        TableDelay(String tableName) {
            this._tableName = tableName;
            this._partitionDelayMap = new HashMap<Integer, PartitionDelay>();
            this._serverMetrics = ServerMetrics.get();
        }

        void registerDelaySuppliers(String segmentName, String columnName, int partition, Supplier<Integer> numDocsDelaySupplier, Supplier<Long> timeMsDelaySupplier) {
            PartitionDelay partitionDelay = this._partitionDelayMap.getOrDefault(partition, new PartitionDelay(partition));
            partitionDelay.registerDelaySuppliers(segmentName, columnName, numDocsDelaySupplier, timeMsDelaySupplier);
            this._partitionDelayMap.put(partition, partitionDelay);
            this.updateMetrics(partitionDelay);
        }

        void clearPartitionDelay(String segmentName, String columnName, int partition) {
            PartitionDelay partitionDelay = this._partitionDelayMap.get(partition);
            if (partitionDelay != null) {
                if (partitionDelay.numEntries() == 1) {
                    this.clearMetrics(partitionDelay);
                    this._partitionDelayMap.remove(partition);
                }
                partitionDelay.clearSegmentDelay(segmentName, columnName);
            }
        }

        void updateMetrics(PartitionDelay partitionDelay) {
            this._serverMetrics.setOrUpdatePartitionGauge(this._tableName, partitionDelay._partition, (AbstractMetrics.Gauge)ServerGauge.LUCENE_INDEXING_DELAY_MS, partitionDelay::getMaxTimeMsDelay);
            this._serverMetrics.setOrUpdatePartitionGauge(this._tableName, partitionDelay._partition, (AbstractMetrics.Gauge)ServerGauge.LUCENE_INDEXING_DELAY_DOCS, partitionDelay::getMaxNumDocsDelay);
        }

        void clearMetrics(PartitionDelay partitionDelay) {
            this._serverMetrics.removePartitionGauge(this._tableName, partitionDelay._partition, (AbstractMetrics.Gauge)ServerGauge.LUCENE_INDEXING_DELAY_MS);
            this._serverMetrics.removePartitionGauge(this._tableName, partitionDelay._partition, (AbstractMetrics.Gauge)ServerGauge.LUCENE_INDEXING_DELAY_DOCS);
        }

        boolean isEmpty() {
            return this._partitionDelayMap.isEmpty();
        }

        public String toString() {
            return "TableDelay{_tableName=" + this._tableName + "}";
        }
    }

    private static class SingletonHolder {
        private static final RealtimeLuceneIndexingDelayTracker INSTANCE = new RealtimeLuceneIndexingDelayTracker();

        private SingletonHolder() {
        }
    }
}

