/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.invertedindex;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.search.SearcherManager;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneIndexRefreshState;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneTextIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeLuceneIndexReaderRefreshThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeLuceneIndexReaderRefreshThread.class);
    private static final int DELAY_BETWEEN_SUCCESSIVE_EXECUTION_MS_DEFAULT = 10;
    private final ConcurrentLinkedQueue<RealtimeLuceneIndexRefreshState.RealtimeLuceneReaders> _luceneRealtimeReaders;
    private final Lock _mutex;
    private final Condition _conditionVariable;
    private volatile boolean _stopped = false;

    RealtimeLuceneIndexReaderRefreshThread(ConcurrentLinkedQueue<RealtimeLuceneIndexRefreshState.RealtimeLuceneReaders> luceneRealtimeReaders, Lock mutex, Condition conditionVariable) {
        this._luceneRealtimeReaders = luceneRealtimeReaders;
        this._mutex = mutex;
        this._conditionVariable = conditionVariable;
    }

    void setStopped() {
        this._stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this._stopped) {
            block19: {
                this._mutex.lock();
                try {
                    while (this._luceneRealtimeReaders.isEmpty()) {
                        this._conditionVariable.await();
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Realtime lucene reader refresh thread got interrupted while waiting on condition variable: ", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                finally {
                    this._mutex.unlock();
                }
                if (this._stopped) break;
                RealtimeLuceneIndexRefreshState.RealtimeLuceneReaders realtimeReadersForSegment = this._luceneRealtimeReaders.poll();
                if (realtimeReadersForSegment != null) {
                    String segmentName = realtimeReadersForSegment.getSegmentName();
                    realtimeReadersForSegment.getLock().lock();
                    try {
                        if (realtimeReadersForSegment.isSegmentDestroyed()) break block19;
                        List<RealtimeLuceneTextIndex> realtimeLuceneReaders = realtimeReadersForSegment.getRealtimeLuceneReaders();
                        for (RealtimeLuceneTextIndex realtimeReader : realtimeLuceneReaders) {
                            if (this._stopped) {
                                break;
                            }
                            SearcherManager searcherManager = realtimeReader.getSearcherManager();
                            try {
                                searcherManager.maybeRefresh();
                            }
                            catch (Exception e) {
                                LOGGER.warn("Caught exception {} while refreshing realtime lucene reader for segment: {}", (Object)e, (Object)segmentName);
                            }
                        }
                    }
                    finally {
                        if (!realtimeReadersForSegment.isSegmentDestroyed()) {
                            this._luceneRealtimeReaders.offer(realtimeReadersForSegment);
                        }
                        realtimeReadersForSegment.getLock().unlock();
                    }
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                LOGGER.warn("Realtime lucene reader refresh thread got interrupted while sleeping: ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

