/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.loader;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.config.TierConfigUtils;
import org.apache.pinot.segment.local.segment.store.SegmentLocalFSDirectory;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoader;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoaderContext;
import org.apache.pinot.segment.spi.loader.SegmentLoader;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.utils.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SegmentLoader(name="tierBased")
public class TierBasedSegmentDirectoryLoader
implements SegmentDirectoryLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TierBasedSegmentDirectoryLoader.class);
    private static final String SEGMENT_TIER_TRACK_FILE_SUFFIX = ".tier";
    private static final int TRACK_FILE_VERSION = 1;

    public SegmentDirectory load(URI indexDir, SegmentDirectoryLoaderContext segmentLoaderContext) throws Exception {
        String targetTier;
        File destDir;
        String segmentName = segmentLoaderContext.getSegmentName();
        File srcDir = new File(indexDir);
        if (!srcDir.exists()) {
            File lastDataDir;
            String[] lastTierPath = this.getSegmentTierPersistedLocally(segmentName, segmentLoaderContext);
            String lastTierName = TierConfigUtils.normalizeTierName((String)lastTierPath[0]);
            LOGGER.info("The srcDir: {} does not exist for segment: {}. Try data dir on last known tier: {}", new Object[]{srcDir, segmentName, lastTierName});
            File file = lastDataDir = lastTierPath[1] != null ? new File(lastTierPath[1]) : this.getDefaultDataDir(segmentLoaderContext);
            if (lastDataDir.equals(srcDir)) {
                LOGGER.info("The dataDir: {} on last known tier: {} is same as srcDir", (Object)lastDataDir, (Object)lastTierName);
            } else {
                LOGGER.warn("Use dataDir: {} on last known tier: {} as the srcDir", (Object)lastDataDir, (Object)lastTierName);
                srcDir = lastDataDir;
            }
        }
        if ((destDir = this.getSegmentDataDir(targetTier = segmentLoaderContext.getSegmentTier(), segmentLoaderContext)) == null) {
            if (targetTier != null) {
                LOGGER.info("No dataDir defined for targetTier: {}", (Object)TierConfigUtils.normalizeTierName((String)targetTier));
            }
            destDir = this.getDefaultDataDir(segmentLoaderContext);
            LOGGER.info("Use destDir: {} on default tier for segment: {}", (Object)destDir, (Object)segmentName);
            targetTier = null;
        }
        String targetTierName = TierConfigUtils.normalizeTierName((String)targetTier);
        if (srcDir.equals(destDir)) {
            LOGGER.info("Keep segment: {} in current dataDir: {} on currentTier: {}", new Object[]{segmentName, destDir, targetTierName});
        } else {
            LOGGER.info("Move segment: {} from srcDir: {} to destDir: {} on targetTier: {}", new Object[]{segmentName, srcDir, destDir, targetTierName});
            if (destDir.exists()) {
                LOGGER.warn("The destDir: {} exists on targetTier: {} and cleans it firstly", (Object)destDir, (Object)targetTierName);
                FileUtils.deleteQuietly((File)destDir);
            }
            FileUtils.moveDirectory((File)srcDir, (File)destDir);
        }
        SegmentLocalFSDirectory segmentDirectory = !destDir.exists() ? new SegmentLocalFSDirectory(destDir) : new SegmentLocalFSDirectory(destDir, ReadMode.valueOf((String)segmentLoaderContext.getSegmentDirectoryConfigs().getProperty("readMode")));
        LOGGER.info("Created segmentDirectory object for segment: {} with dataDir: {} on targetTier: {}", new Object[]{segmentName, destDir, targetTierName});
        segmentDirectory.setTier(targetTier);
        this.persistSegmentTierLocally(segmentName, targetTier, destDir.getAbsolutePath(), segmentLoaderContext);
        return segmentDirectory;
    }

    public void delete(SegmentDirectoryLoaderContext segmentLoaderContext) throws Exception {
        File lastDataDir;
        String segmentName = segmentLoaderContext.getSegmentName();
        String[] lastTierPath = this.getSegmentTierPersistedLocally(segmentName, segmentLoaderContext);
        File file = lastDataDir = lastTierPath[1] != null ? new File(lastTierPath[1]) : this.getDefaultDataDir(segmentLoaderContext);
        if (lastDataDir.exists()) {
            FileUtils.deleteQuietly((File)lastDataDir);
            LOGGER.info("Deleted segment directory {} on last known tier: {}", (Object)lastDataDir, (Object)TierConfigUtils.normalizeTierName((String)lastTierPath[0]));
        }
        this.deleteSegmentTierPersistedLocally(segmentName, segmentLoaderContext);
    }

    private void persistSegmentTierLocally(String segmentName, String segmentTier, String segmentPath, SegmentDirectoryLoaderContext loaderContext) throws IOException {
        File trackFile = new File(loaderContext.getTableDataDir(), segmentName + SEGMENT_TIER_TRACK_FILE_SUFFIX);
        if (segmentTier != null) {
            LOGGER.info("Persist segment tier: {} and path: {} in tier track file: {}", new Object[]{segmentTier, segmentPath, trackFile});
            TierBasedSegmentDirectoryLoader.writeTo(trackFile, segmentTier, segmentPath);
        } else {
            LOGGER.info("Delete tier track file: {} for using default segment tier", (Object)trackFile);
            FileUtils.deleteQuietly((File)trackFile);
        }
    }

    @VisibleForTesting
    static void writeTo(File trackFile, String segmentTier, String segmentPath) throws IOException {
        byte[] tierBytes = segmentTier.getBytes(StandardCharsets.UTF_8);
        byte[] pathBytes = segmentPath.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buf = ByteBuffer.allocate(8 + tierBytes.length + 4 + pathBytes.length);
        buf.putInt(1);
        buf.putInt(tierBytes.length);
        buf.put(tierBytes);
        buf.putInt(pathBytes.length);
        buf.put(pathBytes);
        FileUtils.writeByteArrayToFile((File)trackFile, (byte[])buf.array());
    }

    private String[] getSegmentTierPersistedLocally(String segmentName, SegmentDirectoryLoaderContext loaderContext) throws IOException {
        File trackFile = new File(loaderContext.getTableDataDir(), segmentName + SEGMENT_TIER_TRACK_FILE_SUFFIX);
        if (!trackFile.exists()) {
            LOGGER.info("No tier track file: {} so using default segment tier", (Object)trackFile);
            return new String[2];
        }
        Preconditions.checkState((trackFile.length() > 12L ? 1 : 0) != 0, (String)"Track file is too short: %s", (long)trackFile.length());
        byte[] bytes = FileUtils.readFileToByteArray((File)trackFile);
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int version = buf.getInt();
        Preconditions.checkState((version == 1 ? 1 : 0) != 0, (String)"Track file has unexpected version: %s", (int)version);
        int offset = 4;
        int size = buf.getInt();
        String segmentTier = new String(bytes, offset + 4, size, StandardCharsets.UTF_8);
        buf.position(offset += 4 + size);
        size = buf.getInt();
        String segmentPath = new String(bytes, offset + 4, size, StandardCharsets.UTF_8);
        return new String[]{segmentTier, segmentPath};
    }

    private void deleteSegmentTierPersistedLocally(String segmentName, SegmentDirectoryLoaderContext loaderContext) {
        File trackFile = new File(loaderContext.getTableDataDir(), segmentName + SEGMENT_TIER_TRACK_FILE_SUFFIX);
        LOGGER.info("Delete tier track file: {}", (Object)trackFile);
        FileUtils.deleteQuietly((File)trackFile);
    }

    private File getDefaultDataDir(SegmentDirectoryLoaderContext loaderContext) {
        return new File(loaderContext.getTableDataDir(), loaderContext.getSegmentName());
    }

    private File getSegmentDataDir(String segmentTier, SegmentDirectoryLoaderContext loaderContext) {
        if (segmentTier == null) {
            return null;
        }
        TableConfig tableConfig = loaderContext.getTableConfig();
        String tableNameWithType = tableConfig.getTableName();
        String segmentName = loaderContext.getSegmentName();
        String tierDataDir = TierConfigUtils.getDataDirForTier((TableConfig)tableConfig, (String)segmentTier, (Map)loaderContext.getInstanceTierConfigs());
        if (StringUtils.isEmpty((CharSequence)tierDataDir)) {
            LOGGER.warn("No dataDir for segment: {} of table: {} on tier: {}", new Object[]{segmentName, tableNameWithType, segmentTier});
            return null;
        }
        File tierTableDataDir = new File(tierDataDir, tableNameWithType);
        return new File(tierTableDataDir, segmentName);
    }

    public boolean needsTierMigration(String targetTier, String currentTier) {
        return !StringUtils.equals((CharSequence)targetTier, (CharSequence)currentTier);
    }
}

