/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.pinot.segment.local.io.util.ValueReader;
import org.apache.pinot.segment.local.io.util.ValueReaderComparisons;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public final class FixedByteValueReaderWriter
implements ValueReader {
    private final PinotDataBuffer _dataBuffer;

    public FixedByteValueReaderWriter(PinotDataBuffer dataBuffer) {
        this._dataBuffer = dataBuffer;
    }

    @Override
    public int getInt(int index) {
        return this._dataBuffer.getInt((long)index * 4L);
    }

    @Override
    public long getLong(int index) {
        return this._dataBuffer.getLong((long)index * 8L);
    }

    @Override
    public float getFloat(int index) {
        return this._dataBuffer.getFloat((long)index * 4L);
    }

    @Override
    public double getDouble(int index) {
        return this._dataBuffer.getDouble((long)index * 8L);
    }

    private int readUnpaddedBytes(int index, int numBytesPerValue, byte[] buffer) {
        byte b;
        int i;
        assert (buffer.length >= numBytesPerValue);
        long startOffset = (long)index * (long)numBytesPerValue;
        boolean littleEndian = this._dataBuffer.order() == ByteOrder.LITTLE_ENDIAN;
        ByteBuffer wrapper = ByteBuffer.wrap(buffer);
        if (littleEndian) {
            wrapper.order(ByteOrder.LITTLE_ENDIAN);
        }
        int endIndex = numBytesPerValue & 0xFFFFFFF8;
        for (i = 0; i < endIndex; i += 8) {
            long word = this._dataBuffer.getLong(startOffset + (long)i);
            wrapper.putLong(i, word);
            long tmp = ((word & 0x7F7F7F7F7F7F7F7FL) + 0x7F7F7F7F7F7F7F7FL | word | 0x7F7F7F7F7F7F7F7FL) ^ 0xFFFFFFFFFFFFFFFFL;
            if (tmp == 0L) continue;
            return i + ((littleEndian ? Long.numberOfTrailingZeros(tmp) : Long.numberOfLeadingZeros(tmp)) >>> 3);
        }
        while (i < numBytesPerValue && (b = this._dataBuffer.getByte(startOffset + (long)i)) != 0) {
            buffer[i] = b;
            ++i;
        }
        return i;
    }

    @Override
    public byte[] getUnpaddedBytes(int index, int numBytesPerValue, byte[] buffer) {
        int length = this.readUnpaddedBytes(index, numBytesPerValue, buffer);
        byte[] bytes = new byte[length];
        System.arraycopy(buffer, 0, bytes, 0, length);
        return bytes;
    }

    @Override
    public String getUnpaddedString(int index, int numBytesPerValue, byte[] buffer) {
        int length = this.readUnpaddedBytes(index, numBytesPerValue, buffer);
        return new String(buffer, 0, length, StandardCharsets.UTF_8);
    }

    @Override
    public String getPaddedString(int index, int numBytesPerValue, byte[] buffer) {
        assert (buffer.length >= numBytesPerValue);
        long startOffset = (long)index * (long)numBytesPerValue;
        this._dataBuffer.copyTo(startOffset, buffer, 0, numBytesPerValue);
        return new String(buffer, 0, numBytesPerValue, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] getBytes(int index, int numBytesPerValue) {
        long startOffset = (long)index * (long)numBytesPerValue;
        byte[] value = new byte[numBytesPerValue];
        this._dataBuffer.copyTo(startOffset, value, 0, numBytesPerValue);
        return value;
    }

    @Override
    public int compareUtf8Bytes(int index, int numBytesPerValue, byte[] bytes) {
        long startOffset = (long)index * (long)numBytesPerValue;
        return ValueReaderComparisons.compareUtf8Bytes(this._dataBuffer, startOffset, numBytesPerValue, true, bytes);
    }

    @Override
    public int compareBytes(int index, int numBytesPerValue, byte[] bytes) {
        long startOffset = (long)index * (long)numBytesPerValue;
        return ValueReaderComparisons.compareBytes(this._dataBuffer, startOffset, numBytesPerValue, bytes);
    }

    public void writeInt(int index, int value) {
        this._dataBuffer.putInt((long)index * 4L, value);
    }

    public void writeLong(int index, long value) {
        this._dataBuffer.putLong((long)index * 8L, value);
    }

    public void writeFloat(int index, float value) {
        this._dataBuffer.putFloat((long)index * 4L, value);
    }

    public void writeDouble(int index, double value) {
        this._dataBuffer.putDouble((long)index * 8L, value);
    }

    public void writeBytes(int index, int numBytesPerValue, byte[] value) {
        assert (value.length <= numBytesPerValue);
        long startIndex = (long)index * (long)numBytesPerValue;
        if (value.length < numBytesPerValue) {
            value = Arrays.copyOf(value, numBytesPerValue);
        }
        this._dataBuffer.readFrom(startIndex, value);
    }

    @Override
    public void close() {
    }
}

