/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.record.enricher.clp;

import com.fasterxml.jackson.databind.JsonNode;
import com.yscope.clp.compressorfrontend.EncodedMessage;
import com.yscope.clp.compressorfrontend.MessageEncoder;
import java.io.IOException;
import java.util.List;
import org.apache.pinot.plugin.record.enricher.clp.ClpEnricherConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.recordenricher.RecordEnricher;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLPEncodingEnricher
implements RecordEnricher {
    private static final Logger LOGGER = LoggerFactory.getLogger(CLPEncodingEnricher.class);
    private final ClpEnricherConfig _config;
    private final EncodedMessage _clpEncodedMessage;
    private final MessageEncoder _clpMessageEncoder;

    public CLPEncodingEnricher(JsonNode enricherProperties) throws IOException {
        this._config = (ClpEnricherConfig)JsonUtils.jsonNodeToObject((JsonNode)enricherProperties, ClpEnricherConfig.class);
        this._clpEncodedMessage = new EncodedMessage();
        this._clpMessageEncoder = new MessageEncoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
    }

    public List<String> getInputColumns() {
        return this._config.getFields();
    }

    public void enrich(GenericRow record) {
        try {
            for (String field : this._config.getFields()) {
                Object value = record.getValue(field);
                if (value == null) continue;
                this.enrichWithClpEncodedFields(field, value, record);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to enrich record: {}", (Object)record);
        }
    }

    private void enrichWithClpEncodedFields(String key, Object value, GenericRow to) {
        String logtype = null;
        String[] dictVars = null;
        Long[] encodedVars = null;
        if (null != value) {
            if (value instanceof String) {
                String valueAsString = (String)value;
                try {
                    this._clpMessageEncoder.encodeMessage(valueAsString, this._clpEncodedMessage);
                    logtype = this._clpEncodedMessage.getLogTypeAsString();
                    encodedVars = this._clpEncodedMessage.getEncodedVarsAsBoxedLongs();
                    dictVars = this._clpEncodedMessage.getDictionaryVarsAsStrings();
                }
                catch (IOException e) {
                    LOGGER.error("Can't encode field with CLP. name: '{}', value: '{}', error: {}", new Object[]{key, valueAsString, e.getMessage()});
                }
            } else {
                LOGGER.error("Can't encode value of type {} with CLP. name: '{}', value: '{}'", new Object[]{value.getClass().getSimpleName(), key, value});
            }
        }
        to.putValue(key + "_logtype", logtype);
        to.putValue(key + "_dictionaryVars", dictVars);
        to.putValue(key + "_encodedVars", encodedVars);
    }
}

