/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.pinot.segment.local.utils.nativefst.FST;
import org.apache.pinot.segment.local.utils.nativefst.builder.FSTBuilder;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.creator.FSTIndexCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFSTIndexCreator
implements FSTIndexCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeFSTIndexCreator.class);
    private final File _fstIndexFile;
    private final FSTBuilder _fstBuilder;
    private int _dictId;

    public NativeFSTIndexCreator(File indexDir, String columnName, String[] sortedEntries) {
        this._fstIndexFile = new File(indexDir, columnName + ".lucene.v9.fst");
        this._fstBuilder = new FSTBuilder();
        this._dictId = 0;
        if (sortedEntries != null) {
            this._dictId = 0;
            while (this._dictId < sortedEntries.length) {
                this._fstBuilder.add(sortedEntries[this._dictId].getBytes(), 0, sortedEntries[this._dictId].length(), this._dictId);
                ++this._dictId;
            }
        }
    }

    public NativeFSTIndexCreator(IndexCreationContext context) {
        this(context.getIndexDir(), context.getFieldSpec().getName(), (String[])context.getSortedUniqueElementsArray());
    }

    public void add(String document) {
        this._fstBuilder.add(document.getBytes(), 0, document.length(), this._dictId);
        ++this._dictId;
    }

    public void add(String[] document, int length) {
        throw new UnsupportedOperationException("Multiple values not supported");
    }

    public void seal() throws IOException {
        LOGGER.info("Sealing FST index: " + this._fstIndexFile.getAbsolutePath());
        try (FileOutputStream fileOutputStream = new FileOutputStream(this._fstIndexFile);){
            FST fst = this._fstBuilder.complete();
            fst.save(fileOutputStream);
        }
    }

    public void close() throws IOException {
    }
}

