/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.fst;

import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSTBuilder {
    public static final Logger LOGGER = LoggerFactory.getLogger(FSTBuilder.class);
    private final FSTCompiler<Long> _builder = new FSTCompiler(FST.INPUT_TYPE.BYTE4, (Outputs)PositiveIntOutputs.getSingleton());
    private final IntsRefBuilder _scratch = new IntsRefBuilder();

    public static FST<Long> buildFST(SortedMap<String, Integer> input) throws IOException {
        PositiveIntOutputs fstOutput = PositiveIntOutputs.getSingleton();
        FSTCompiler fstCompiler = new FSTCompiler(FST.INPUT_TYPE.BYTE4, (Outputs)fstOutput);
        IntsRefBuilder scratch = new IntsRefBuilder();
        for (Map.Entry<String, Integer> entry : input.entrySet()) {
            fstCompiler.add(Util.toUTF16((CharSequence)entry.getKey(), (IntsRefBuilder)scratch), (Object)entry.getValue().longValue());
        }
        return fstCompiler.compile();
    }

    public void addEntry(String key, Integer value) throws IOException {
        this._builder.add(Util.toUTF16((CharSequence)key, (IntsRefBuilder)this._scratch), (Object)value.longValue());
    }

    public FST<Long> done() throws IOException {
        return this._builder.compile();
    }
}

