/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.google.common.hash.Hashing;
import org.apache.pinot.spi.config.table.HashFunction;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.utils.ByteArray;

public class HashUtils {
    private HashUtils() {
    }

    public static byte[] hashMurmur3(byte[] bytes) {
        return Hashing.murmur3_128().hashBytes(bytes).asBytes();
    }

    public static byte[] hashMD5(byte[] bytes) {
        return Hashing.md5().hashBytes(bytes).asBytes();
    }

    public static Object hashPrimaryKey(PrimaryKey primaryKey, HashFunction hashFunction) {
        switch (hashFunction) {
            case NONE: {
                return primaryKey;
            }
            case MD5: {
                return new ByteArray(HashUtils.hashMD5(primaryKey.asBytes()));
            }
            case MURMUR3: {
                return new ByteArray(HashUtils.hashMurmur3(primaryKey.asBytes()));
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized hash function %s", hashFunction));
    }
}

