/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.segment.local.segment.readers.LazyRow;
import org.apache.pinot.segment.local.upsert.merger.OverwriteMerger;
import org.apache.pinot.segment.local.upsert.merger.PartialUpsertMerger;
import org.apache.pinot.segment.local.upsert.merger.PartialUpsertMergerFactory;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class PartialUpsertHandler {
    private final Map<String, PartialUpsertMerger> _column2Mergers = new HashMap<String, PartialUpsertMerger>();
    private final PartialUpsertMerger _defaultPartialUpsertMerger;
    private final List<String> _comparisonColumns;
    private final List<String> _primaryKeyColumns;

    public PartialUpsertHandler(Schema schema, Map<String, UpsertConfig.Strategy> partialUpsertStrategies, UpsertConfig.Strategy defaultPartialUpsertStrategy, List<String> comparisonColumns) {
        this._defaultPartialUpsertMerger = PartialUpsertMergerFactory.getMerger(defaultPartialUpsertStrategy);
        this._comparisonColumns = comparisonColumns;
        this._primaryKeyColumns = schema.getPrimaryKeyColumns();
        for (Map.Entry<String, UpsertConfig.Strategy> entry : partialUpsertStrategies.entrySet()) {
            this._column2Mergers.put(entry.getKey(), PartialUpsertMergerFactory.getMerger(entry.getValue()));
        }
    }

    public void merge(LazyRow prevRecord, GenericRow newRecord) {
        for (String column : prevRecord.getColumnNames()) {
            Object prevValue;
            if (this._primaryKeyColumns.contains(column)) continue;
            PartialUpsertMerger merger = this._column2Mergers.getOrDefault(column, this._defaultPartialUpsertMerger);
            if (!(merger instanceof OverwriteMerger)) {
                prevValue = prevRecord.getValue(column);
                if (prevValue == null) continue;
                if (newRecord.isNullValue(column)) {
                    newRecord.putValue(column, prevValue);
                    newRecord.removeNullValueField(column);
                    continue;
                }
                if (this._comparisonColumns.contains(column)) continue;
                newRecord.putValue(column, merger.merge(prevValue, newRecord.getValue(column)));
                continue;
            }
            if (!newRecord.isNullValue(column) || (prevValue = prevRecord.getValue(column)) == null) continue;
            newRecord.putValue(column, prevValue);
            newRecord.removeNullValueField(column);
        }
    }
}

