/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections.CollectionUtils;
import org.apache.helix.HelixManager;
import org.apache.helix.model.IdealState;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.utils.helix.HelixHelper;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.upsert.PartialUpsertHandler;
import org.apache.pinot.segment.local.upsert.TableUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.UpsertContext;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.config.table.HashFunction;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BaseTableUpsertMetadataManager
implements TableUpsertMetadataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTableUpsertMetadataManager.class);
    protected String _tableNameWithType;
    protected TableDataManager _tableDataManager;
    protected HelixManager _helixManager;
    protected ExecutorService _segmentPreloadExecutor;
    protected UpsertContext _context;
    private volatile boolean _isPreloading = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(TableConfig tableConfig, Schema schema, TableDataManager tableDataManager, HelixManager helixManager, @Nullable ExecutorService segmentPreloadExecutor) {
        this._tableNameWithType = tableConfig.getTableName();
        this._tableDataManager = tableDataManager;
        this._helixManager = helixManager;
        this._segmentPreloadExecutor = segmentPreloadExecutor;
        UpsertConfig upsertConfig = tableConfig.getUpsertConfig();
        Preconditions.checkArgument((upsertConfig != null && upsertConfig.getMode() != UpsertConfig.Mode.NONE ? 1 : 0) != 0, (String)"Upsert must be enabled for table: %s", (Object)this._tableNameWithType);
        List primaryKeyColumns = schema.getPrimaryKeyColumns();
        Preconditions.checkArgument((!CollectionUtils.isEmpty((Collection)primaryKeyColumns) ? 1 : 0) != 0, (String)"Primary key columns must be configured for upsert enabled table: %s", (Object)this._tableNameWithType);
        List<String> comparisonColumns = upsertConfig.getComparisonColumns();
        if (comparisonColumns == null) {
            comparisonColumns = Collections.singletonList(tableConfig.getValidationConfig().getTimeColumnName());
        }
        PartialUpsertHandler partialUpsertHandler = null;
        if (upsertConfig.getMode() == UpsertConfig.Mode.PARTIAL) {
            Map partialUpsertStrategies = upsertConfig.getPartialUpsertStrategies();
            Preconditions.checkArgument((partialUpsertStrategies != null ? 1 : 0) != 0, (String)"Partial-upsert strategies must be configured for partial-upsert enabled table: %s", (Object)this._tableNameWithType);
            partialUpsertHandler = new PartialUpsertHandler(schema, partialUpsertStrategies, upsertConfig.getDefaultPartialUpsertStrategy(), comparisonColumns);
        }
        String deleteRecordColumn = upsertConfig.getDeleteRecordColumn();
        HashFunction hashFunction = upsertConfig.getHashFunction();
        boolean enableSnapshot = upsertConfig.isEnableSnapshot();
        boolean enablePreload = upsertConfig.isEnablePreload();
        double metadataTTL = upsertConfig.getMetadataTTL();
        double deletedKeysTTL = upsertConfig.getDeletedKeysTTL();
        File tableIndexDir = tableDataManager.getTableDataDir();
        this._context = new UpsertContext.Builder().setTableConfig(tableConfig).setSchema(schema).setPrimaryKeyColumns(primaryKeyColumns).setComparisonColumns(comparisonColumns).setDeleteRecordColumn(deleteRecordColumn).setHashFunction(hashFunction).setPartialUpsertHandler(partialUpsertHandler).setEnableSnapshot(enableSnapshot).setEnablePreload(enablePreload).setMetadataTTL(metadataTTL).setDeletedKeysTTL(deletedKeysTTL).setTableIndexDir(tableIndexDir).build();
        LOGGER.info("Initialized {} for table: {} with primary key columns: {}, comparison columns: {}, delete record column: {}, hash function: {}, upsert mode: {}, enable snapshot: {}, enable preload: {}, metadata TTL: {}, deleted Keys TTL: {}, table index dir: {}", new Object[]{this.getClass().getSimpleName(), this._tableNameWithType, primaryKeyColumns, comparisonColumns, deleteRecordColumn, hashFunction, upsertConfig.getMode(), enableSnapshot, enablePreload, metadataTTL, deletedKeysTTL, tableIndexDir});
        this.initCustomVariables();
        if (enableSnapshot && enablePreload && segmentPreloadExecutor != null) {
            try {
                this._isPreloading = true;
                this.preloadSegments();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to preload segments from table: {}, skipping", (Object)this._tableNameWithType, (Object)e);
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                this._isPreloading = false;
            }
        }
    }

    protected void initCustomVariables() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadSegments() throws Exception {
        LOGGER.info("Preload segments from table: {} for fast upsert metadata recovery", (Object)this._tableNameWithType);
        if (!this.onPreloadStart()) {
            return;
        }
        ZkHelixPropertyStore propertyStore = this._helixManager.getHelixPropertyStore();
        String instanceId = this.getInstanceId();
        IndexLoadingConfig indexLoadingConfig = this.createIndexLoadingConfig();
        Map<String, Map<String, String>> segmentAssignment = this.getSegmentAssignment();
        ArrayList futures = new ArrayList();
        for (Map.Entry<String, Map<String, String>> entry : segmentAssignment.entrySet()) {
            String segmentName = entry.getKey();
            Map<String, String> instanceStateMap = entry.getValue();
            String state = instanceStateMap.get(instanceId);
            if (!"ONLINE".equals(state)) {
                LOGGER.info("Skip segment: {} as its ideal state: {} is not ONLINE", (Object)segmentName, (Object)state);
                continue;
            }
            futures.add(this._segmentPreloadExecutor.submit(() -> {
                try {
                    this.preloadSegment(segmentName, indexLoadingConfig, (ZkHelixPropertyStore<ZNRecord>)propertyStore);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to preload segment: {} from table: {}, skipping", new Object[]{segmentName, this._tableNameWithType, e});
                }
            }));
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
        this.onPreloadFinish();
        LOGGER.info("Preloaded segments from table: {} for fast upsert metadata recovery", (Object)this._tableNameWithType);
    }

    protected boolean onPreloadStart() {
        return true;
    }

    protected void onPreloadFinish() {
    }

    @VisibleForTesting
    String getInstanceId() {
        return this._tableDataManager.getInstanceDataManagerConfig().getInstanceId();
    }

    @VisibleForTesting
    IndexLoadingConfig createIndexLoadingConfig() {
        return new IndexLoadingConfig(this._tableDataManager.getInstanceDataManagerConfig(), this._context.getTableConfig(), this._context.getSchema());
    }

    @VisibleForTesting
    Map<String, Map<String, String>> getSegmentAssignment() {
        IdealState idealState = HelixHelper.getTableIdealState((HelixManager)this._helixManager, (String)this._tableNameWithType);
        Preconditions.checkState((idealState != null ? 1 : 0) != 0, (String)"Failed to find ideal state for table: %s", (Object)this._tableNameWithType);
        return idealState.getRecord().getMapFields();
    }

    private void preloadSegment(String segmentName, IndexLoadingConfig indexLoadingConfig, ZkHelixPropertyStore<ZNRecord> propertyStore) {
        LOGGER.info("Preload segment: {} from table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        SegmentZKMetadata zkMetadata = ZKMetadataProvider.getSegmentZKMetadata(propertyStore, (String)this._tableNameWithType, (String)segmentName);
        Preconditions.checkState((zkMetadata != null ? 1 : 0) != 0, (String)"Failed to find ZK metadata for segment: %s, table: %s", (Object)segmentName, (Object)this._tableNameWithType);
        if (!this.hasValidDocIdsSnapshot(segmentName, zkMetadata.getTier())) {
            LOGGER.info("Skip segment: {} as no validDocIds snapshot exists", (Object)segmentName);
            return;
        }
        this.preloadSegmentWithSnapshot(segmentName, indexLoadingConfig, zkMetadata);
        LOGGER.info("Preloaded segment: {} from table: {}", (Object)segmentName, (Object)this._tableNameWithType);
    }

    @VisibleForTesting
    void preloadSegmentWithSnapshot(String segmentName, IndexLoadingConfig indexLoadingConfig, SegmentZKMetadata zkMetadata) {
        this._tableDataManager.tryLoadExistingSegment(segmentName, indexLoadingConfig, zkMetadata);
    }

    private boolean hasValidDocIdsSnapshot(String segmentName, String segmentTier) {
        try {
            File indexDir = this._tableDataManager.getSegmentDataDir(segmentName, segmentTier, this._context.getTableConfig());
            File snapshotFile = new File(SegmentDirectoryPaths.findSegmentDirectory((File)indexDir), "validdocids.bitmap.snapshot");
            return snapshotFile.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isPreloading() {
        return this._isPreloading;
    }

    @Override
    public UpsertConfig.Mode getUpsertMode() {
        return this._context.getPartialUpsertHandler() == null ? UpsertConfig.Mode.FULL : UpsertConfig.Mode.PARTIAL;
    }
}

