/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree.v2.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.segment.local.aggregator.ValueAggregatorFactory;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexReaderFactory;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBitSVForwardIndexReaderV2;
import org.apache.pinot.segment.local.startree.OffHeapStarTree;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeDataSource;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.StarTree;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Metadata;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;

public class StarTreeLoaderUtils {
    private StarTreeLoaderUtils() {
    }

    public static List<StarTreeV2> loadStarTreeV2(SegmentDirectory.Reader segmentReader, SegmentMetadataImpl segmentMetadata, Map<String, ColumnIndexContainer> indexContainerMap) throws IOException {
        List starTreeMetadataList = segmentMetadata.getStarTreeV2MetadataList();
        int numStarTrees = starTreeMetadataList.size();
        ArrayList<StarTreeV2> starTrees = new ArrayList<StarTreeV2>(numStarTrees);
        for (int i = 0; i < numStarTrees; ++i) {
            SegmentDirectory.Reader indexReader = segmentReader.getStarTreeIndexReader(i);
            final OffHeapStarTree starTree = new OffHeapStarTree(indexReader.getIndexFor(String.valueOf(i), StandardIndexes.inverted()));
            final StarTreeV2Metadata starTreeMetadata = (StarTreeV2Metadata)starTreeMetadataList.get(i);
            int numDocs = starTreeMetadata.getNumDocs();
            final HashMap<String, StarTreeDataSource> dataSourceMap = new HashMap<String, StarTreeDataSource>();
            for (String dimension : starTreeMetadata.getDimensionsSplitOrder()) {
                PinotDataBuffer forwardIndexDataBuffer = indexReader.getIndexFor(dimension, StandardIndexes.forward());
                ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(dimension);
                FixedBitSVForwardIndexReaderV2 forwardIndex = new FixedBitSVForwardIndexReaderV2(forwardIndexDataBuffer, numDocs, columnMetadata.getBitsPerElement());
                dataSourceMap.put(dimension, new StarTreeDataSource(columnMetadata.getFieldSpec(), numDocs, forwardIndex, (Dictionary)indexContainerMap.get(dimension).getIndex(StandardIndexes.dictionary())));
            }
            for (AggregationFunctionColumnPair functionColumnPair : starTreeMetadata.getFunctionColumnPairs()) {
                String metric = functionColumnPair.toColumnName();
                PinotDataBuffer forwardIndexDataBuffer = indexReader.getIndexFor(metric, StandardIndexes.forward());
                FieldSpec.DataType dataType = ValueAggregatorFactory.getAggregatedValueType(functionColumnPair.getFunctionType());
                MetricFieldSpec fieldSpec = new MetricFieldSpec(metric, dataType);
                ForwardIndexReader forwardIndex = ForwardIndexReaderFactory.createRawIndexReader(forwardIndexDataBuffer, dataType.getStoredType(), true);
                dataSourceMap.put(metric, new StarTreeDataSource((FieldSpec)fieldSpec, numDocs, forwardIndex, null));
            }
            starTrees.add(new StarTreeV2(){

                public StarTree getStarTree() {
                    return starTree;
                }

                public StarTreeV2Metadata getMetadata() {
                    return starTreeMetadata;
                }

                public DataSource getDataSource(String columnName) {
                    return (DataSource)dataSourceMap.get(columnName);
                }

                public void close() throws IOException {
                    for (DataSource dataSource : dataSourceMap.values()) {
                        dataSource.getForwardIndex().close();
                    }
                }
            });
        }
        return starTrees;
    }
}

