/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree.v2.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.AggregationSpec;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Metadata;
import org.apache.pinot.spi.config.table.StarTreeAggregationConfig;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;
import org.apache.pinot.spi.data.Schema;

public class StarTreeV2BuilderConfig {
    public static final int DEFAULT_MAX_LEAF_RECORDS = 10000;
    private static final int DIMENSION_CARDINALITY_THRESHOLD_FOR_DEFAULT_CONFIG = 10000;
    private final List<String> _dimensionsSplitOrder;
    private final Set<String> _skipStarNodeCreationForDimensions;
    private final TreeMap<AggregationFunctionColumnPair, AggregationSpec> _aggregationSpecs;
    private final int _maxLeafRecords;

    public static StarTreeV2BuilderConfig fromIndexConfig(StarTreeIndexConfig indexConfig) {
        int maxLeafRecords;
        AggregationFunctionColumnPair storedType;
        AggregationFunctionColumnPair aggregationFunctionColumnPair;
        Set<String> skipStarNodeCreationForDimensions;
        List dimensionsSplitOrder = indexConfig.getDimensionsSplitOrder();
        if (indexConfig.getSkipStarNodeCreationForDimensions() != null) {
            skipStarNodeCreationForDimensions = new TreeSet(indexConfig.getSkipStarNodeCreationForDimensions());
            Preconditions.checkArgument((boolean)dimensionsSplitOrder.containsAll(skipStarNodeCreationForDimensions), (String)"Can not skip star-node creation for dimensions not in the split order, dimensionsSplitOrder: %s, skipStarNodeCreationForDimensions: %s", (Object)dimensionsSplitOrder, skipStarNodeCreationForDimensions);
        } else {
            skipStarNodeCreationForDimensions = Collections.emptySet();
        }
        TreeMap<AggregationFunctionColumnPair, AggregationSpec> aggregationSpecs = new TreeMap<AggregationFunctionColumnPair, AggregationSpec>();
        if (indexConfig.getFunctionColumnPairs() != null) {
            for (String functionColumnPair : indexConfig.getFunctionColumnPairs()) {
                aggregationFunctionColumnPair = AggregationFunctionColumnPair.fromColumnName((String)functionColumnPair);
                storedType = AggregationFunctionColumnPair.resolveToStoredType((AggregationFunctionColumnPair)aggregationFunctionColumnPair);
                aggregationSpecs.putIfAbsent(storedType, AggregationSpec.DEFAULT);
            }
        }
        if (indexConfig.getAggregationConfigs() != null) {
            for (StarTreeAggregationConfig aggregationConfig : indexConfig.getAggregationConfigs()) {
                aggregationFunctionColumnPair = AggregationFunctionColumnPair.fromAggregationConfig((StarTreeAggregationConfig)aggregationConfig);
                storedType = AggregationFunctionColumnPair.resolveToStoredType((AggregationFunctionColumnPair)aggregationFunctionColumnPair);
                ChunkCompressionType compressionType = ChunkCompressionType.valueOf((String)aggregationConfig.getCompressionCodec().name());
                aggregationSpecs.putIfAbsent(storedType, new AggregationSpec(compressionType));
            }
        }
        if ((maxLeafRecords = indexConfig.getMaxLeafRecords()) <= 0) {
            maxLeafRecords = 10000;
        }
        return new StarTreeV2BuilderConfig(dimensionsSplitOrder, skipStarNodeCreationForDimensions, aggregationSpecs, maxLeafRecords);
    }

    public static StarTreeV2BuilderConfig fromMetadata(StarTreeV2Metadata starTreeV2Metadata) {
        return new StarTreeV2BuilderConfig(starTreeV2Metadata.getDimensionsSplitOrder(), starTreeV2Metadata.getSkipStarNodeCreationForDimensions(), starTreeV2Metadata.getAggregationSpecs(), starTreeV2Metadata.getMaxLeafRecords());
    }

    public static StarTreeV2BuilderConfig generateDefaultConfig(SegmentMetadata segmentMetadata) {
        Schema schema = segmentMetadata.getSchema();
        ArrayList<ColumnMetadata> dimensionColumnMetadataList = new ArrayList<ColumnMetadata>();
        ArrayList<ColumnMetadata> timeColumnMetadataList = new ArrayList<ColumnMetadata>();
        ArrayList<String> numericMetrics = new ArrayList<String>();
        for (Object fieldSpec : schema.getAllFieldSpecs()) {
            if (!fieldSpec.isSingleValueField() || fieldSpec.isVirtualColumn()) continue;
            String column = fieldSpec.getName();
            switch (fieldSpec.getFieldType()) {
                case DIMENSION: {
                    ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
                    if (!columnMetadata.hasDictionary() || columnMetadata.getCardinality() > 10000) break;
                    dimensionColumnMetadataList.add(columnMetadata);
                    break;
                }
                case DATE_TIME: 
                case TIME: {
                    ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
                    if (!columnMetadata.hasDictionary()) break;
                    timeColumnMetadataList.add(columnMetadata);
                    break;
                }
                case METRIC: {
                    if (!fieldSpec.getDataType().isNumeric()) break;
                    numericMetrics.add(column);
                    break;
                }
            }
        }
        dimensionColumnMetadataList.sort((o1, o2) -> Integer.compare(o2.getCardinality(), o1.getCardinality()));
        timeColumnMetadataList.sort((o1, o2) -> Integer.compare(o2.getCardinality(), o1.getCardinality()));
        ArrayList<String> dimensionsSplitOrder = new ArrayList<String>();
        for (ColumnMetadata dimensionColumnMetadata : dimensionColumnMetadataList) {
            dimensionsSplitOrder.add(dimensionColumnMetadata.getColumnName());
        }
        for (ColumnMetadata timeColumnMetadata : timeColumnMetadataList) {
            dimensionsSplitOrder.add(timeColumnMetadata.getColumnName());
        }
        Preconditions.checkState((!dimensionsSplitOrder.isEmpty() ? 1 : 0) != 0, (Object)"No qualified dimension found for star-tree split order");
        TreeMap<AggregationFunctionColumnPair, AggregationSpec> aggregationSpecs = new TreeMap<AggregationFunctionColumnPair, AggregationSpec>();
        aggregationSpecs.put(AggregationFunctionColumnPair.COUNT_STAR, AggregationSpec.DEFAULT);
        for (String numericMetric : numericMetrics) {
            aggregationSpecs.put(new AggregationFunctionColumnPair(AggregationFunctionType.SUM, numericMetric), AggregationSpec.DEFAULT);
        }
        return new StarTreeV2BuilderConfig(dimensionsSplitOrder, Collections.emptySet(), aggregationSpecs, 10000);
    }

    public static StarTreeV2BuilderConfig generateDefaultConfig(Schema schema, JsonNode columnsMetadata) {
        ArrayList<JsonNode> dimensionColumnMetadataList = new ArrayList<JsonNode>();
        ArrayList<JsonNode> timeColumnMetadataList = new ArrayList<JsonNode>();
        ArrayList<String> numericMetrics = new ArrayList<String>();
        Preconditions.checkState((!columnsMetadata.isNull() ? 1 : 0) != 0, (Object)"columnsMetadata should not be null.");
        Preconditions.checkState((!columnsMetadata.isEmpty() ? 1 : 0) != 0, (Object)"columnsMetadata should not be empty.");
        Map<String, JsonNode> columnMetadataMap = StarTreeV2BuilderConfig.convertJsonNodeToMap(columnsMetadata);
        for (Object fieldSpec : schema.getAllFieldSpecs()) {
            if (!fieldSpec.isSingleValueField() || fieldSpec.isVirtualColumn()) continue;
            String column = fieldSpec.getName();
            switch (fieldSpec.getFieldType()) {
                case DIMENSION: {
                    JsonNode columnMetadata = columnMetadataMap.get(column);
                    if (!columnMetadata.get("hasDictionary").asBoolean() || columnMetadata.get("cardinality").asInt() > 10000) break;
                    dimensionColumnMetadataList.add(columnMetadata);
                    break;
                }
                case DATE_TIME: 
                case TIME: {
                    JsonNode columnMetadata = columnMetadataMap.get(column);
                    if (!columnMetadata.get("hasDictionary").asBoolean()) break;
                    timeColumnMetadataList.add(columnMetadata);
                    break;
                }
                case METRIC: {
                    if (!fieldSpec.getDataType().isNumeric()) break;
                    numericMetrics.add(column);
                    break;
                }
            }
        }
        dimensionColumnMetadataList.sort((o1, o2) -> Integer.compare(o2.get("cardinality").asInt(), o1.get("cardinality").asInt()));
        timeColumnMetadataList.sort((o1, o2) -> Integer.compare(o2.get("cardinality").asInt(), o1.get("cardinality").asInt()));
        ArrayList<String> dimensionsSplitOrder = new ArrayList<String>();
        for (JsonNode dimensionColumnMetadata : dimensionColumnMetadataList) {
            dimensionsSplitOrder.add(dimensionColumnMetadata.get("columnName").asText());
        }
        for (JsonNode timeColumnMetadata : timeColumnMetadataList) {
            dimensionsSplitOrder.add(timeColumnMetadata.get("columnName").asText());
        }
        Preconditions.checkState((!dimensionsSplitOrder.isEmpty() ? 1 : 0) != 0, (Object)"No qualified dimension found for star-tree split order");
        TreeMap<AggregationFunctionColumnPair, AggregationSpec> aggregationSpecs = new TreeMap<AggregationFunctionColumnPair, AggregationSpec>();
        aggregationSpecs.put(AggregationFunctionColumnPair.COUNT_STAR, AggregationSpec.DEFAULT);
        for (String numericMetric : numericMetrics) {
            aggregationSpecs.put(new AggregationFunctionColumnPair(AggregationFunctionType.SUM, numericMetric), AggregationSpec.DEFAULT);
        }
        return new StarTreeV2BuilderConfig(dimensionsSplitOrder, Collections.emptySet(), aggregationSpecs, 10000);
    }

    public static Map<String, JsonNode> convertJsonNodeToMap(JsonNode columnsMetadata) {
        HashMap<String, JsonNode> map = new HashMap<String, JsonNode>();
        for (JsonNode columnMetadata : columnsMetadata) {
            String columnName = columnMetadata.get("columnName").asText();
            map.put(columnName, columnMetadata);
        }
        return map;
    }

    private StarTreeV2BuilderConfig(List<String> dimensionsSplitOrder, Set<String> skipStarNodeCreationForDimensions, TreeMap<AggregationFunctionColumnPair, AggregationSpec> aggregationSpecs, int maxLeafRecords) {
        this._dimensionsSplitOrder = dimensionsSplitOrder;
        this._skipStarNodeCreationForDimensions = skipStarNodeCreationForDimensions;
        this._aggregationSpecs = aggregationSpecs;
        this._maxLeafRecords = maxLeafRecords;
    }

    public List<String> getDimensionsSplitOrder() {
        return this._dimensionsSplitOrder;
    }

    public Set<String> getSkipStarNodeCreationForDimensions() {
        return this._skipStarNodeCreationForDimensions;
    }

    public TreeMap<AggregationFunctionColumnPair, AggregationSpec> getAggregationSpecs() {
        return this._aggregationSpecs;
    }

    public Set<AggregationFunctionColumnPair> getFunctionColumnPairs() {
        return this._aggregationSpecs.keySet();
    }

    public int getMaxLeafRecords() {
        return this._maxLeafRecords;
    }

    public void writeMetadata(Configuration metadataProperties, int totalDocs) {
        metadataProperties.setProperty("total.docs", (Object)totalDocs);
        metadataProperties.setProperty("split.order", this._dimensionsSplitOrder);
        metadataProperties.setProperty("function.column.pairs", this._aggregationSpecs.keySet());
        metadataProperties.setProperty("aggregation.count", (Object)this._aggregationSpecs.size());
        int index = 0;
        for (Map.Entry<AggregationFunctionColumnPair, AggregationSpec> entry : this._aggregationSpecs.entrySet()) {
            AggregationFunctionColumnPair functionColumnPair = entry.getKey();
            AggregationSpec aggregationSpec = entry.getValue();
            String prefix = "aggregation." + index + ".";
            metadataProperties.setProperty(prefix + "function.type", (Object)functionColumnPair.getFunctionType().getName());
            metadataProperties.setProperty(prefix + "column.name", (Object)functionColumnPair.getColumn());
            metadataProperties.setProperty(prefix + "compression.codec", (Object)aggregationSpec.getCompressionType());
            ++index;
        }
        metadataProperties.setProperty("max.leaf.records", (Object)this._maxLeafRecords);
        metadataProperties.setProperty("skip.star.node.creation", this._skipStarNodeCreationForDimensions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StarTreeV2BuilderConfig)) {
            return false;
        }
        StarTreeV2BuilderConfig that = (StarTreeV2BuilderConfig)o;
        return this._maxLeafRecords == that._maxLeafRecords && Objects.equals(this._dimensionsSplitOrder, that._dimensionsSplitOrder) && Objects.equals(this._skipStarNodeCreationForDimensions, that._skipStarNodeCreationForDimensions) && Objects.equals(this._aggregationSpecs, that._aggregationSpecs);
    }

    public int hashCode() {
        return Objects.hash(this._dimensionsSplitOrder, this._skipStarNodeCreationForDimensions, this._aggregationSpecs, this._maxLeafRecords);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("splitOrder", this._dimensionsSplitOrder).append("skipStarNodeCreation", this._skipStarNodeCreationForDimensions).append("aggregationSpecs", this._aggregationSpecs).append("maxLeafRecords", this._maxLeafRecords).toString();
    }
}

