/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree.v2.builder;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.segment.local.startree.StarTreeBuilderUtils;
import org.apache.pinot.segment.local.startree.v2.builder.OffHeapSingleTreeBuilder;
import org.apache.pinot.segment.local.startree.v2.builder.OnHeapSingleTreeBuilder;
import org.apache.pinot.segment.local.startree.v2.builder.SingleTreeBuilder;
import org.apache.pinot.segment.local.startree.v2.builder.StarTreeIndexCombiner;
import org.apache.pinot.segment.local.startree.v2.builder.StarTreeIndexSeparator;
import org.apache.pinot.segment.local.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeIndexMapUtils;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Constants;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;
import org.apache.pinot.spi.env.CommonsConfigurationUtils;
import org.apache.pinot.spi.utils.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleTreesBuilder
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleTreesBuilder.class);
    private final List<StarTreeV2BuilderConfig> _builderConfigs;
    private final BuildMode _buildMode;
    private final File _segmentDirectory;
    private final PropertiesConfiguration _metadataProperties;
    private final ImmutableSegment _segment;
    private StarTreeIndexSeparator _separator;
    private File _separatorTempDir;

    public MultipleTreesBuilder(List<StarTreeV2BuilderConfig> builderConfigs, File indexDir, BuildMode buildMode) throws Exception {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(builderConfigs), (Object)"Must provide star-tree builder configs");
        this._builderConfigs = builderConfigs;
        this._buildMode = buildMode;
        this._segmentDirectory = SegmentDirectoryPaths.findSegmentDirectory((File)indexDir);
        this._metadataProperties = CommonsConfigurationUtils.fromFile((File)new File(this._segmentDirectory, "metadata.properties"));
        this._separator = this.getSeparator();
        this._segment = ImmutableSegmentLoader.load(indexDir, ReadMode.mmap);
    }

    public MultipleTreesBuilder(@Nullable List<StarTreeIndexConfig> indexConfigs, boolean enableDefaultStarTree, File indexDir, BuildMode buildMode) throws Exception {
        Preconditions.checkArgument((CollectionUtils.isNotEmpty(indexConfigs) || enableDefaultStarTree ? 1 : 0) != 0, (Object)"Must provide star-tree index configs or enable default star-tree");
        this._buildMode = buildMode;
        this._segmentDirectory = SegmentDirectoryPaths.findSegmentDirectory((File)indexDir);
        this._metadataProperties = CommonsConfigurationUtils.fromFile((File)new File(this._segmentDirectory, "metadata.properties"));
        Preconditions.checkState((!this._metadataProperties.containsKey("startree.v2.count") ? 1 : 0) != 0, (Object)"Star-tree already exists");
        this._segment = ImmutableSegmentLoader.load(indexDir, ReadMode.mmap);
        try {
            this._builderConfigs = StarTreeBuilderUtils.generateBuilderConfigs(indexConfigs, enableDefaultStarTree, this._segment.getSegmentMetadata());
        }
        catch (Exception e) {
            this._segment.destroy();
            throw e;
        }
    }

    @Nullable
    private StarTreeIndexSeparator getSeparator() throws Exception {
        if (!this._metadataProperties.containsKey("startree.v2.count")) {
            return null;
        }
        try {
            this._separatorTempDir = new File(this._segmentDirectory, "existing_star_tree_tmp");
            FileUtils.forceMkdir((File)this._separatorTempDir);
            FileUtils.moveFileToDirectory((File)new File(this._segmentDirectory, "star_tree_index"), (File)this._separatorTempDir, (boolean)false);
            FileUtils.moveFileToDirectory((File)new File(this._segmentDirectory, "star_tree_index_map"), (File)this._separatorTempDir, (boolean)false);
            StarTreeIndexSeparator separator = new StarTreeIndexSeparator(new File(this._separatorTempDir, "star_tree_index_map"), new File(this._separatorTempDir, "star_tree_index"), this._metadataProperties);
            this._metadataProperties.subset("startree.v2").clear();
            CommonsConfigurationUtils.saveToFile((PropertiesConfiguration)this._metadataProperties, (File)new File(this._segmentDirectory, "metadata.properties"));
            return separator;
        }
        catch (Exception e) {
            try {
                FileUtils.forceDelete((File)this._separatorTempDir);
            }
            catch (Exception e1) {
                LOGGER.warn("Caught exception while deleting the separator tmp directory: {}", (Object)this._separatorTempDir.getAbsolutePath());
            }
            throw e;
        }
    }

    public void build() throws Exception {
        long startTime = System.currentTimeMillis();
        int numStarTrees = this._builderConfigs.size();
        int reusedStarTrees = 0;
        LOGGER.info("Starting building {} star-trees with configs: {} using {} builder", new Object[]{numStarTrees, this._builderConfigs, this._buildMode});
        try (StarTreeIndexCombiner indexCombiner = new StarTreeIndexCombiner(new File(this._segmentDirectory, "star_tree_index"));){
            File starTreeIndexDir = new File(this._segmentDirectory, "star_tree_tmp");
            FileUtils.forceMkdir((File)starTreeIndexDir);
            this._metadataProperties.addProperty("startree.v2.count", (Object)numStarTrees);
            ArrayList<List<Pair<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>>> indexMaps = new ArrayList<List<Pair<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>>>(numStarTrees);
            for (int i = 0; i < numStarTrees; ++i) {
                StarTreeV2BuilderConfig builderConfig = this._builderConfigs.get(i);
                Configuration metadataProperties = this._metadataProperties.subset(StarTreeV2Constants.MetadataKey.getStarTreePrefix((int)i));
                if (this._separator != null && this.handleExistingStarTreeAddition(starTreeIndexDir, metadataProperties, builderConfig)) {
                    LOGGER.info("Reused existing star-tree: {}", (Object)builderConfig.toString());
                    ++reusedStarTrees;
                } else {
                    try (SingleTreeBuilder singleTreeBuilder = MultipleTreesBuilder.getSingleTreeBuilder(builderConfig, starTreeIndexDir, this._segment, metadataProperties, this._buildMode);){
                        singleTreeBuilder.build();
                    }
                }
                indexMaps.add(indexCombiner.combine(builderConfig, starTreeIndexDir));
            }
            CommonsConfigurationUtils.saveToFile((PropertiesConfiguration)this._metadataProperties, (File)new File(this._segmentDirectory, "metadata.properties"));
            StarTreeIndexMapUtils.storeToFile(indexMaps, new File(this._segmentDirectory, "star_tree_index_map"));
            FileUtils.forceDelete((File)starTreeIndexDir);
        }
        LOGGER.info("Finished building {} star-trees ({} reused) in {}ms", new Object[]{numStarTrees, reusedStarTrees, System.currentTimeMillis() - startTime});
    }

    private boolean handleExistingStarTreeAddition(File starTreeIndexDir, Configuration metadataProperties, StarTreeV2BuilderConfig builderConfig) throws IOException {
        int totalDocs = this._separator.separate(starTreeIndexDir, builderConfig);
        if (totalDocs == -1) {
            return false;
        }
        builderConfig.writeMetadata(metadataProperties, totalDocs);
        return true;
    }

    private static SingleTreeBuilder getSingleTreeBuilder(StarTreeV2BuilderConfig builderConfig, File outputDir, ImmutableSegment segment, Configuration metadataProperties, BuildMode buildMode) throws FileNotFoundException {
        if (buildMode == BuildMode.ON_HEAP) {
            return new OnHeapSingleTreeBuilder(builderConfig, outputDir, segment, metadataProperties);
        }
        return new OffHeapSingleTreeBuilder(builderConfig, outputDir, segment, metadataProperties);
    }

    @Override
    public void close() {
        if (this._separatorTempDir != null) {
            try {
                FileUtils.forceDelete((File)this._separatorTempDir);
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception while deleting the separator tmp directory: {}", (Object)this._separatorTempDir.getAbsolutePath());
            }
        }
        this._segment.destroy();
    }

    public static enum BuildMode {
        ON_HEAP,
        OFF_HEAP;

    }
}

