/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.store;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene95.Lucene95Codec;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.pinot.segment.local.segment.creator.impl.vector.lucene95.HnswCodec;
import org.apache.pinot.segment.local.segment.creator.impl.vector.lucene95.HnswVectorsFormat;
import org.apache.pinot.segment.spi.index.creator.VectorIndexConfig;

public class VectorIndexUtils {
    private VectorIndexUtils() {
    }

    static void cleanupVectorIndex(File segDir, String column) {
        File luceneIndexFile = new File(segDir, column + ".vector.hnsw.index");
        FileUtils.deleteQuietly((File)luceneIndexFile);
        File luceneMappingFile = new File(segDir, column + ".vector.hnsw.mapping");
        FileUtils.deleteQuietly((File)luceneMappingFile);
        File nativeIndexFile = new File(segDir, column + ".vector.index");
        FileUtils.deleteQuietly((File)nativeIndexFile);
    }

    static boolean hasVectorIndex(File segDir, String column) {
        return new File(segDir, column + ".vector.hnsw.index").exists() || new File(segDir, column + ".vector.index").exists();
    }

    public static VectorSimilarityFunction toSimilarityFunction(VectorIndexConfig.VectorDistanceFunction distanceFunction) {
        switch (distanceFunction) {
            case COSINE: {
                return VectorSimilarityFunction.COSINE;
            }
            case INNER_PRODUCT: {
                return VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT;
            }
            case EUCLIDEAN: {
                return VectorSimilarityFunction.EUCLIDEAN;
            }
            case DOT_PRODUCT: {
                return VectorSimilarityFunction.DOT_PRODUCT;
            }
        }
        throw new IllegalArgumentException("Unknown distance function: " + distanceFunction);
    }

    public static IndexWriterConfig getIndexWriterConfig(VectorIndexConfig vectorIndexConfig) {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig();
        double maxBufferSizeMB = Double.parseDouble(vectorIndexConfig.getProperties().getOrDefault("maxBufferSizeMB", String.valueOf(16.0)));
        boolean commit = Boolean.parseBoolean(vectorIndexConfig.getProperties().getOrDefault("commit", String.valueOf(true)));
        boolean useCompoundFile = Boolean.parseBoolean(vectorIndexConfig.getProperties().getOrDefault("useCompoundFile", String.valueOf(true)));
        indexWriterConfig.setRAMBufferSizeMB(maxBufferSizeMB);
        indexWriterConfig.setCommitOnClose(commit);
        indexWriterConfig.setUseCompoundFile(useCompoundFile);
        int maxCon = Integer.parseInt(vectorIndexConfig.getProperties().getOrDefault("maxCon", String.valueOf(16)));
        int beamWidth = Integer.parseInt(vectorIndexConfig.getProperties().getOrDefault("beamWidth", String.valueOf(100)));
        int maxDimensions = Integer.parseInt(vectorIndexConfig.getProperties().getOrDefault("maxDimensions", String.valueOf(2048)));
        HnswVectorsFormat knnVectorsFormat = new HnswVectorsFormat(maxCon, beamWidth, maxDimensions);
        Lucene95Codec.Mode mode = Lucene95Codec.Mode.valueOf((String)vectorIndexConfig.getProperties().getOrDefault("mode", Lucene95Codec.Mode.BEST_SPEED.name()));
        indexWriterConfig.setCodec((Codec)new HnswCodec(mode, knnVectorsFormat));
        return indexWriterConfig;
    }
}

