/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.store;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.pinot.segment.local.segment.creator.impl.text.LuceneTextIndexCreator;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.config.table.FSTType;

public class TextIndexUtils {
    private TextIndexUtils() {
    }

    static void cleanupTextIndex(File segDir, String column) {
        File luceneIndexFile = new File(segDir, column + ".lucene.index");
        FileUtils.deleteQuietly((File)luceneIndexFile);
        File luceneMappingFile = new File(segDir, column + ".lucene.mapping");
        FileUtils.deleteQuietly((File)luceneMappingFile);
        File luceneV9IndexFile = new File(segDir, column + ".lucene.v9.index");
        FileUtils.deleteQuietly((File)luceneV9IndexFile);
        File luceneV9MappingFile = new File(segDir, column + ".lucene.mapping");
        FileUtils.deleteQuietly((File)luceneV9MappingFile);
        File nativeIndexFile = new File(segDir, column + ".nativetext.idx");
        FileUtils.deleteQuietly((File)nativeIndexFile);
    }

    static boolean hasTextIndex(File segDir, String column) {
        return new File(segDir, column + ".lucene.index").exists() || new File(segDir, column + ".lucene.v9.index").exists() || new File(segDir, column + ".nativetext.idx").exists();
    }

    public static boolean isFstTypeNative(@Nullable Map<String, String> textIndexProperties) {
        if (textIndexProperties == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : textIndexProperties.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase("fstType")) continue;
            return entry.getValue().equalsIgnoreCase("native");
        }
        return false;
    }

    public static FSTType getFSTTypeOfIndex(File indexDir, String column) {
        return SegmentDirectoryPaths.findTextIndexIndexFile((File)indexDir, (String)column) != null ? FSTType.LUCENE : FSTType.NATIVE;
    }

    public static List<String> extractStopWordsInclude(String colName, Map<String, Map<String, String>> columnProperties) {
        return TextIndexUtils.extractStopWordsInclude(columnProperties.getOrDefault(colName, null));
    }

    public static List<String> extractStopWordsExclude(String colName, Map<String, Map<String, String>> columnProperties) {
        return TextIndexUtils.extractStopWordsExclude(columnProperties.getOrDefault(colName, null));
    }

    public static List<String> extractStopWordsInclude(Map<String, String> columnProperty) {
        return TextIndexUtils.parseEntryAsString(columnProperty, "stopWordInclude");
    }

    public static List<String> extractStopWordsExclude(Map<String, String> columnProperty) {
        return TextIndexUtils.parseEntryAsString(columnProperty, "stopWordExclude");
    }

    private static List<String> parseEntryAsString(@Nullable Map<String, String> columnProperties, String stopWordKey) {
        if (columnProperties == null) {
            return Collections.emptyList();
        }
        String includeWords = columnProperties.getOrDefault(stopWordKey, "");
        return Arrays.stream(includeWords.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public static Analyzer getAnalyzerFromClassName(String luceneAnalyzerClass) throws ReflectiveOperationException {
        return (Analyzer)Class.forName(luceneAnalyzerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static StandardAnalyzer getStandardAnalyzerWithCustomizedStopWords(@Nullable List<String> stopWordsInclude, @Nullable List<String> stopWordsExclude) {
        HashSet<String> stopWordSet = LuceneTextIndexCreator.getDefaultEnglishStopWordsSet();
        if (stopWordsInclude != null) {
            stopWordSet.addAll(stopWordsInclude);
        }
        if (stopWordsExclude != null) {
            stopWordsExclude.forEach(stopWordSet::remove);
        }
        return new StandardAnalyzer(new CharArraySet(stopWordSet, true));
    }
}

