/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.store;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.pinot.segment.local.segment.store.IndexKey;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeIndexMapUtils;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Metadata;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.utils.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarTreeIndexReader
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarTreeIndexReader.class);
    private final File _segmentDirectory;
    private final SegmentMetadataImpl _segmentMetadata;
    private final ReadMode _readMode;
    private final File _indexFile;
    private final int _numStarTrees;
    private final List<Map<IndexKey, StarTreeIndexEntry>> _indexColumnEntries;
    private PinotDataBuffer _dataBuffer;

    public StarTreeIndexReader(File segmentDirectory, SegmentMetadataImpl segmentMetadata, ReadMode readMode) throws IOException, ConfigurationException {
        Preconditions.checkNotNull((Object)segmentDirectory);
        Preconditions.checkArgument((boolean)segmentDirectory.exists(), (Object)("SegmentDirectory: " + segmentDirectory + " does not exist"));
        Preconditions.checkArgument((boolean)segmentDirectory.isDirectory(), (Object)("SegmentDirectory: " + segmentDirectory + " is not a directory"));
        Preconditions.checkNotNull((Object)segmentMetadata);
        Preconditions.checkNotNull((Object)readMode);
        this._segmentDirectory = segmentDirectory;
        this._segmentMetadata = segmentMetadata;
        this._readMode = readMode;
        this._numStarTrees = this._segmentMetadata.getStarTreeV2MetadataList().size();
        this._indexFile = new File(this._segmentDirectory, "star_tree_index");
        this._indexColumnEntries = new ArrayList<Map<IndexKey, StarTreeIndexEntry>>(this._numStarTrees);
        this.load();
    }

    private void load() throws IOException, ConfigurationException {
        List<Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>> indexMapList;
        try (FileInputStream inputStream = new FileInputStream(new File(this._segmentDirectory, "star_tree_index_map"));){
            indexMapList = StarTreeIndexMapUtils.loadFromInputStream(inputStream, this._numStarTrees);
        }
        this._dataBuffer = this._readMode == ReadMode.heap ? PinotDataBuffer.loadFile((File)this._indexFile, (long)0L, (long)this._indexFile.length(), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (String)("StarTree V2 data buffer from: " + this._indexFile)) : PinotDataBuffer.mapFile((File)this._indexFile, (boolean)true, (long)0L, (long)this._indexFile.length(), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (String)("StarTree V2 data buffer from: " + this._indexFile));
        for (int i = 0; i < this._numStarTrees; ++i) {
            this.mapBufferEntries(i, indexMapList.get(i));
        }
        LOGGER.debug("Loaded StarTree index data buffers: {} in segment: {}", this._indexColumnEntries, (Object)this._segmentDirectory);
    }

    private void mapBufferEntries(int starTreeId, Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue> indexMap) {
        HashMap<IndexKey, StarTreeIndexEntry> columnEntries = new HashMap<IndexKey, StarTreeIndexEntry>();
        this._indexColumnEntries.add(columnEntries);
        columnEntries.put(new IndexKey(String.valueOf(starTreeId), StandardIndexes.inverted()), new StarTreeIndexEntry(indexMap.get(StarTreeIndexMapUtils.STAR_TREE_INDEX_KEY), this._dataBuffer, ByteOrder.LITTLE_ENDIAN));
        List starTreeMetadataList = this._segmentMetadata.getStarTreeV2MetadataList();
        StarTreeV2Metadata starTreeMetadata = (StarTreeV2Metadata)starTreeMetadataList.get(starTreeId);
        for (String dimension : starTreeMetadata.getDimensionsSplitOrder()) {
            columnEntries.put(new IndexKey(dimension, StandardIndexes.forward()), new StarTreeIndexEntry(indexMap.get(new StarTreeIndexMapUtils.IndexKey(StarTreeIndexMapUtils.IndexType.FORWARD_INDEX, dimension)), this._dataBuffer, ByteOrder.BIG_ENDIAN));
        }
        for (AggregationFunctionColumnPair functionColumnPair : starTreeMetadata.getFunctionColumnPairs()) {
            String metric = functionColumnPair.toColumnName();
            columnEntries.put(new IndexKey(metric, StandardIndexes.forward()), new StarTreeIndexEntry(indexMap.get(new StarTreeIndexMapUtils.IndexKey(StarTreeIndexMapUtils.IndexType.FORWARD_INDEX, metric)), this._dataBuffer, ByteOrder.BIG_ENDIAN));
        }
    }

    public PinotDataBuffer getBuffer(int starTreeId, String column, IndexType<?, ?, ?> type) throws IOException {
        if (this._indexColumnEntries.size() <= starTreeId) {
            throw new RuntimeException(String.format("Could not find StarTree index: %s in segment: %s", starTreeId, this._segmentDirectory.toString()));
        }
        StarTreeIndexEntry entry = this._indexColumnEntries.get(starTreeId).get(new IndexKey(column, type));
        if (entry != null && entry._buffer != null) {
            return entry._buffer;
        }
        throw new RuntimeException(String.format("Could not find index for column: %s, type: %s in StarTree index: %s in segment: %s", column, type, starTreeId, this._segmentDirectory.toString()));
    }

    public boolean hasIndexFor(int starTreeId, String column, IndexType<?, ?, ?> type) {
        if (this._indexColumnEntries.size() <= starTreeId) {
            return false;
        }
        return this._indexColumnEntries.get(starTreeId).containsKey(new IndexKey(column, type));
    }

    public String toString() {
        return this._indexFile.toString();
    }

    @Override
    public void close() throws IOException {
        this._indexColumnEntries.clear();
        this._dataBuffer.close();
    }

    private static class StarTreeIndexEntry {
        private final long _offset;
        private final long _size;
        private final PinotDataBuffer _buffer;

        public StarTreeIndexEntry(long offset, long size, PinotDataBuffer buffer) {
            this._offset = offset;
            this._size = size;
            this._buffer = buffer;
        }

        public StarTreeIndexEntry(StarTreeIndexMapUtils.IndexValue indexValue, PinotDataBuffer dataBuffer, ByteOrder byteOrder) {
            this(indexValue._offset, indexValue._size, dataBuffer.view(indexValue._offset, indexValue._offset + indexValue._size, byteOrder));
        }

        public String toString() {
            return "StarTreeIndexEntry{_offset=" + this._offset + ", _size=" + this._size + "}";
        }
    }
}

