/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.readers;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.spi.IndexSegment;

public class LazyRow {
    private final Map<String, Object> _fieldToValueMap = new HashMap<String, Object>();
    private final Set<String> _nullValueFields = new HashSet<String>();
    private IndexSegment _segment;
    private int _docId;

    public void init(IndexSegment segment, int docId) {
        this.clear();
        this._segment = segment;
        this._docId = docId;
    }

    @Nullable
    public Object getValue(String fieldName) {
        if (this._nullValueFields.contains(fieldName)) {
            return null;
        }
        if (this._segment == null) {
            throw new IllegalStateException("Index segment for Lazy row is uninitialized.");
        }
        return this._fieldToValueMap.computeIfAbsent(fieldName, col -> {
            Object value = null;
            try (PinotSegmentColumnReader columnReader = new PinotSegmentColumnReader(this._segment, (String)col);){
                if (!columnReader.isNull(this._docId)) {
                    value = columnReader.getValue(this._docId);
                } else {
                    this._nullValueFields.add(fieldName);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Caught exception while closing pinotSegmentColumnReader for fieldName: %s", fieldName), e);
            }
            return value;
        });
    }

    public boolean isNullValue(String fieldName) {
        return this._nullValueFields.contains(fieldName) || this.getValue(fieldName) == null;
    }

    public void clear() {
        this._fieldToValueMap.clear();
        this._nullValueFields.clear();
    }

    public Set<String> getColumnNames() {
        if (this._segment == null) {
            throw new IllegalStateException("Index segment for Lazy row is uninitialized.");
        }
        return this._segment.getColumnNames();
    }
}

