/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.geospatial;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.pinot.segment.local.segment.index.readers.BitmapInvertedIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.LongDictionary;
import org.apache.pinot.segment.spi.index.reader.H3IndexReader;
import org.apache.pinot.segment.spi.index.reader.H3IndexResolution;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableH3IndexReader
implements H3IndexReader {
    public static final Logger LOGGER = LoggerFactory.getLogger(ImmutableH3IndexReader.class);
    private final H3IndexResolution _resolution;
    private final LongDictionary _dictionary;
    private final BitmapInvertedIndexReader _invertedIndex;

    public ImmutableH3IndexReader(PinotDataBuffer dataBuffer) {
        int version = dataBuffer.getInt(0);
        Preconditions.checkArgument((version == 1 ? 1 : 0) != 0, (String)"Unsupported H3 index version: %s", (int)version);
        int numValues = dataBuffer.getInt(4);
        this._resolution = new H3IndexResolution(dataBuffer.getShort(8));
        long dictionaryOffset = 10L;
        long invertedIndexOffset = dictionaryOffset + (long)numValues * 8L;
        PinotDataBuffer dictionaryBuffer = dataBuffer.view(dictionaryOffset, invertedIndexOffset, ByteOrder.BIG_ENDIAN);
        PinotDataBuffer invertedIndexBuffer = dataBuffer.view(invertedIndexOffset, dataBuffer.size(), ByteOrder.BIG_ENDIAN);
        this._dictionary = new LongDictionary(dictionaryBuffer, numValues);
        this._invertedIndex = new BitmapInvertedIndexReader(invertedIndexBuffer, numValues);
    }

    public ImmutableRoaringBitmap getDocIds(long h3Id) {
        int dictId = this._dictionary.indexOf(h3Id);
        return dictId >= 0 ? this._invertedIndex.getDocIds(dictId) : new MutableRoaringBitmap();
    }

    public H3IndexResolution getH3IndexResolution() {
        return this._resolution;
    }

    public void close() throws IOException {
        this._dictionary.close();
        this._invertedIndex.close();
    }
}

