/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.CleanerUtil;

public class ChunkReaderContext
implements ForwardIndexReaderContext {
    private final ByteBuffer _chunkBuffer;
    private int _chunkId;
    private List<ForwardIndexReader.ByteRange> _ranges;

    public ChunkReaderContext(int maxChunkSize) {
        this._chunkBuffer = ByteBuffer.allocateDirect(maxChunkSize);
        this._chunkId = -1;
        this._ranges = new ArrayList<ForwardIndexReader.ByteRange>();
    }

    public void close() throws IOException {
        if (CleanerUtil.UNMAP_SUPPORTED) {
            CleanerUtil.getCleaner().freeBuffer(this._chunkBuffer);
        }
    }

    public ByteBuffer getChunkBuffer() {
        return this._chunkBuffer;
    }

    public int getChunkId() {
        return this._chunkId;
    }

    public void setChunkId(int _chunkId) {
        this._chunkId = _chunkId;
    }

    public List<ForwardIndexReader.ByteRange> getRanges() {
        return this._ranges;
    }

    public void setRanges(List<ForwardIndexReader.ByteRange> _ranges) {
        this._ranges = _ranges;
    }
}

