/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.segment.local.io.compression.ChunkCompressorFactory;
import org.apache.pinot.segment.local.segment.index.readers.forward.ChunkReaderContext;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkDecompressor;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseChunkForwardIndexReader
implements ForwardIndexReader<ChunkReaderContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseChunkForwardIndexReader.class);
    protected final PinotDataBuffer _dataBuffer;
    protected final FieldSpec.DataType _storedType;
    protected final int _numChunks;
    protected final int _numDocsPerChunk;
    protected final int _lengthOfLongestEntry;
    protected final boolean _isCompressed;
    protected final ChunkCompressionType _compressionType;
    protected final ChunkDecompressor _chunkDecompressor;
    protected final PinotDataBuffer _dataHeader;
    protected final int _headerEntryChunkOffsetSize;
    protected final PinotDataBuffer _rawData;
    protected final boolean _isSingleValue;
    protected final int _dataHeaderStart;
    protected final int _rawDataStart;

    protected BaseChunkForwardIndexReader(PinotDataBuffer dataBuffer, FieldSpec.DataType storedType, boolean isSingleValue) {
        this._dataBuffer = dataBuffer;
        this._storedType = storedType;
        int headerOffset = 0;
        int version = this._dataBuffer.getInt(headerOffset);
        this._numChunks = this._dataBuffer.getInt(headerOffset += 4);
        this._numDocsPerChunk = this._dataBuffer.getInt(headerOffset += 4);
        this._lengthOfLongestEntry = this._dataBuffer.getInt(headerOffset += 4);
        if (storedType.isFixedWidth() && isSingleValue) {
            Preconditions.checkState((this._lengthOfLongestEntry == storedType.size() ? 1 : 0) != 0);
        }
        int dataHeaderStart = headerOffset += 4;
        if (version > 1) {
            this._dataBuffer.getInt(headerOffset);
            this._compressionType = ChunkCompressionType.valueOf((int)this._dataBuffer.getInt(headerOffset += 4));
            this._chunkDecompressor = ChunkCompressorFactory.getDecompressor(this._compressionType);
            this._isCompressed = !this._compressionType.equals((Object)ChunkCompressionType.PASS_THROUGH);
            dataHeaderStart = this._dataBuffer.getInt(headerOffset += 4);
        } else {
            this._isCompressed = true;
            this._compressionType = ChunkCompressionType.SNAPPY;
            this._chunkDecompressor = ChunkCompressorFactory.getDecompressor(this._compressionType);
        }
        this._headerEntryChunkOffsetSize = version <= 2 ? 4 : 8;
        int dataHeaderLength = this._numChunks * this._headerEntryChunkOffsetSize;
        int rawDataStart = dataHeaderStart + dataHeaderLength;
        this._dataHeaderStart = dataHeaderStart;
        this._dataHeader = this._dataBuffer.view((long)dataHeaderStart, (long)rawDataStart);
        this._rawDataStart = rawDataStart;
        this._rawData = this._dataBuffer.view((long)rawDataStart, this._dataBuffer.size());
        this._isSingleValue = isSingleValue;
    }

    protected ByteBuffer getChunkBuffer(int docId, ChunkReaderContext context) {
        int chunkId = this.getChunkId(docId);
        if (context.getChunkId() == chunkId) {
            return context.getChunkBuffer();
        }
        return this.decompressChunk(chunkId, context);
    }

    protected int getChunkId(int docId) {
        return docId / this._numDocsPerChunk;
    }

    protected void recordDocIdRangesUncompressed(int docId, int rowOffsetSize, List<ForwardIndexReader.ByteRange> ranges) {
        int chunkId = this.getChunkId(docId);
        int chunkRowId = docId % this._numDocsPerChunk;
        long chunkStartOffset = this.getChunkPositionAndRecordRanges(chunkId, ranges);
        ranges.add(new ForwardIndexReader.ByteRange(chunkStartOffset + (long)chunkRowId * (long)rowOffsetSize, 4));
        long valueStartOffset = chunkStartOffset + (long)this._dataBuffer.getInt(chunkStartOffset + (long)chunkRowId * (long)rowOffsetSize);
        long valueEndOffset = this.getValueEndOffsetAndRecordRanges(chunkId, chunkRowId, rowOffsetSize, chunkStartOffset, ranges);
        ranges.add(new ForwardIndexReader.ByteRange(valueStartOffset, (int)(valueEndOffset - valueStartOffset)));
    }

    protected long getValueEndOffsetAndRecordRanges(int chunkId, int chunkRowId, int rowOffsetSize, long chunkStartOffset, List<ForwardIndexReader.ByteRange> ranges) {
        if (chunkId == this._numChunks - 1) {
            if (chunkRowId == this._numDocsPerChunk - 1) {
                return this._dataBuffer.size();
            }
            ranges.add(new ForwardIndexReader.ByteRange(chunkStartOffset + (long)(chunkRowId + 1) * (long)rowOffsetSize, 4));
            int valueEndOffsetInChunk = this._dataBuffer.getInt(chunkStartOffset + (long)(chunkRowId + 1) * (long)rowOffsetSize);
            if (valueEndOffsetInChunk == 0) {
                return this._dataBuffer.size();
            }
            return chunkStartOffset + (long)valueEndOffsetInChunk;
        }
        if (chunkRowId == this._numDocsPerChunk - 1) {
            return this.getChunkPositionAndRecordRanges(chunkId + 1, ranges);
        }
        ranges.add(new ForwardIndexReader.ByteRange(chunkStartOffset + (long)(chunkRowId + 1) * (long)rowOffsetSize, 4));
        return chunkStartOffset + (long)this._dataBuffer.getInt(chunkStartOffset + (long)(chunkRowId + 1) * (long)rowOffsetSize);
    }

    protected void recordDocIdRanges(int docId, ChunkReaderContext context, List<ForwardIndexReader.ByteRange> ranges) {
        int chunkId = this.getChunkId(docId);
        if (context.getChunkId() == chunkId) {
            ranges.addAll(context.getRanges());
            return;
        }
        this.recordChunkRanges(chunkId, context, ranges);
    }

    protected void recordChunkRanges(int chunkId, ChunkReaderContext context, List<ForwardIndexReader.ByteRange> ranges) {
        int chunkSize;
        ArrayList<ForwardIndexReader.ByteRange> chunkRanges = new ArrayList<ForwardIndexReader.ByteRange>();
        long chunkPosition = this.getChunkPositionAndRecordRanges(chunkId, chunkRanges);
        if (chunkId == this._numChunks - 1) {
            chunkSize = (int)(this._dataBuffer.size() - chunkPosition);
        } else {
            long nextChunkOffset = this.getChunkPositionAndRecordRanges(chunkId + 1, chunkRanges);
            chunkSize = (int)(nextChunkOffset - chunkPosition);
        }
        chunkRanges.add(new ForwardIndexReader.ByteRange(chunkPosition, chunkSize));
        context.setChunkId(chunkId);
        context.setRanges(chunkRanges);
        ranges.addAll(chunkRanges);
    }

    protected ByteBuffer decompressChunk(int chunkId, ChunkReaderContext context) {
        int chunkSize;
        long chunkPosition = this.getChunkPosition(chunkId);
        if (chunkId == this._numChunks - 1) {
            chunkSize = (int)(this._dataBuffer.size() - chunkPosition);
        } else {
            long nextChunkOffset = this.getChunkPosition(chunkId + 1);
            chunkSize = (int)(nextChunkOffset - chunkPosition);
        }
        ByteBuffer decompressedBuffer = context.getChunkBuffer();
        decompressedBuffer.clear();
        try {
            this._chunkDecompressor.decompress(this._dataBuffer.toDirectByteBuffer(chunkPosition, chunkSize), decompressedBuffer);
        }
        catch (IOException e) {
            LOGGER.error("Exception caught while decompressing data chunk", (Throwable)e);
            throw new RuntimeException(e);
        }
        context.setChunkId(chunkId);
        return decompressedBuffer;
    }

    protected long getChunkPosition(int chunkId) {
        if (this._headerEntryChunkOffsetSize == 4) {
            return this._dataHeader.getInt(chunkId * this._headerEntryChunkOffsetSize);
        }
        return this._dataHeader.getLong(chunkId * this._headerEntryChunkOffsetSize);
    }

    protected long getChunkPositionAndRecordRanges(int chunkId, List<ForwardIndexReader.ByteRange> ranges) {
        if (this._headerEntryChunkOffsetSize == 4) {
            ranges.add(new ForwardIndexReader.ByteRange((long)(this._dataHeaderStart + chunkId * this._headerEntryChunkOffsetSize), 4));
            return this._dataHeader.getInt(chunkId * this._headerEntryChunkOffsetSize);
        }
        ranges.add(new ForwardIndexReader.ByteRange((long)(this._dataHeaderStart + chunkId * this._headerEntryChunkOffsetSize), 8));
        return this._dataHeader.getLong(chunkId * this._headerEntryChunkOffsetSize);
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return this._isSingleValue;
    }

    public FieldSpec.DataType getStoredType() {
        return this._storedType;
    }

    public ChunkCompressionType getCompressionType() {
        return this._compressionType;
    }

    public int getLengthOfLongestEntry() {
        return this._lengthOfLongestEntry;
    }

    public void readValuesSV(int[] docIds, int length, int[] values, ChunkReaderContext context) {
        block10: {
            block9: {
                if (!this._storedType.isFixedWidth() || this._isCompressed || !this.isContiguousRange(docIds, length)) break block9;
                switch (this._storedType) {
                    case INT: {
                        int minOffset = docIds[0] * 4;
                        IntBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asIntBuffer();
                        buffer.get(values, 0, length);
                        break block10;
                    }
                    case LONG: {
                        int minOffset = docIds[0] * 8;
                        LongBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asLongBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = (int)buffer.get(i);
                        }
                        break block10;
                    }
                    case FLOAT: {
                        int minOffset = docIds[0] * 4;
                        FloatBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asFloatBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = (int)buffer.get(i);
                        }
                        break block10;
                    }
                    case DOUBLE: {
                        int minOffset = docIds[0] * 8;
                        DoubleBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asDoubleBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = (int)buffer.get(i);
                        }
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            super.readValuesSV(docIds, length, values, (ForwardIndexReaderContext)context);
        }
    }

    public void readValuesSV(int[] docIds, int length, long[] values, ChunkReaderContext context) {
        block10: {
            block9: {
                if (!this._storedType.isFixedWidth() || this._isCompressed || !this.isContiguousRange(docIds, length)) break block9;
                switch (this._storedType) {
                    case INT: {
                        int minOffset = docIds[0] * 4;
                        IntBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asIntBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = buffer.get(i);
                        }
                        break block10;
                    }
                    case LONG: {
                        int minOffset = docIds[0] * 8;
                        LongBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asLongBuffer();
                        buffer.get(values, 0, length);
                        break block10;
                    }
                    case FLOAT: {
                        int minOffset = docIds[0] * 4;
                        FloatBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asFloatBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = (long)buffer.get(i);
                        }
                        break block10;
                    }
                    case DOUBLE: {
                        int minOffset = docIds[0] * 8;
                        DoubleBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asDoubleBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = (long)buffer.get(i);
                        }
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            super.readValuesSV(docIds, length, values, (ForwardIndexReaderContext)context);
        }
    }

    public void readValuesSV(int[] docIds, int length, float[] values, ChunkReaderContext context) {
        block10: {
            block9: {
                if (!this._storedType.isFixedWidth() || this._isCompressed || !this.isContiguousRange(docIds, length)) break block9;
                switch (this._storedType) {
                    case INT: {
                        int minOffset = docIds[0] * 4;
                        IntBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asIntBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = buffer.get(i);
                        }
                        break block10;
                    }
                    case LONG: {
                        int minOffset = docIds[0] * 8;
                        LongBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asLongBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = buffer.get(i);
                        }
                        break block10;
                    }
                    case FLOAT: {
                        int minOffset = docIds[0] * 4;
                        FloatBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asFloatBuffer();
                        buffer.get(values, 0, length);
                        break block10;
                    }
                    case DOUBLE: {
                        int minOffset = docIds[0] * 8;
                        DoubleBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asDoubleBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = (float)buffer.get(i);
                        }
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            super.readValuesSV(docIds, length, values, (ForwardIndexReaderContext)context);
        }
    }

    public void readValuesSV(int[] docIds, int length, double[] values, ChunkReaderContext context) {
        block10: {
            block9: {
                if (!this._storedType.isFixedWidth() || this._isCompressed || !this.isContiguousRange(docIds, length)) break block9;
                switch (this._storedType) {
                    case INT: {
                        int minOffset = docIds[0] * 4;
                        IntBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asIntBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = buffer.get(i);
                        }
                        break block10;
                    }
                    case LONG: {
                        int minOffset = docIds[0] * 8;
                        this.getLong(0, context);
                        LongBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asLongBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = buffer.get(i);
                        }
                        break block10;
                    }
                    case FLOAT: {
                        int minOffset = docIds[0] * 4;
                        FloatBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asFloatBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = buffer.get(i);
                        }
                        break block10;
                    }
                    case DOUBLE: {
                        int minOffset = docIds[0] * 8;
                        DoubleBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asDoubleBuffer();
                        buffer.get(values, 0, length);
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            super.readValuesSV(docIds, length, values, (ForwardIndexReaderContext)context);
        }
    }

    public void close() {
    }

    private boolean isContiguousRange(int[] docIds, int length) {
        return docIds[length - 1] - docIds[0] == length - 1;
    }
}

