/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import java.math.BigDecimal;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class LongDictionary
extends BaseImmutableDictionary {
    public LongDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 8);
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.LONG;
    }

    public int indexOf(long longValue) {
        return this.normalizeIndex(this.binarySearch(longValue));
    }

    public int insertionIndexOf(String stringValue) {
        return this.binarySearch(Long.parseLong(stringValue));
    }

    public Long get(int dictId) {
        return this.getLong(dictId);
    }

    public int getIntValue(int dictId) {
        return (int)this.getLong(dictId);
    }

    public long getLongValue(int dictId) {
        return this.getLong(dictId);
    }

    public float getFloatValue(int dictId) {
        return this.getLong(dictId);
    }

    public double getDoubleValue(int dictId) {
        return this.getLong(dictId);
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return BigDecimal.valueOf(this.getLong(dictId));
    }

    public String getStringValue(int dictId) {
        return Long.toString(this.getLong(dictId));
    }
}

