/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.dictionary.DictionaryIndexType;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexType;
import org.apache.pinot.segment.local.segment.index.loader.BaseIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.JsonIndexCreator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.JsonIndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonIndexHandler
extends BaseIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonIndexHandler.class);
    private final Map<String, JsonIndexConfig> _jsonIndexConfigs;

    public JsonIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> fieldIndexConfigs, @Nullable TableConfig tableConfig) {
        super(segmentDirectory, fieldIndexConfigs, tableConfig);
        this._jsonIndexConfigs = FieldIndexConfigsUtil.enableConfigByColumn((IndexType)StandardIndexes.json(), (Map)this._fieldIndexConfigs);
    }

    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._jsonIndexConfigs.keySet());
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.json());
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Need to remove existing json index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateJsonIndex(columnMetadata)) continue;
            LOGGER.info("Need to create new json index for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    public void updateIndices(SegmentDirectory.Writer segmentWriter) throws Exception {
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._jsonIndexConfigs.keySet());
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.json());
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Removing existing json index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, StandardIndexes.json());
            LOGGER.info("Removed existing json index from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateJsonIndex(columnMetadata)) continue;
            this.createJsonIndexForColumn(segmentWriter, columnMetadata);
        }
    }

    private boolean shouldCreateJsonIndex(ColumnMetadata columnMetadata) {
        return columnMetadata != null;
    }

    private void createJsonIndexForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        String columnName = columnMetadata.getColumnName();
        File inProgress = new File(indexDir, columnName + ".json.idx.inprogress");
        File jsonIndexFile = new File(indexDir, columnName + ".json.idx");
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)jsonIndexFile);
        }
        columnMetadata = this.createForwardIndexIfNeeded(segmentWriter, columnName, true);
        LOGGER.info("Creating new json index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
        Preconditions.checkState((columnMetadata.isSingleValue() && (columnMetadata.getDataType() == FieldSpec.DataType.STRING || columnMetadata.getDataType() == FieldSpec.DataType.JSON) ? 1 : 0) != 0, (Object)"Json index can only be applied to single-value STRING or JSON columns");
        if (columnMetadata.hasDictionary()) {
            this.handleDictionaryBasedColumn(segmentWriter, columnMetadata);
        } else {
            this.handleNonDictionaryBasedColumn(segmentWriter, columnMetadata);
        }
        if (this._segmentDirectory.getSegmentMetadata().getVersion() == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(segmentWriter, columnName, jsonIndexFile, StandardIndexes.json());
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created json index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
    }

    private void handleDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String columnName = columnMetadata.getColumnName();
        IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build();
        JsonIndexConfig config = this._jsonIndexConfigs.get(columnName);
        try (ForwardIndexReader<?> forwardIndexReader = ForwardIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             Dictionary dictionary = DictionaryIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             JsonIndexCreator jsonIndexCreator = (JsonIndexCreator)StandardIndexes.json().createIndexCreator((IndexCreationContext)context, (IndexConfig)config);){
            int numDocs = columnMetadata.getTotalDocs();
            for (int i = 0; i < numDocs; ++i) {
                int dictId = forwardIndexReader.getDictId(i, readerContext);
                jsonIndexCreator.add(dictionary.getStringValue(dictId));
            }
            jsonIndexCreator.seal();
        }
    }

    private void handleNonDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String columnName = columnMetadata.getColumnName();
        IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build();
        JsonIndexConfig config = this._jsonIndexConfigs.get(columnName);
        try (ForwardIndexReader<?> forwardIndexReader = ForwardIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             JsonIndexCreator jsonIndexCreator = (JsonIndexCreator)StandardIndexes.json().createIndexCreator((IndexCreationContext)context, (IndexConfig)config);){
            int numDocs = columnMetadata.getTotalDocs();
            for (int i = 0; i < numDocs; ++i) {
                jsonIndexCreator.add(forwardIndexReader.getString(i, readerContext));
            }
            jsonIndexCreator.seal();
        }
    }
}

