/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexReaderFactory;
import org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.segment.local.segment.index.readers.BytesDictionary;
import org.apache.pinot.segment.local.segment.index.readers.DoubleDictionary;
import org.apache.pinot.segment.local.segment.index.readers.FloatDictionary;
import org.apache.pinot.segment.local.segment.index.readers.IntDictionary;
import org.apache.pinot.segment.local.segment.index.readers.LongDictionary;
import org.apache.pinot.segment.local.segment.index.readers.StringDictionary;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.utils.SegmentMetadataUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;

public class ColumnMinMaxValueGenerator {
    private final SegmentMetadata _segmentMetadata;
    private final SegmentDirectory.Writer _segmentWriter;
    private final ColumnMinMaxValueGeneratorMode _columnMinMaxValueGeneratorMode;
    private PropertiesConfiguration _segmentProperties;
    private boolean _minMaxValueAdded;

    public ColumnMinMaxValueGenerator(SegmentMetadata segmentMetadata, SegmentDirectory.Writer segmentWriter, ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode) {
        this._segmentMetadata = segmentMetadata;
        this._segmentWriter = segmentWriter;
        this._columnMinMaxValueGeneratorMode = columnMinMaxValueGeneratorMode;
    }

    public boolean needAddColumnMinMaxValue() {
        for (String column : this.getColumnsToAddMinMaxValue()) {
            if (!this.needAddColumnMinMaxValueForColumn(column)) continue;
            return true;
        }
        return false;
    }

    public void addColumnMinMaxValue() throws Exception {
        Preconditions.checkState((this._columnMinMaxValueGeneratorMode != ColumnMinMaxValueGeneratorMode.NONE ? 1 : 0) != 0);
        this._segmentProperties = SegmentMetadataUtils.getPropertiesConfiguration((SegmentMetadata)this._segmentMetadata);
        for (String column : this.getColumnsToAddMinMaxValue()) {
            this.addColumnMinMaxValueForColumn(column);
        }
        if (this._minMaxValueAdded) {
            SegmentMetadataUtils.savePropertiesConfiguration((PropertiesConfiguration)this._segmentProperties, (File)this._segmentMetadata.getIndexDir());
        }
    }

    private List<String> getColumnsToAddMinMaxValue() {
        Schema schema = this._segmentMetadata.getSchema();
        ArrayList<String> columnsToAddMinMaxValue = new ArrayList<String>();
        switch (this._columnMinMaxValueGeneratorMode) {
            case ALL: {
                for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
                    if (fieldSpec.isVirtualColumn()) continue;
                    columnsToAddMinMaxValue.add(fieldSpec.getName());
                }
                break;
            }
            case NON_METRIC: {
                for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
                    if (fieldSpec.isVirtualColumn() || fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) continue;
                    columnsToAddMinMaxValue.add(fieldSpec.getName());
                }
                break;
            }
            case TIME: {
                for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
                    if (fieldSpec.isVirtualColumn() || fieldSpec.getFieldType() != FieldSpec.FieldType.TIME && fieldSpec.getFieldType() != FieldSpec.FieldType.DATE_TIME) continue;
                    columnsToAddMinMaxValue.add(fieldSpec.getName());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported generator mode: " + this._columnMinMaxValueGeneratorMode);
            }
        }
        return columnsToAddMinMaxValue;
    }

    private boolean needAddColumnMinMaxValueForColumn(String columnName) {
        ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(columnName);
        return columnMetadata.getMinValue() == null && columnMetadata.getMaxValue() == null && !columnMetadata.isMinMaxValueInvalid();
    }

    /*
     * Unable to fully structure code
     */
    private void addColumnMinMaxValueForColumn(String columnName) throws Exception {
        block94: {
            columnMetadata = this._segmentMetadata.getColumnMetadataFor(columnName);
            if (columnMetadata.getMinValue() != null || columnMetadata.getMaxValue() != null) {
                return;
            }
            dataType = columnMetadata.getDataType();
            storedType = dataType.getStoredType();
            if (columnMetadata.hasDictionary()) {
                dictionaryBuffer = this._segmentWriter.getIndexFor(columnName, StandardIndexes.dictionary());
                length = columnMetadata.getCardinality();
                switch (1.$SwitchMap$org$apache$pinot$spi$data$FieldSpec$DataType[storedType.ordinal()]) {
                    case 1: {
                        intDictionary = new IntDictionary(dictionaryBuffer, length);
                        try {
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, intDictionary.getStringValue(0), intDictionary.getStringValue(length - 1), storedType);
                            break block94;
                        }
                        finally {
                            intDictionary.close();
                        }
                    }
                    case 2: {
                        longDictionary = new LongDictionary(dictionaryBuffer, length);
                        try {
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, longDictionary.getStringValue(0), longDictionary.getStringValue(length - 1), storedType);
                            break block94;
                        }
                        finally {
                            longDictionary.close();
                        }
                    }
                    case 3: {
                        floatDictionary = new FloatDictionary(dictionaryBuffer, length);
                        try {
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, floatDictionary.getStringValue(0), floatDictionary.getStringValue(length - 1), storedType);
                            break block94;
                        }
                        finally {
                            floatDictionary.close();
                        }
                    }
                    case 4: {
                        doubleDictionary = new DoubleDictionary(dictionaryBuffer, length);
                        try {
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, doubleDictionary.getStringValue(0), doubleDictionary.getStringValue(length - 1), storedType);
                            break block94;
                        }
                        finally {
                            doubleDictionary.close();
                        }
                    }
                    case 5: {
                        stringDictionary = new StringDictionary(dictionaryBuffer, length, columnMetadata.getColumnMaxLength());
                        try {
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, stringDictionary.getStringValue(0), stringDictionary.getStringValue(length - 1), storedType);
                            break block94;
                        }
                        finally {
                            stringDictionary.close();
                        }
                    }
                    case 6: {
                        bytesDictionary = new BytesDictionary(dictionaryBuffer, length, columnMetadata.getColumnMaxLength());
                        try {
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, bytesDictionary.getStringValue(0), bytesDictionary.getStringValue(length - 1), storedType);
                            break block94;
                        }
                        finally {
                            bytesDictionary.close();
                        }
                    }
                    default: {
                        throw new IllegalStateException("Unsupported data type: " + dataType + " for column: " + columnName);
                    }
                }
            }
            numDocs = columnMetadata.getTotalDocs();
            rawIndexBuffer = this._segmentWriter.getIndexFor(columnName, StandardIndexes.forward());
            isSingleValue = this._segmentMetadata.getSchema().getFieldSpecFor(columnName).isSingleValueField();
            rawIndexReader = ForwardIndexReaderFactory.createRawIndexReader(rawIndexBuffer, storedType, isSingleValue);
            try {
                readerContext = rawIndexReader.createContext();
                try {
                    switch (1.$SwitchMap$org$apache$pinot$spi$data$FieldSpec$DataType[storedType.ordinal()]) {
                        case 1: {
                            min = 0x7FFFFFFF;
                            max = -2147483648;
                            if (isSingleValue) {
                                for (docId = 0; docId < numDocs; ++docId) {
                                    value = rawIndexReader.getInt(docId, readerContext);
                                    min = Math.min(min, value);
                                    max = Math.max(max, value);
                                }
                            } else {
                                for (docId = 0; docId < numDocs; ++docId) {
                                    for (int value : values = rawIndexReader.getIntMV(docId, readerContext)) {
                                        min = Math.min(min, value);
                                        max = Math.max(max, value);
                                    }
                                }
                            }
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, String.valueOf(min), String.valueOf(max), storedType);
                            ** break;
lbl86:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            min = 0x7FFFFFFFFFFFFFFFL;
                            max = -9223372036854775808L;
                            if (isSingleValue) {
                                for (docId = 0; docId < numDocs; ++docId) {
                                    value = rawIndexReader.getLong(docId, readerContext);
                                    min = Math.min(min, value);
                                    max = Math.max(max, value);
                                }
                            } else {
                                for (docId = 0; docId < numDocs; ++docId) {
                                    for (long value : values = rawIndexReader.getLongMV(docId, readerContext)) {
                                        min = Math.min(min, value);
                                        max = Math.max(max, value);
                                    }
                                }
                            }
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, String.valueOf(min), String.valueOf(max), storedType);
                            ** break;
lbl105:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            min = Infinityf;
                            max = -Infinityf;
                            if (isSingleValue) {
                                for (docId = 0; docId < numDocs; ++docId) {
                                    value = rawIndexReader.getFloat(docId, readerContext);
                                    min = Math.min(min, value);
                                    max = Math.max(max, value);
                                }
                            } else {
                                for (docId = 0; docId < numDocs; ++docId) {
                                    for (float value : values = rawIndexReader.getFloatMV(docId, readerContext)) {
                                        min = Math.min(min, value);
                                        max = Math.max(max, value);
                                    }
                                }
                            }
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, String.valueOf(min), String.valueOf(max), storedType);
                            ** break;
lbl124:
                            // 1 sources

                            break;
                        }
                        case 4: {
                            min = Infinity;
                            max = -Infinity;
                            if (isSingleValue) {
                                for (docId = 0; docId < numDocs; ++docId) {
                                    value = rawIndexReader.getDouble(docId, readerContext);
                                    min = Math.min(min, value);
                                    max = Math.max(max, value);
                                }
                            } else {
                                for (docId = 0; docId < numDocs; ++docId) {
                                    for (double value : values = rawIndexReader.getDoubleMV(docId, readerContext)) {
                                        min = Math.min(min, value);
                                        max = Math.max(max, value);
                                    }
                                }
                            }
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, String.valueOf(min), String.valueOf(max), storedType);
                            ** break;
lbl143:
                            // 1 sources

                            break;
                        }
                        case 5: {
                            min = null;
                            max = null;
                            if (isSingleValue) {
                                for (docId = 0; docId < numDocs; ++docId) {
                                    value = rawIndexReader.getString(docId, readerContext);
                                    if (min == null || StringUtils.compare((String)min, (String)value) > 0) {
                                        min = value;
                                    }
                                    if (max != null && StringUtils.compare((String)max, (String)value) >= 0) continue;
                                    max = value;
                                }
                            } else {
                                for (docId = 0; docId < numDocs; ++docId) {
                                    for (String value : values = rawIndexReader.getStringMV(docId, readerContext)) {
                                        if (min == null || StringUtils.compare((String)min, (String)value) > 0) {
                                            min = value;
                                        }
                                        if (max != null && StringUtils.compare((String)max, (String)value) >= 0) continue;
                                        max = value;
                                    }
                                }
                            }
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, min, max, storedType);
                            ** break;
lbl166:
                            // 1 sources

                            break;
                        }
                        case 6: {
                            min = null;
                            max = null;
                            if (isSingleValue) {
                                for (docId = 0; docId < numDocs; ++docId) {
                                    value = rawIndexReader.getBytes(docId, readerContext);
                                    if (min == null || ByteArray.compare((byte[])value, (byte[])min) > 0) {
                                        min = value;
                                    }
                                    if (max != null && ByteArray.compare((byte[])value, (byte[])max) >= 0) continue;
                                    max = value;
                                }
                            } else {
                                for (docId = 0; docId < numDocs; ++docId) {
                                    for (byte[] value : values = rawIndexReader.getBytesMV(docId, readerContext)) {
                                        if (min == null || ByteArray.compare((byte[])value, (byte[])min) > 0) {
                                            min = value;
                                        }
                                        if (max != null && ByteArray.compare((byte[])value, (byte[])max) >= 0) continue;
                                        max = value;
                                    }
                                }
                            }
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, BytesUtils.toHexString(min), BytesUtils.toHexString(max), storedType);
                            ** break;
lbl189:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported data type: " + dataType + " for column: " + columnName);
                        }
                    }
                }
                finally {
                    if (readerContext != null) {
                        readerContext.close();
                    }
                }
            }
            finally {
                if (rawIndexReader != null) {
                    rawIndexReader.close();
                }
            }
        }
        this._minMaxValueAdded = true;
    }
}

