/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.inverted;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeInvertedIndex;
import org.apache.pinot.segment.local.segment.creator.impl.inv.OffHeapBitmapInvertedIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.OnHeapBitmapInvertedIndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.ConfigurableFromIndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.InvertedIndexHandler;
import org.apache.pinot.segment.local.segment.index.readers.BitmapInvertedIndexReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.AbstractIndexType;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexReaderConstraintException;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.creator.DictionaryBasedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.mutable.MutableIndex;
import org.apache.pinot.segment.spi.index.mutable.provider.MutableIndexContext;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.index.reader.SortedIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public class InvertedIndexType
extends AbstractIndexType<IndexConfig, InvertedIndexReader, DictionaryBasedInvertedIndexCreator>
implements ConfigurableFromIndexLoadingConfig<IndexConfig> {
    public static final String INDEX_DISPLAY_NAME = "inverted";
    private static final List<String> EXTENSIONS = Collections.singletonList(".bitmap.inv");

    protected InvertedIndexType() {
        super("inverted_index");
    }

    public Class<IndexConfig> getIndexConfigClass() {
        return IndexConfig.class;
    }

    @Override
    public Map<String, IndexConfig> fromIndexLoadingConfig(IndexLoadingConfig indexLoadingConfig) {
        return indexLoadingConfig.getInvertedIndexColumns().stream().collect(Collectors.toMap(Function.identity(), v -> IndexConfig.ENABLED));
    }

    public IndexConfig getDefaultConfig() {
        return IndexConfig.DISABLED;
    }

    public String getPrettyName() {
        return INDEX_DISPLAY_NAME;
    }

    public ColumnConfigDeserializer<IndexConfig> createDeserializer() {
        ColumnConfigDeserializer fromInvertedCols = IndexConfigDeserializer.fromCollection(tableConfig -> tableConfig.getIndexingConfig().getInvertedIndexColumns(), (acum, column) -> acum.put(column, IndexConfig.ENABLED));
        return IndexConfigDeserializer.fromIndexes((String)this.getPrettyName(), this.getIndexConfigClass()).withExclusiveAlternative(IndexConfigDeserializer.ifIndexingConfig((ColumnConfigDeserializer)fromInvertedCols));
    }

    public DictionaryBasedInvertedIndexCreator createIndexCreator(IndexCreationContext context) throws IOException {
        if (context.isOnHeap()) {
            return new OnHeapBitmapInvertedIndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), context.getCardinality());
        }
        return new OffHeapBitmapInvertedIndexCreator(context.getIndexDir(), context.getFieldSpec(), context.getCardinality(), context.getTotalDocs(), context.getTotalNumberOfEntries());
    }

    public DictionaryBasedInvertedIndexCreator createIndexCreator(IndexCreationContext context, IndexConfig indexConfig) throws IOException {
        return this.createIndexCreator(context);
    }

    protected IndexReaderFactory<InvertedIndexReader> createReaderFactory() {
        return ReaderFactory.INSTANCE;
    }

    @Nullable
    public InvertedIndexReader getIndexReader(ColumnIndexContainer indexContainer) {
        InvertedIndexReader reader = (InvertedIndexReader)super.getIndexReader(indexContainer);
        if (reader != null) {
            return reader;
        }
        ForwardIndexReader fwdReader = (ForwardIndexReader)indexContainer.getIndex(StandardIndexes.forward());
        return fwdReader instanceof SortedIndexReader ? (SortedIndexReader)fwdReader : null;
    }

    public List<String> getFileExtensions(@Nullable ColumnMetadata columnMetadata) {
        return EXTENSIONS;
    }

    public IndexHandler createIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> configsByCol, @Nullable Schema schema, @Nullable TableConfig tableConfig) {
        return new InvertedIndexHandler(segmentDirectory, configsByCol, tableConfig);
    }

    protected void handleIndexSpecificCleanup(TableConfig tableConfig) {
        tableConfig.getIndexingConfig().setInvertedIndexColumns(null);
    }

    @Nullable
    public MutableIndex createMutableIndex(MutableIndexContext context, IndexConfig config) {
        if (config.isDisabled()) {
            return null;
        }
        if (!context.hasDictionary()) {
            return null;
        }
        return new RealtimeInvertedIndex();
    }

    public static class ReaderFactory
    implements IndexReaderFactory<InvertedIndexReader> {
        public static final ReaderFactory INSTANCE = new ReaderFactory();

        private ReaderFactory() {
        }

        public InvertedIndexReader createIndexReader(SegmentDirectory.Reader segmentReader, FieldIndexConfigs fieldIndexConfigs, ColumnMetadata metadata) throws IOException, IndexReaderConstraintException {
            if (!segmentReader.hasIndexFor(metadata.getColumnName(), StandardIndexes.inverted())) {
                return null;
            }
            if (!metadata.hasDictionary()) {
                throw new IllegalStateException("Column " + metadata.getColumnName() + " cannot be indexed by an inverted index if it has no dictionary");
            }
            if (metadata.isSorted() && metadata.isSingleValue()) {
                ForwardIndexReader fwdReader = (ForwardIndexReader)StandardIndexes.forward().getReaderFactory().createIndexReader(segmentReader, fieldIndexConfigs, metadata);
                Preconditions.checkState((boolean)(fwdReader instanceof SortedIndexReader));
                return (SortedIndexReader)fwdReader;
            }
            return this.createSkippingForward(segmentReader, metadata);
        }

        public InvertedIndexReader createSkippingForward(SegmentDirectory.Reader segmentReader, ColumnMetadata metadata) throws IOException {
            if (!metadata.hasDictionary()) {
                throw new IllegalStateException("Column " + metadata.getColumnName() + " cannot be indexed by an inverted index if it has no dictionary");
            }
            PinotDataBuffer dataBuffer = segmentReader.getIndexFor(metadata.getColumnName(), StandardIndexes.inverted());
            return new BitmapInvertedIndexReader(dataBuffer, metadata.getCardinality());
        }
    }
}

