/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.fst;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.creator.impl.inv.text.LuceneFSTIndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.ConfigurableFromIndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.FSTIndexHandler;
import org.apache.pinot.segment.local.segment.index.readers.LuceneFSTIndexReader;
import org.apache.pinot.segment.local.utils.nativefst.NativeFSTIndexCreator;
import org.apache.pinot.segment.local.utils.nativefst.NativeFSTIndexReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.AbstractIndexType;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FstIndexConfig;
import org.apache.pinot.segment.spi.index.IndexConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexReaderConstraintException;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.FSTIndexCreator;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.FSTType;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class FstIndexType
extends AbstractIndexType<FstIndexConfig, TextIndexReader, FSTIndexCreator>
implements ConfigurableFromIndexLoadingConfig<FstIndexConfig> {
    public static final String INDEX_DISPLAY_NAME = "fst";
    private static final List<String> EXTENSIONS = ImmutableList.of((Object)".lucene.fst", (Object)".lucene.v9.fst");

    protected FstIndexType() {
        super("fst_index");
    }

    public Class<FstIndexConfig> getIndexConfigClass() {
        return FstIndexConfig.class;
    }

    @Override
    public Map<String, FstIndexConfig> fromIndexLoadingConfig(IndexLoadingConfig indexLoadingConfig) {
        HashMap<String, FstIndexConfig> result = new HashMap<String, FstIndexConfig>();
        Set<String> fstIndexColumns = indexLoadingConfig.getFSTIndexColumns();
        for (String column : indexLoadingConfig.getAllKnownColumns()) {
            if (fstIndexColumns.contains(column)) {
                FSTType fstType = this.getFstTypeFromIndexLoadingConfig(indexLoadingConfig, column);
                FstIndexConfig conf = new FstIndexConfig(fstType);
                result.put(column, conf);
                continue;
            }
            result.put(column, FstIndexConfig.DISABLED);
        }
        return result;
    }

    private FSTType getFstTypeFromIndexLoadingConfig(IndexLoadingConfig indexLoadingConfig, String column) {
        Map textProperties;
        FieldConfig fieldConfig;
        List fieldConfigList;
        FSTType fstType = indexLoadingConfig.getFSTIndexType();
        TableConfig tableConfig = indexLoadingConfig.getTableConfig();
        if (tableConfig != null && (fieldConfigList = tableConfig.getFieldConfigList()) != null && (fieldConfig = (FieldConfig)fieldConfigList.stream().filter(fc -> fc.getName().equals(column)).findAny().orElse(null)) != null && (textProperties = fieldConfig.getProperties()) != null) {
            for (Map.Entry entry : textProperties.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("fstType")) {
                    fstType = FSTType.NATIVE;
                    continue;
                }
                fstType = FSTType.LUCENE;
            }
        }
        return fstType;
    }

    public FstIndexConfig getDefaultConfig() {
        return FstIndexConfig.DISABLED;
    }

    public String getPrettyName() {
        return INDEX_DISPLAY_NAME;
    }

    public ColumnConfigDeserializer<FstIndexConfig> createDeserializer() {
        return IndexConfigDeserializer.fromIndexes((String)this.getPrettyName(), this.getIndexConfigClass()).withExclusiveAlternative(IndexConfigDeserializer.fromIndexTypes((FieldConfig.IndexType)FieldConfig.IndexType.FST, (tableConfig, fieldConfig) -> {
            IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
            FSTType fstIndexType = indexingConfig != null ? indexingConfig.getFSTIndexType() : null;
            return new FstIndexConfig(fstIndexType);
        }));
    }

    public FSTIndexCreator createIndexCreator(IndexCreationContext context, FstIndexConfig indexConfig) throws IOException {
        Preconditions.checkState((boolean)context.getFieldSpec().isSingleValueField(), (Object)"FST index is currently only supported on single-value columns");
        Preconditions.checkState((context.getFieldSpec().getDataType().getStoredType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"FST index is currently only supported on STRING type columns");
        Preconditions.checkState((boolean)context.hasDictionary(), (Object)"FST index is currently only supported on dictionary-encoded columns");
        if (indexConfig.getFstType() == FSTType.NATIVE) {
            return new NativeFSTIndexCreator(context);
        }
        return new LuceneFSTIndexCreator(context);
    }

    protected IndexReaderFactory<TextIndexReader> createReaderFactory() {
        return ReaderFactory.INSTANCE;
    }

    public static TextIndexReader read(PinotDataBuffer dataBuffer, ColumnMetadata metadata) throws IndexReaderConstraintException, IOException {
        return ReaderFactory.INSTANCE.createIndexReader(dataBuffer, metadata);
    }

    public IndexHandler createIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> configsByCol, @Nullable Schema schema, @Nullable TableConfig tableConfig) {
        return new FSTIndexHandler(segmentDirectory, configsByCol, tableConfig);
    }

    public List<String> getFileExtensions(@Nullable ColumnMetadata columnMetadata) {
        return EXTENSIONS;
    }

    protected void handleIndexSpecificCleanup(TableConfig tableConfig) {
        tableConfig.getIndexingConfig().setFSTIndexType(null);
    }

    private static class ReaderFactory
    extends IndexReaderFactory.Default<FstIndexConfig, TextIndexReader> {
        public static final ReaderFactory INSTANCE = new ReaderFactory();

        private ReaderFactory() {
        }

        protected IndexType<FstIndexConfig, TextIndexReader, ?> getIndexType() {
            return StandardIndexes.fst();
        }

        protected TextIndexReader createIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata) throws IndexReaderConstraintException, IOException {
            if (!metadata.hasDictionary()) {
                throw new IndexReaderConstraintException(metadata.getColumnName(), StandardIndexes.fst(), "This index requires a dictionary");
            }
            int magicHeader = dataBuffer.getInt(0);
            if (magicHeader == 1550218081) {
                return new NativeFSTIndexReader(dataBuffer);
            }
            return new LuceneFSTIndexReader(dataBuffer);
        }

        protected TextIndexReader createIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata, FstIndexConfig indexConfig) throws IndexReaderConstraintException, IOException {
            return this.createIndexReader(dataBuffer, metadata);
        }
    }
}

