/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.forward;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.realtime.impl.forward.FixedByteMVMutableForwardIndex;
import org.apache.pinot.segment.local.realtime.impl.forward.FixedByteSVMutableForwardIndex;
import org.apache.pinot.segment.local.realtime.impl.forward.VarByteSVMutableForwardIndex;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexCreatorFactory;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexReaderFactory;
import org.apache.pinot.segment.local.segment.index.loader.ConfigurableFromIndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.ForwardIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.AbstractIndexType;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.ForwardIndexConfig;
import org.apache.pinot.segment.spi.index.IndexConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexReaderConstraintException;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.IndexUtil;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.segment.spi.index.mutable.MutableIndex;
import org.apache.pinot.segment.spi.index.mutable.provider.MutableIndexContext;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class ForwardIndexType
extends AbstractIndexType<ForwardIndexConfig, ForwardIndexReader, ForwardIndexCreator>
implements ConfigurableFromIndexLoadingConfig<ForwardIndexConfig> {
    public static final String INDEX_DISPLAY_NAME = "forward";
    private static final int MAX_MULTI_VALUES_PER_ROW = 1000;
    private static final int NODICT_VARIABLE_WIDTH_ESTIMATED_AVERAGE_VALUE_LENGTH_DEFAULT = 100;
    private static final int NODICT_VARIABLE_WIDTH_ESTIMATED_NUMBER_OF_VALUES_DEFAULT = 100000;
    private static final List<String> EXTENSIONS = Lists.newArrayList((Object[])new String[]{".sv.raw.fwd", ".sv.sorted.fwd", ".sv.unsorted.fwd", ".mv.raw.fwd", ".mv.fwd"});

    protected ForwardIndexType() {
        super("forward_index");
    }

    public Class<ForwardIndexConfig> getIndexConfigClass() {
        return ForwardIndexConfig.class;
    }

    @Override
    public Map<String, ForwardIndexConfig> fromIndexLoadingConfig(IndexLoadingConfig indexLoadingConfig) {
        Set<String> disabledColumns = indexLoadingConfig.getForwardIndexDisabledColumns();
        Map<String, FieldConfig.CompressionCodec> compressionCodecMap = indexLoadingConfig.getCompressionConfigs();
        HashMap<String, ForwardIndexConfig> result = new HashMap<String, ForwardIndexConfig>();
        for (String column : indexLoadingConfig.getAllKnownColumns()) {
            ForwardIndexConfig forwardIndexConfig;
            if (!disabledColumns.contains(column)) {
                FieldConfig fieldConfig;
                TableConfig tableConfig;
                FieldConfig.CompressionCodec compressionCodec = compressionCodecMap.get(column);
                if (compressionCodec == null && (tableConfig = indexLoadingConfig.getTableConfig()) != null && tableConfig.getFieldConfigList() != null && (fieldConfig = (FieldConfig)tableConfig.getFieldConfigList().stream().filter(fc -> fc.getName().equals(column)).findAny().orElse(null)) != null) {
                    compressionCodec = fieldConfig.getCompressionCodec();
                }
                forwardIndexConfig = new ForwardIndexConfig.Builder().withCompressionCodec(compressionCodec).build();
            } else {
                forwardIndexConfig = ForwardIndexConfig.DISABLED;
            }
            result.put(column, forwardIndexConfig);
        }
        return result;
    }

    public ForwardIndexConfig getDefaultConfig() {
        return ForwardIndexConfig.DEFAULT;
    }

    public String getPrettyName() {
        return INDEX_DISPLAY_NAME;
    }

    public ColumnConfigDeserializer<ForwardIndexConfig> createDeserializer() {
        ColumnConfigDeserializer fromOld = (tableConfig, schema) -> {
            Map dictConfigs = StandardIndexes.dictionary().getConfig(tableConfig, schema);
            HashMap fwdConfig = Maps.newHashMapWithExpectedSize((int)Math.max(dictConfigs.size(), schema.size()));
            List fieldConfigs = tableConfig.getFieldConfigList();
            if (fieldConfigs != null) {
                for (FieldConfig fieldConfig : fieldConfigs) {
                    Map properties = fieldConfig.getProperties();
                    if (properties != null && this.isDisabled(properties)) {
                        fwdConfig.put(fieldConfig.getName(), ForwardIndexConfig.DISABLED);
                        continue;
                    }
                    ForwardIndexConfig config = this.createConfigFromFieldConfig(fieldConfig);
                    if (config.equals((Object)ForwardIndexConfig.DEFAULT)) continue;
                    fwdConfig.put(fieldConfig.getName(), config);
                }
            }
            return fwdConfig;
        };
        return IndexConfigDeserializer.fromIndexes((String)this.getPrettyName(), this.getIndexConfigClass()).withExclusiveAlternative(fromOld);
    }

    private boolean isDisabled(Map<String, String> props) {
        return Boolean.parseBoolean(props.getOrDefault("forwardIndexDisabled", FieldConfig.DEFAULT_FORWARD_INDEX_DISABLED));
    }

    private ForwardIndexConfig createConfigFromFieldConfig(FieldConfig fieldConfig) {
        ForwardIndexConfig.Builder builder = new ForwardIndexConfig.Builder();
        builder.withCompressionCodec(fieldConfig.getCompressionCodec());
        Map properties = fieldConfig.getProperties();
        if (properties != null) {
            builder.withLegacyProperties(properties);
        }
        return builder.build();
    }

    public static ChunkCompressionType getDefaultCompressionType(FieldSpec.FieldType fieldType) {
        if (fieldType == FieldSpec.FieldType.METRIC) {
            return ChunkCompressionType.PASS_THROUGH;
        }
        return ChunkCompressionType.LZ4;
    }

    public ForwardIndexCreator createIndexCreator(IndexCreationContext context, ForwardIndexConfig indexConfig) throws Exception {
        return ForwardIndexCreatorFactory.createIndexCreator(context, indexConfig);
    }

    public IndexHandler createIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> configsByCol, @Nullable Schema schema, @Nullable TableConfig tableConfig) {
        return new ForwardIndexHandler(segmentDirectory, configsByCol, schema, tableConfig);
    }

    protected IndexReaderFactory<ForwardIndexReader> createReaderFactory() {
        return ForwardIndexReaderFactory.getInstance();
    }

    public String getFileExtension(ColumnMetadata columnMetadata) {
        if (columnMetadata.isSingleValue()) {
            if (!columnMetadata.hasDictionary()) {
                return ".sv.raw.fwd";
            }
            if (columnMetadata.isSorted()) {
                return ".sv.sorted.fwd";
            }
            return ".sv.unsorted.fwd";
        }
        if (!columnMetadata.hasDictionary()) {
            return ".mv.raw.fwd";
        }
        return ".mv.fwd";
    }

    public List<String> getFileExtensions(@Nullable ColumnMetadata columnMetadata) {
        if (columnMetadata == null) {
            return EXTENSIONS;
        }
        return Collections.singletonList(this.getFileExtension(columnMetadata));
    }

    public static ForwardIndexReader<?> read(SegmentDirectory.Reader segmentReader, ColumnMetadata columnMetadata) throws IOException {
        PinotDataBuffer dataBuffer = segmentReader.getIndexFor(columnMetadata.getColumnName(), StandardIndexes.forward());
        return ForwardIndexType.read(dataBuffer, columnMetadata);
    }

    public static ForwardIndexReader read(PinotDataBuffer dataBuffer, ColumnMetadata metadata) {
        return ForwardIndexReaderFactory.createIndexReader(dataBuffer, metadata);
    }

    public static ForwardIndexReader<?> read(SegmentDirectory.Reader segmentReader, FieldIndexConfigs fieldIndexConfigs, ColumnMetadata metadata) throws IndexReaderConstraintException, IOException {
        return (ForwardIndexReader)StandardIndexes.forward().getReaderFactory().createIndexReader(segmentReader, fieldIndexConfigs, metadata);
    }

    @Nullable
    public MutableIndex createMutableIndex(MutableIndexContext context, ForwardIndexConfig config) {
        if (config.isDisabled()) {
            return null;
        }
        String column = context.getFieldSpec().getName();
        String segmentName = context.getSegmentName();
        FieldSpec.DataType storedType = context.getFieldSpec().getDataType().getStoredType();
        int fixedLengthBytes = context.getFixedLengthBytes();
        boolean isSingleValue = context.getFieldSpec().isSingleValueField();
        if (!context.hasDictionary()) {
            if (isSingleValue) {
                String allocationContext = IndexUtil.buildAllocationContext((String)context.getSegmentName(), (String)context.getFieldSpec().getName(), (String)".sv.raw.fwd");
                if (storedType.isFixedWidth() || fixedLengthBytes > 0) {
                    return new FixedByteSVMutableForwardIndex(false, storedType, fixedLengthBytes, context.getCapacity(), context.getMemoryManager(), allocationContext);
                }
                int initialCapacity = Math.min(context.getCapacity(), 100000);
                return new VarByteSVMutableForwardIndex(storedType, context.getMemoryManager(), allocationContext, initialCapacity, 100);
            }
            assert (storedType.isFixedWidth());
            String allocationContext = IndexUtil.buildAllocationContext((String)context.getSegmentName(), (String)context.getFieldSpec().getName(), (String)".mv.raw.fwd");
            return new FixedByteMVMutableForwardIndex(1000, context.getAvgNumMultiValues(), context.getCapacity(), storedType.size(), context.getMemoryManager(), allocationContext, false, storedType);
        }
        if (isSingleValue) {
            String allocationContext = IndexUtil.buildAllocationContext((String)segmentName, (String)column, (String)".sv.unsorted.fwd");
            return new FixedByteSVMutableForwardIndex(true, FieldSpec.DataType.INT, context.getCapacity(), context.getMemoryManager(), allocationContext);
        }
        String allocationContext = IndexUtil.buildAllocationContext((String)segmentName, (String)column, (String)".mv.fwd");
        return new FixedByteMVMutableForwardIndex(1000, context.getAvgNumMultiValues(), context.getCapacity(), 4, context.getMemoryManager(), allocationContext, true, FieldSpec.DataType.INT);
    }
}

