/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.forward;

import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBitMVEntryDictForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBitMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBitSVForwardIndexReaderV2;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedByteChunkMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedByteChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBytePower2ChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkForwardIndexReaderV4;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.sorted.SortedIndexReaderImpl;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.ForwardIndexConfig;
import org.apache.pinot.segment.spi.index.IndexReaderConstraintException;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class ForwardIndexReaderFactory
extends IndexReaderFactory.Default<ForwardIndexConfig, ForwardIndexReader> {
    private static volatile ForwardIndexReaderFactory _instance = new ForwardIndexReaderFactory();

    public static void setInstance(ForwardIndexReaderFactory factory) {
        _instance = factory;
    }

    public static ForwardIndexReaderFactory getInstance() {
        return _instance;
    }

    protected IndexType<ForwardIndexConfig, ForwardIndexReader, ?> getIndexType() {
        return StandardIndexes.forward();
    }

    protected ForwardIndexReader createIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata, ForwardIndexConfig indexConfig) throws IndexReaderConstraintException {
        return ForwardIndexReaderFactory.createIndexReader(dataBuffer, metadata);
    }

    public static ForwardIndexReader createIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata) {
        if (metadata.hasDictionary()) {
            if (metadata.isSingleValue()) {
                if (metadata.isSorted()) {
                    return new SortedIndexReaderImpl(dataBuffer, metadata.getCardinality());
                }
                return new FixedBitSVForwardIndexReaderV2(dataBuffer, metadata.getTotalDocs(), metadata.getBitsPerElement());
            }
            if (dataBuffer.size() > 4L && dataBuffer.getInt(0) == -5517841) {
                return new FixedBitMVEntryDictForwardIndexReader(dataBuffer, metadata.getTotalDocs(), metadata.getBitsPerElement());
            }
            return new FixedBitMVForwardIndexReader(dataBuffer, metadata.getTotalDocs(), metadata.getTotalNumberOfEntries(), metadata.getBitsPerElement());
        }
        return ForwardIndexReaderFactory.createRawIndexReader(dataBuffer, metadata.getDataType().getStoredType(), metadata.isSingleValue());
    }

    public static ForwardIndexReader createRawIndexReader(PinotDataBuffer dataBuffer, FieldSpec.DataType storedType, boolean isSingleValue) {
        int version = dataBuffer.getInt(0);
        if (isSingleValue && storedType.isFixedWidth()) {
            return version == 4 ? new FixedBytePower2ChunkSVForwardIndexReader(dataBuffer, storedType) : new FixedByteChunkSVForwardIndexReader(dataBuffer, storedType);
        }
        if (version == 4) {
            return new VarByteChunkForwardIndexReaderV4(dataBuffer, storedType, isSingleValue);
        }
        return ForwardIndexReaderFactory.createNonV4RawIndexReader(dataBuffer, storedType, isSingleValue);
    }

    private static ForwardIndexReader createNonV4RawIndexReader(PinotDataBuffer dataBuffer, FieldSpec.DataType storedType, boolean isSingleValue) {
        if (isSingleValue) {
            return new VarByteChunkSVForwardIndexReader(dataBuffer, storedType);
        }
        if (storedType.isFixedWidth()) {
            return new FixedByteChunkMVForwardIndexReader(dataBuffer, storedType);
        }
        return new VarByteChunkMVForwardIndexReader(dataBuffer, storedType);
    }
}

