/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.forward;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueEntryDictForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueFixedByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueUnsortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueVarByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueFixedByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueSortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueUnsortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueVarByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexType;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.DictIdCompressionType;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.ForwardIndexConfig;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class ForwardIndexCreatorFactory {
    private ForwardIndexCreatorFactory() {
    }

    public static ForwardIndexCreator createIndexCreator(IndexCreationContext context, ForwardIndexConfig indexConfig) throws Exception {
        File indexDir = context.getIndexDir();
        FieldSpec fieldSpec = context.getFieldSpec();
        String columnName = fieldSpec.getName();
        int numTotalDocs = context.getTotalDocs();
        if (context.hasDictionary()) {
            int cardinality = context.getCardinality();
            if (fieldSpec.isSingleValueField()) {
                if (context.isSorted()) {
                    return new SingleValueSortedForwardIndexCreator(indexDir, columnName, cardinality);
                }
                return new SingleValueUnsortedForwardIndexCreator(indexDir, columnName, cardinality, numTotalDocs);
            }
            if (indexConfig.getDictIdCompressionType() == DictIdCompressionType.MV_ENTRY_DICT) {
                return new MultiValueEntryDictForwardIndexCreator(indexDir, columnName, cardinality, numTotalDocs);
            }
            return new MultiValueUnsortedForwardIndexCreator(indexDir, columnName, cardinality, numTotalDocs, context.getTotalNumberOfEntries());
        }
        FieldSpec.DataType storedType = fieldSpec.getDataType().getStoredType();
        ChunkCompressionType chunkCompressionType = indexConfig.getChunkCompressionType();
        if (chunkCompressionType == null) {
            chunkCompressionType = ForwardIndexType.getDefaultCompressionType(fieldSpec.getFieldType());
        }
        boolean deriveNumDocsPerChunk = indexConfig.isDeriveNumDocsPerChunk();
        int writerVersion = indexConfig.getRawIndexWriterVersion();
        if (fieldSpec.isSingleValueField()) {
            return ForwardIndexCreatorFactory.getRawIndexCreatorForSVColumn(indexDir, chunkCompressionType, columnName, storedType, numTotalDocs, context.getLengthOfLongestEntry(), deriveNumDocsPerChunk, writerVersion);
        }
        return ForwardIndexCreatorFactory.getRawIndexCreatorForMVColumn(indexDir, chunkCompressionType, columnName, storedType, numTotalDocs, context.getMaxNumberOfMultiValueElements(), deriveNumDocsPerChunk, writerVersion, context.getMaxRowLengthInBytes());
    }

    public static ForwardIndexCreator getRawIndexCreatorForSVColumn(File indexDir, ChunkCompressionType compressionType, String column, FieldSpec.DataType storedType, int numTotalDocs, int lengthOfLongestEntry, boolean deriveNumDocsPerChunk, int writerVersion) throws IOException {
        switch (storedType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new SingleValueFixedByteRawIndexCreator(indexDir, compressionType, column, numTotalDocs, storedType, writerVersion);
            }
            case BIG_DECIMAL: 
            case STRING: 
            case BYTES: {
                return new SingleValueVarByteRawIndexCreator(indexDir, compressionType, column, numTotalDocs, storedType, lengthOfLongestEntry, deriveNumDocsPerChunk, writerVersion);
            }
        }
        throw new IllegalStateException("Unsupported stored type: " + storedType);
    }

    public static ForwardIndexCreator getRawIndexCreatorForMVColumn(File indexDir, ChunkCompressionType compressionType, String column, FieldSpec.DataType storedType, int numTotalDocs, int maxNumberOfMultiValueElements, boolean deriveNumDocsPerChunk, int writerVersion, int maxRowLengthInBytes) throws IOException {
        switch (storedType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new MultiValueFixedByteRawIndexCreator(indexDir, compressionType, column, numTotalDocs, storedType, maxNumberOfMultiValueElements, deriveNumDocsPerChunk, writerVersion);
            }
            case STRING: 
            case BYTES: {
                return new MultiValueVarByteRawIndexCreator(indexDir, compressionType, column, numTotalDocs, storedType, writerVersion, maxRowLengthInBytes, maxNumberOfMultiValueElements);
            }
        }
        throw new IllegalStateException("Unsupported stored type: " + storedType);
    }
}

