/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.vector.lucene95;

import java.io.IOException;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene95.Lucene95HnswVectorsFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public final class HnswVectorsFormat
extends KnnVectorsFormat {
    public static final int DEFAULT_MAX_DIMENSIONS = 2048;
    private final int _maxDimensions;
    private final Lucene95HnswVectorsFormat _delegate;

    public HnswVectorsFormat(int maxConn, int beamWidth, int maxDimensions) {
        super("Lucene95HnswVectorsFormat");
        if (maxDimensions <= 0 || maxDimensions > 2048) {
            throw new IllegalArgumentException("maxDimensions must be postive and less than or equal to2048; maxDimensions=" + maxDimensions);
        }
        this._delegate = new Lucene95HnswVectorsFormat(maxConn, beamWidth);
        this._maxDimensions = maxDimensions;
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return this._delegate.fieldsWriter(state);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return this._delegate.fieldsReader(state);
    }

    public int getMaxDimensions(String fieldName) {
        return this._maxDimensions;
    }

    public String toString() {
        return "HnswVectorsFormat(name=HnswVectorsFormat, maxDimensions=" + this._maxDimensions + ", delegate=" + this._delegate + ")";
    }
}

