/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.inv.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.fst.FST;
import org.apache.pinot.segment.local.utils.fst.FSTBuilder;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.creator.FSTIndexCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneFSTIndexCreator
implements FSTIndexCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneFSTIndexCreator.class);
    private final File _fstIndexFile;
    private final FSTBuilder _fstBuilder;
    Integer _dictId;

    public LuceneFSTIndexCreator(File indexDir, String columnName, String[] sortedEntries) throws IOException {
        this._fstIndexFile = new File(indexDir, columnName + ".lucene.v9.fst");
        this._fstBuilder = new FSTBuilder();
        this._dictId = 0;
        if (sortedEntries != null) {
            this._dictId = 0;
            while (this._dictId < sortedEntries.length) {
                this._fstBuilder.addEntry(sortedEntries[this._dictId], this._dictId);
                Integer n = this._dictId;
                Integer n2 = this._dictId = Integer.valueOf(this._dictId + 1);
            }
        }
    }

    public LuceneFSTIndexCreator(IndexCreationContext context) throws IOException {
        this(context.getIndexDir(), context.getFieldSpec().getName(), (String[])context.getSortedUniqueElementsArray());
    }

    public void add(String document) {
        try {
            this._fstBuilder.addEntry(document, this._dictId);
            Integer n = this._dictId;
            Integer n2 = this._dictId = Integer.valueOf(this._dictId + 1);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to load the schema file", ex);
        }
    }

    public void add(String[] documents, int length) {
        throw new UnsupportedOperationException("Multiple values not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seal() throws IOException {
        LOGGER.info("Sealing FST index: " + this._fstIndexFile.getAbsolutePath());
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(this._fstIndexFile);
            FST<Long> fst = this._fstBuilder.done();
            OutputStreamDataOutput d = new OutputStreamDataOutput((OutputStream)fileOutputStream);
            fst.save((DataOutput)d, (DataOutput)d);
        }
    }

    public void close() throws IOException {
    }
}

