/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.fwd;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.segment.local.io.writer.impl.FixedByteChunkForwardIndexWriter;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class SingleValueFixedByteRawIndexCreator
implements ForwardIndexCreator {
    private static final int NUM_DOCS_PER_CHUNK = 1000;
    private final FixedByteChunkForwardIndexWriter _indexWriter;
    private final FieldSpec.DataType _valueType;

    public SingleValueFixedByteRawIndexCreator(File baseIndexDir, ChunkCompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType) throws IOException {
        this(baseIndexDir, compressionType, column, totalDocs, valueType, 2);
    }

    public SingleValueFixedByteRawIndexCreator(File baseIndexDir, ChunkCompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int writerVersion) throws IOException {
        File file = new File(baseIndexDir, column + ".sv.raw.fwd");
        this._indexWriter = new FixedByteChunkForwardIndexWriter(file, compressionType, totalDocs, 1000, valueType.size(), writerVersion);
        this._valueType = valueType;
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getValueType() {
        return this._valueType;
    }

    public void putInt(int value) {
        this._indexWriter.putInt(value);
    }

    public void putLong(long value) {
        this._indexWriter.putLong(value);
    }

    public void putFloat(float value) {
        this._indexWriter.putFloat(value);
    }

    public void putDouble(double value) {
        this._indexWriter.putDouble(value);
    }

    public void close() throws IOException {
        this._indexWriter.close();
    }
}

