/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.recordtransformer.ExtraFieldsContainer;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.SchemaConformingTransformerConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.stream.StreamDataDecoderImpl;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaConformingTransformer
implements RecordTransformer {
    private static final Logger _logger = LoggerFactory.getLogger(SchemaConformingTransformer.class);
    private final boolean _continueOnError;
    private final SchemaConformingTransformerConfig _transformerConfig;
    private final FieldSpec.DataType _indexableExtrasFieldType;
    private final FieldSpec.DataType _unindexableExtrasFieldType;
    private Map<String, Object> _schemaTree;

    public static void validateSchema(@Nonnull Schema schema, @Nonnull SchemaConformingTransformerConfig transformerConfig) {
        SchemaConformingTransformer.validateSchemaFieldNames(schema.getPhysicalColumnNames(), transformerConfig);
        String indexableExtrasFieldName = transformerConfig.getIndexableExtrasField();
        SchemaConformingTransformer.getAndValidateExtrasFieldType(schema, indexableExtrasFieldName);
        String unindexableExtrasFieldName = transformerConfig.getUnindexableExtrasField();
        if (null != unindexableExtrasFieldName) {
            SchemaConformingTransformer.getAndValidateExtrasFieldType(schema, indexableExtrasFieldName);
        }
        SchemaConformingTransformer.validateSchemaAndCreateTree(schema);
    }

    private static void validateSchemaFieldNames(Set<String> schemaFields, SchemaConformingTransformerConfig transformerConfig) {
        Set fieldPathsToDrop;
        String unindexableFieldSuffix = transformerConfig.getUnindexableFieldSuffix();
        if (null != unindexableFieldSuffix) {
            for (String field : schemaFields) {
                Preconditions.checkState((!field.endsWith(unindexableFieldSuffix) ? 1 : 0) != 0, (String)"Field '%s' has no-index suffix '%s'", (Object)field, (Object)unindexableFieldSuffix);
            }
        }
        if (null != (fieldPathsToDrop = transformerConfig.getFieldPathsToDrop())) {
            HashSet<String> fieldIntersection = new HashSet<String>(schemaFields);
            fieldIntersection.retainAll(fieldPathsToDrop);
            Preconditions.checkState((boolean)fieldIntersection.isEmpty(), (Object)"Fields in schema overlap with fieldPathsToDrop");
        }
    }

    private static FieldSpec.DataType getAndValidateExtrasFieldType(Schema schema, @Nonnull String extrasFieldName) {
        FieldSpec fieldSpec = schema.getFieldSpecFor(extrasFieldName);
        Preconditions.checkState((null != fieldSpec ? 1 : 0) != 0, (String)"Field '%s' doesn't exist in schema", (Object)extrasFieldName);
        FieldSpec.DataType fieldDataType = fieldSpec.getDataType();
        Preconditions.checkState((FieldSpec.DataType.JSON == fieldDataType || FieldSpec.DataType.STRING == fieldDataType ? 1 : 0) != 0, (String)"Field '%s' has unsupported type %s", (Object)fieldDataType.toString());
        return fieldDataType;
    }

    private static Map<String, Object> validateSchemaAndCreateTree(@Nonnull Schema schema) throws IllegalArgumentException {
        TreeSet schemaFields = schema.getPhysicalColumnNames();
        HashMap<String, Object> schemaTree = new HashMap<String, Object>();
        ArrayList<String> subKeys = new ArrayList<String>();
        for (String field : schemaFields) {
            int keySeparatorIdx = field.indexOf(".");
            if (-1 == keySeparatorIdx) {
                schemaTree.put(field, null);
                continue;
            }
            subKeys.clear();
            SchemaConformingTransformer.getAndValidateSubKeys(field, keySeparatorIdx, subKeys);
            Map<String, Object> currentNode = schemaTree;
            for (int i = 0; i < subKeys.size() - 1; ++i) {
                Map childNode;
                String subKey = (String)subKeys.get(i);
                if (currentNode.containsKey(subKey)) {
                    childNode = (Map)currentNode.get(subKey);
                    if (null == childNode) {
                        throw new IllegalArgumentException("Cannot handle field '" + String.join((CharSequence)".", subKeys.subList(0, i + 1)) + "' which overlaps with another field in the schema.");
                    }
                } else {
                    childNode = new HashMap();
                    currentNode.put(subKey, childNode);
                }
                currentNode = childNode;
            }
            String subKey = (String)subKeys.get(subKeys.size() - 1);
            if (currentNode.containsKey(subKey)) {
                throw new IllegalArgumentException("Cannot handle field '" + field + "' which overlaps with another field in the schema.");
            }
            currentNode.put(subKey, null);
        }
        return schemaTree;
    }

    private static void getAndValidateSubKeys(String key, int firstKeySeparatorIdx, List<String> subKeys) throws IllegalArgumentException {
        int subKeyBeginIdx = 0;
        int subKeyEndIdx = firstKeySeparatorIdx;
        int keyLength = key.length();
        while (true) {
            String subKey;
            if ((subKey = key.substring(subKeyBeginIdx, subKeyEndIdx)).isEmpty()) {
                throw new IllegalArgumentException("Unsupported empty sub-key in '" + key + "'.");
            }
            subKeys.add(subKey);
            subKeyBeginIdx = subKeyEndIdx + 1;
            if (subKeyBeginIdx >= keyLength) break;
            int keySeparatorIdx = key.indexOf(".", subKeyBeginIdx);
            if (-1 != keySeparatorIdx) {
                subKeyEndIdx = keySeparatorIdx;
                continue;
            }
            subKeyEndIdx = key.length();
        }
    }

    public SchemaConformingTransformer(TableConfig tableConfig, Schema schema) {
        if (null == tableConfig.getIngestionConfig() || null == tableConfig.getIngestionConfig().getSchemaConformingTransformerConfig()) {
            this._continueOnError = false;
            this._transformerConfig = null;
            this._indexableExtrasFieldType = null;
            this._unindexableExtrasFieldType = null;
            return;
        }
        this._continueOnError = tableConfig.getIngestionConfig().isContinueOnError();
        this._transformerConfig = tableConfig.getIngestionConfig().getSchemaConformingTransformerConfig();
        String indexableExtrasFieldName = this._transformerConfig.getIndexableExtrasField();
        this._indexableExtrasFieldType = SchemaConformingTransformer.getAndValidateExtrasFieldType(schema, indexableExtrasFieldName);
        String unindexableExtrasFieldName = this._transformerConfig.getUnindexableExtrasField();
        this._unindexableExtrasFieldType = null == unindexableExtrasFieldName ? null : SchemaConformingTransformer.getAndValidateExtrasFieldType(schema, unindexableExtrasFieldName);
        this._schemaTree = SchemaConformingTransformer.validateSchemaAndCreateTree(schema);
    }

    @Override
    public boolean isNoOp() {
        return null == this._transformerConfig;
    }

    @Override
    @Nullable
    public GenericRow transform(GenericRow record) {
        GenericRow outputRecord = new GenericRow();
        try {
            ExtraFieldsContainer extraFieldsContainer = new ExtraFieldsContainer(null != this._transformerConfig.getUnindexableExtrasField());
            for (Map.Entry recordEntry : record.getFieldToValueMap().entrySet()) {
                String recordKey = (String)recordEntry.getKey();
                Object recordValue = recordEntry.getValue();
                this.processField(this._schemaTree, recordKey, recordKey, recordValue, extraFieldsContainer, outputRecord);
            }
            this.putExtrasField(this._transformerConfig.getIndexableExtrasField(), this._indexableExtrasFieldType, extraFieldsContainer.getIndexableExtras(), outputRecord);
            this.putExtrasField(this._transformerConfig.getUnindexableExtrasField(), this._unindexableExtrasFieldType, extraFieldsContainer.getUnindexableExtras(), outputRecord);
        }
        catch (Exception e) {
            if (!this._continueOnError) {
                throw e;
            }
            _logger.debug("Couldn't transform record: {}", (Object)record.toString(), (Object)e);
            outputRecord.putValue("$INCOMPLETE_RECORD_KEY$", (Object)true);
        }
        return outputRecord;
    }

    private void processField(Map<String, Object> schemaNode, String keyJsonPath, String key, Object value, ExtraFieldsContainer extraFieldsContainer, GenericRow outputRecord) {
        boolean storeUnindexableExtras;
        if (StreamDataDecoderImpl.isSpecialKeyType((String)key) || GenericRow.isSpecialKeyType((String)key)) {
            outputRecord.putValue(key, value);
            return;
        }
        Set fieldPathsToDrop = this._transformerConfig.getFieldPathsToDrop();
        if (null != fieldPathsToDrop && fieldPathsToDrop.contains(keyJsonPath)) {
            return;
        }
        String unindexableFieldSuffix = this._transformerConfig.getUnindexableFieldSuffix();
        if (null != unindexableFieldSuffix && key.endsWith(unindexableFieldSuffix)) {
            extraFieldsContainer.addUnindexableEntry(key, value);
            return;
        }
        if (!schemaNode.containsKey(key)) {
            this.addIndexableField(keyJsonPath, key, value, extraFieldsContainer);
            return;
        }
        Map childSchemaNode = (Map)schemaNode.get(key);
        boolean bl = storeUnindexableExtras = this._transformerConfig.getUnindexableExtrasField() != null;
        if (null == childSchemaNode) {
            if (!(value instanceof Map) || null == unindexableFieldSuffix) {
                outputRecord.putValue(keyJsonPath, value);
            } else {
                ExtraFieldsContainer container = new ExtraFieldsContainer(storeUnindexableExtras);
                this.addIndexableField(keyJsonPath, key, value, container);
                Map<String, Object> indexableFields = container.getIndexableExtras();
                outputRecord.putValue(keyJsonPath, indexableFields.get(key));
                Map<String, Object> unindexableFields = container.getUnindexableExtras();
                if (null != unindexableFields) {
                    extraFieldsContainer.addUnindexableEntry(key, unindexableFields.get(key));
                }
            }
        } else if (!(value instanceof Map)) {
            _logger.debug("Record doesn't match schema: Schema node '{}' is a map but record value is a {}", (Object)keyJsonPath, (Object)value.getClass().getSimpleName());
            extraFieldsContainer.addIndexableEntry(key, value);
        } else {
            ExtraFieldsContainer childExtraFieldsContainer = new ExtraFieldsContainer(storeUnindexableExtras);
            Map valueAsMap = (Map)value;
            for (Map.Entry entry : valueAsMap.entrySet()) {
                String childKey = (String)entry.getKey();
                this.processField(childSchemaNode, keyJsonPath + "." + childKey, childKey, entry.getValue(), childExtraFieldsContainer, outputRecord);
            }
            extraFieldsContainer.addChild(key, childExtraFieldsContainer);
        }
    }

    void addIndexableField(String recordJsonPath, String key, Object value, ExtraFieldsContainer extraFieldsContainer) {
        boolean storeUnindexableExtras;
        Set fieldPathsToDrop = this._transformerConfig.getFieldPathsToDrop();
        if (null != fieldPathsToDrop && fieldPathsToDrop.contains(recordJsonPath)) {
            return;
        }
        String unindexableFieldSuffix = this._transformerConfig.getUnindexableFieldSuffix();
        if (null != unindexableFieldSuffix && key.endsWith(unindexableFieldSuffix)) {
            extraFieldsContainer.addUnindexableEntry(key, value);
            return;
        }
        boolean bl = storeUnindexableExtras = this._transformerConfig.getUnindexableExtrasField() != null;
        if (!(value instanceof Map)) {
            extraFieldsContainer.addIndexableEntry(key, value);
        } else {
            ExtraFieldsContainer childExtraFieldsContainer = new ExtraFieldsContainer(storeUnindexableExtras);
            Map valueAsMap = (Map)value;
            for (Map.Entry entry : valueAsMap.entrySet()) {
                String childKey = (String)entry.getKey();
                this.addIndexableField(recordJsonPath + "." + childKey, childKey, entry.getValue(), childExtraFieldsContainer);
            }
            extraFieldsContainer.addChild(key, childExtraFieldsContainer);
        }
    }

    private void putExtrasField(String fieldName, FieldSpec.DataType fieldType, Map<String, Object> field, GenericRow outputRecord) {
        if (null == field) {
            return;
        }
        switch (fieldType) {
            case JSON: {
                outputRecord.putValue(fieldName, field);
                break;
            }
            case STRING: {
                try {
                    outputRecord.putValue(fieldName, (Object)JsonUtils.objectToString(field));
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Failed to convert '" + fieldName + "' to string", e);
                }
            }
            default: {
                throw new UnsupportedOperationException("Cannot convert '" + fieldName + "' to " + fieldType.name());
            }
        }
    }
}

