/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import java.util.HashMap;
import java.util.Map;

class ExtraFieldsContainer {
    private Map<String, Object> _indexableExtras = null;
    private Map<String, Object> _unindexableExtras = null;
    private final boolean _storeUnindexableExtras;

    ExtraFieldsContainer(boolean storeUnindexableExtras) {
        this._storeUnindexableExtras = storeUnindexableExtras;
    }

    public Map<String, Object> getIndexableExtras() {
        return this._indexableExtras;
    }

    public Map<String, Object> getUnindexableExtras() {
        return this._unindexableExtras;
    }

    public void addIndexableEntry(String key, Object value) {
        if (null == this._indexableExtras) {
            this._indexableExtras = new HashMap<String, Object>();
        }
        this._indexableExtras.put(key, value);
    }

    public void addUnindexableEntry(String key, Object value) {
        if (!this._storeUnindexableExtras) {
            return;
        }
        if (null == this._unindexableExtras) {
            this._unindexableExtras = new HashMap<String, Object>();
        }
        this._unindexableExtras.put(key, value);
    }

    public void addChild(String key, ExtraFieldsContainer child) {
        Map<String, Object> childUnindexableFields;
        Map<String, Object> childIndexableFields = child.getIndexableExtras();
        if (null != childIndexableFields) {
            this.addIndexableEntry(key, childIndexableFields);
        }
        if (null != (childUnindexableFields = child.getUnindexableExtras())) {
            this.addUnindexableEntry(key, childUnindexableFields);
        }
    }
}

