/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.recordtransformer.DataTypeTransformer;
import org.apache.pinot.segment.local.recordtransformer.ExpressionTransformer;
import org.apache.pinot.segment.local.recordtransformer.FilterTransformer;
import org.apache.pinot.segment.local.recordtransformer.NullValueTransformer;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.segment.local.recordtransformer.SanitizationTransformer;
import org.apache.pinot.segment.local.recordtransformer.SchemaConformingTransformer;
import org.apache.pinot.segment.local.recordtransformer.SpecialValueTransformer;
import org.apache.pinot.segment.local.recordtransformer.TimeValidationTransformer;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class CompositeTransformer
implements RecordTransformer {
    private final List<RecordTransformer> _transformers;

    public static List<RecordTransformer> getDefaultTransformers(TableConfig tableConfig, Schema schema) {
        return Stream.of(new ExpressionTransformer(tableConfig, schema), new FilterTransformer(tableConfig), new SchemaConformingTransformer(tableConfig, schema), new DataTypeTransformer(tableConfig, schema), new TimeValidationTransformer(tableConfig, schema), new SpecialValueTransformer(schema), new NullValueTransformer(tableConfig, schema), new SanitizationTransformer(schema)).filter(t -> !t.isNoOp()).collect(Collectors.toList());
    }

    public static CompositeTransformer getDefaultTransformer(TableConfig tableConfig, Schema schema) {
        return new CompositeTransformer(CompositeTransformer.getDefaultTransformers(tableConfig, schema));
    }

    public static CompositeTransformer composeAllTransformers(List<RecordTransformer> customTransformers, TableConfig tableConfig, Schema schema) {
        ArrayList<RecordTransformer> allTransformers = new ArrayList<RecordTransformer>(customTransformers);
        allTransformers.addAll(CompositeTransformer.getDefaultTransformers(tableConfig, schema));
        return new CompositeTransformer(allTransformers);
    }

    public static CompositeTransformer getPassThroughTransformer() {
        return new CompositeTransformer(Collections.emptyList());
    }

    public CompositeTransformer(List<RecordTransformer> transformers) {
        this._transformers = transformers;
    }

    @Override
    @Nullable
    public GenericRow transform(GenericRow record) {
        for (RecordTransformer transformer : this._transformers) {
            if (!IngestionUtils.shouldIngestRow(record)) {
                return record;
            }
            if ((record = transformer.transform(record)) != null) continue;
            return null;
        }
        return record;
    }
}

