/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.invertedindex;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneDocIdCollector;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneTextIndexSearcherPool;
import org.apache.pinot.segment.local.segment.creator.impl.text.LuceneTextIndexCreator;
import org.apache.pinot.segment.spi.index.TextIndexConfig;
import org.apache.pinot.segment.spi.index.mutable.MutableTextIndex;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeLuceneTextIndex
implements MutableTextIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeLuceneTextIndex.class);
    private static final RealtimeLuceneTextIndexSearcherPool SEARCHER_POOL = RealtimeLuceneTextIndexSearcherPool.getInstance();
    private final LuceneTextIndexCreator _indexCreator;
    private SearcherManager _searcherManager;
    private Analyzer _analyzer;
    private final String _column;
    private final String _segmentName;

    public RealtimeLuceneTextIndex(String column, File segmentIndexDir, String segmentName, TextIndexConfig config) {
        this._column = column;
        this._segmentName = segmentName;
        try {
            this._indexCreator = new LuceneTextIndexCreator(column, new File(segmentIndexDir.getAbsolutePath() + "/" + segmentName), false, config);
            IndexWriter indexWriter = this._indexCreator.getIndexWriter();
            this._searcherManager = new SearcherManager(indexWriter, false, false, null);
            this._analyzer = this._indexCreator.getIndexWriter().getConfig().getAnalyzer();
        }
        catch (Exception e) {
            LOGGER.error("Failed to instantiate realtime Lucene index reader for column {}, exception {}", (Object)column, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void add(String document) {
        this._indexCreator.add(document);
    }

    public void add(String[] documents) {
        this._indexCreator.add(documents, documents.length);
    }

    public ImmutableRoaringBitmap getDictIds(String searchQuery) {
        throw new UnsupportedOperationException();
    }

    public MutableRoaringBitmap getDocIds(String searchQuery) {
        MutableRoaringBitmap docIDs = new MutableRoaringBitmap();
        RealtimeLuceneDocIdCollector docIDCollector = new RealtimeLuceneDocIdCollector(docIDs);
        Callable<MutableRoaringBitmap> searchCallable = () -> {
            MutableRoaringBitmap mutableRoaringBitmap;
            IndexSearcher indexSearcher = null;
            try {
                Query query = new QueryParser(this._column, this._analyzer).parse(searchQuery);
                indexSearcher = (IndexSearcher)this._searcherManager.acquire();
                indexSearcher.search(query, (Collector)docIDCollector);
                mutableRoaringBitmap = this.getPinotDocIds(indexSearcher, docIDs);
            }
            catch (Throwable throwable) {
                try {
                    if (indexSearcher != null) {
                        this._searcherManager.release(indexSearcher);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed while releasing the searcher manager for realtime text index for column {}, exception {}", (Object)this._column, (Object)e.getMessage());
                }
                throw throwable;
            }
            try {
                if (indexSearcher != null) {
                    this._searcherManager.release((Object)indexSearcher);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed while releasing the searcher manager for realtime text index for column {}, exception {}", (Object)this._column, (Object)e.getMessage());
            }
            return mutableRoaringBitmap;
        };
        Future<MutableRoaringBitmap> searchFuture = SEARCHER_POOL.getExecutorService().submit(searchCallable);
        try {
            return searchFuture.get();
        }
        catch (InterruptedException e) {
            docIDCollector.markShouldCancel();
            LOGGER.warn("TEXT_MATCH query timeout on realtime consuming segment {}, column {}, search query {}", new Object[]{this._segmentName, this._column, searchQuery});
            throw new RuntimeException("TEXT_MATCH query timeout on realtime consuming segment");
        }
        catch (Exception e) {
            LOGGER.error("Failed while searching the realtime text index for segment {}, column {}, search query {}, exception {}", new Object[]{this._segmentName, this._column, searchQuery, e.getMessage()});
            throw new RuntimeException(e);
        }
    }

    private MutableRoaringBitmap getPinotDocIds(IndexSearcher indexSearcher, MutableRoaringBitmap luceneDocIds) {
        PeekableIntIterator luceneDocIDIterator = luceneDocIds.getIntIterator();
        MutableRoaringBitmap actualDocIDs = new MutableRoaringBitmap();
        try {
            while (luceneDocIDIterator.hasNext()) {
                int luceneDocId = luceneDocIDIterator.next();
                Document document = indexSearcher.doc(luceneDocId);
                int pinotDocId = Integer.valueOf(document.get("DocID"));
                actualDocIDs.add(pinotDocId);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failure while retrieving document from index for column {}, exception {}", (Object)this._column, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return actualDocIDs;
    }

    public void close() {
        try {
            this._searcherManager.close();
            this._searcherManager = null;
            this._indexCreator.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed while closing the realtime text index for column {}, exception {}", (Object)this._column, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public SearcherManager getSearcherManager() {
        return this._searcherManager;
    }
}

