/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.segment.local.dedup.PartitionDedupMetadataManager;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentStatsHistory;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.config.table.ingestion.AggregationConfig;
import org.apache.pinot.spi.data.Schema;

public class RealtimeSegmentConfig {
    private final String _tableNameWithType;
    private final String _segmentName;
    private final String _streamName;
    private final Schema _schema;
    private final String _timeColumnName;
    private final int _capacity;
    private final int _avgNumMultiValues;
    private final Map<String, FieldIndexConfigs> _indexConfigByCol;
    private final SegmentZKMetadata _segmentZKMetadata;
    private final boolean _offHeap;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final RealtimeSegmentStatsHistory _statsHistory;
    private final String _partitionColumn;
    private final PartitionFunction _partitionFunction;
    private final int _partitionId;
    private final boolean _aggregateMetrics;
    private final boolean _nullHandlingEnabled;
    private final UpsertConfig.Mode _upsertMode;
    private final List<String> _upsertComparisonColumns;
    private final String _upsertDeleteRecordColumn;
    private final String _upsertOutOfOrderRecordColumn;
    private final boolean _upsertDropOutOfOrderRecord;
    private final PartitionUpsertMetadataManager _partitionUpsertMetadataManager;
    private final PartitionDedupMetadataManager _partitionDedupMetadataManager;
    private final String _consumerDir;
    private final List<FieldConfig> _fieldConfigList;
    private final List<AggregationConfig> _ingestionAggregationConfigs;

    private RealtimeSegmentConfig(String tableNameWithType, String segmentName, String streamName, Schema schema, String timeColumnName, int capacity, int avgNumMultiValues, Map<String, FieldIndexConfigs> indexConfigByCol, SegmentZKMetadata segmentZKMetadata, boolean offHeap, PinotDataBufferMemoryManager memoryManager, RealtimeSegmentStatsHistory statsHistory, String partitionColumn, PartitionFunction partitionFunction, int partitionId, boolean aggregateMetrics, boolean nullHandlingEnabled, String consumerDir, UpsertConfig.Mode upsertMode, List<String> upsertComparisonColumns, String upsertDeleteRecordColumn, String upsertOutOfOrderRecordColumn, boolean upsertDropOutOfOrderRecord, PartitionUpsertMetadataManager partitionUpsertMetadataManager, PartitionDedupMetadataManager partitionDedupMetadataManager, List<FieldConfig> fieldConfigList, List<AggregationConfig> ingestionAggregationConfigs) {
        this._tableNameWithType = tableNameWithType;
        this._segmentName = segmentName;
        this._streamName = streamName;
        this._schema = schema;
        this._timeColumnName = timeColumnName;
        this._capacity = capacity;
        this._avgNumMultiValues = avgNumMultiValues;
        this._indexConfigByCol = indexConfigByCol;
        this._segmentZKMetadata = segmentZKMetadata;
        this._offHeap = offHeap;
        this._memoryManager = memoryManager;
        this._statsHistory = statsHistory;
        this._partitionColumn = partitionColumn;
        this._partitionFunction = partitionFunction;
        this._partitionId = partitionId;
        this._aggregateMetrics = aggregateMetrics;
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._consumerDir = consumerDir;
        this._upsertMode = upsertMode != null ? upsertMode : UpsertConfig.Mode.NONE;
        this._upsertComparisonColumns = upsertComparisonColumns;
        this._upsertDeleteRecordColumn = upsertDeleteRecordColumn;
        this._upsertOutOfOrderRecordColumn = upsertOutOfOrderRecordColumn;
        this._upsertDropOutOfOrderRecord = upsertDropOutOfOrderRecord;
        this._partitionUpsertMetadataManager = partitionUpsertMetadataManager;
        this._partitionDedupMetadataManager = partitionDedupMetadataManager;
        this._fieldConfigList = fieldConfigList;
        this._ingestionAggregationConfigs = ingestionAggregationConfigs;
    }

    public String getTableNameWithType() {
        return this._tableNameWithType;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public String getStreamName() {
        return this._streamName;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getTimeColumnName() {
        return this._timeColumnName;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public int getAvgNumMultiValues() {
        return this._avgNumMultiValues;
    }

    public Map<String, FieldIndexConfigs> getIndexConfigByCol() {
        return this._indexConfigByCol;
    }

    public SegmentZKMetadata getSegmentZKMetadata() {
        return this._segmentZKMetadata;
    }

    public boolean isOffHeap() {
        return this._offHeap;
    }

    public PinotDataBufferMemoryManager getMemoryManager() {
        return this._memoryManager;
    }

    public RealtimeSegmentStatsHistory getStatsHistory() {
        return this._statsHistory;
    }

    public String getPartitionColumn() {
        return this._partitionColumn;
    }

    public PartitionFunction getPartitionFunction() {
        return this._partitionFunction;
    }

    public int getPartitionId() {
        return this._partitionId;
    }

    public boolean aggregateMetrics() {
        return this._aggregateMetrics;
    }

    public boolean isNullHandlingEnabled() {
        return this._nullHandlingEnabled;
    }

    @Nullable
    public String getConsumerDir() {
        return this._consumerDir;
    }

    public UpsertConfig.Mode getUpsertMode() {
        return this._upsertMode;
    }

    public boolean isDedupEnabled() {
        return this._partitionDedupMetadataManager != null;
    }

    public List<String> getUpsertComparisonColumns() {
        return this._upsertComparisonColumns;
    }

    public String getUpsertDeleteRecordColumn() {
        return this._upsertDeleteRecordColumn;
    }

    public String getUpsertOutOfOrderRecordColumn() {
        return this._upsertOutOfOrderRecordColumn;
    }

    public boolean isUpsertDropOutOfOrderRecord() {
        return this._upsertDropOutOfOrderRecord;
    }

    public PartitionUpsertMetadataManager getPartitionUpsertMetadataManager() {
        return this._partitionUpsertMetadataManager;
    }

    public PartitionDedupMetadataManager getPartitionDedupMetadataManager() {
        return this._partitionDedupMetadataManager;
    }

    public List<FieldConfig> getFieldConfigList() {
        return this._fieldConfigList;
    }

    public List<AggregationConfig> getIngestionAggregationConfigs() {
        return this._ingestionAggregationConfigs;
    }

    public static class Builder {
        private String _tableNameWithType;
        private String _segmentName;
        private String _streamName;
        private Schema _schema;
        private String _timeColumnName;
        private int _capacity;
        private int _avgNumMultiValues;
        private final Map<String, FieldIndexConfigs.Builder> _indexConfigByCol;
        private SegmentZKMetadata _segmentZKMetadata;
        private boolean _offHeap;
        private PinotDataBufferMemoryManager _memoryManager;
        private RealtimeSegmentStatsHistory _statsHistory;
        private String _partitionColumn;
        private PartitionFunction _partitionFunction;
        private int _partitionId;
        private boolean _aggregateMetrics = false;
        private boolean _nullHandlingEnabled = false;
        private String _consumerDir;
        private UpsertConfig.Mode _upsertMode;
        private List<String> _upsertComparisonColumns;
        private String _upsertDeleteRecordColumn;
        private String _upsertOutOfOrderRecordColumn;
        private boolean _upsertDropOutOfOrderRecord;
        private PartitionUpsertMetadataManager _partitionUpsertMetadataManager;
        private PartitionDedupMetadataManager _partitionDedupMetadataManager;
        private List<FieldConfig> _fieldConfigList;
        private List<AggregationConfig> _ingestionAggregationConfigs;

        public Builder() {
            this._indexConfigByCol = new HashMap<String, FieldIndexConfigs.Builder>();
        }

        public Builder(IndexLoadingConfig indexLoadingConfig) {
            this(indexLoadingConfig.getFieldIndexConfigByColName());
        }

        public Builder(TableConfig tableConfig, Schema schema) {
            this(FieldIndexConfigsUtil.createIndexConfigsByColName((TableConfig)tableConfig, (Schema)schema));
        }

        public Builder(Map<String, FieldIndexConfigs> indexConfigsByColName) {
            this._indexConfigByCol = new HashMap<String, FieldIndexConfigs.Builder>(HashUtil.getHashMapCapacity((int)indexConfigsByColName.size()));
            for (Map.Entry<String, FieldIndexConfigs> entry : indexConfigsByColName.entrySet()) {
                this._indexConfigByCol.put(entry.getKey(), new FieldIndexConfigs.Builder(entry.getValue()));
            }
        }

        public Builder setTableNameWithType(String tableNameWithType) {
            this._tableNameWithType = tableNameWithType;
            return this;
        }

        public Builder setSegmentName(String segmentName) {
            this._segmentName = segmentName;
            return this;
        }

        public Builder setStreamName(String streamName) {
            this._streamName = streamName;
            return this;
        }

        public Builder setSchema(Schema schema) {
            this._schema = schema;
            return this;
        }

        public Builder setTimeColumnName(String timeColumnName) {
            this._timeColumnName = timeColumnName;
            return this;
        }

        public Builder setCapacity(int capacity) {
            this._capacity = capacity;
            return this;
        }

        public Builder setAvgNumMultiValues(int avgNumMultiValues) {
            this._avgNumMultiValues = avgNumMultiValues;
            return this;
        }

        public <C extends IndexConfig> Builder setIndex(Iterable<String> columns, IndexType<C, ?, ?> indexType, C config) {
            for (String column : columns) {
                FieldIndexConfigs.Builder builder = this._indexConfigByCol.computeIfAbsent(column, k -> new FieldIndexConfigs.Builder());
                builder.add(indexType, config);
            }
            return this;
        }

        public <C extends IndexConfig> Builder setIndex(String column, IndexType<C, ?, ?> indexType, C config) {
            FieldIndexConfigs.Builder builder = this._indexConfigByCol.computeIfAbsent(column, k -> new FieldIndexConfigs.Builder());
            builder.add(indexType, config);
            return this;
        }

        public Builder setSegmentZKMetadata(SegmentZKMetadata segmentZKMetadata) {
            this._segmentZKMetadata = segmentZKMetadata;
            return this;
        }

        public Builder setOffHeap(boolean offHeap) {
            this._offHeap = offHeap;
            return this;
        }

        public Builder setMemoryManager(PinotDataBufferMemoryManager memoryManager) {
            this._memoryManager = memoryManager;
            return this;
        }

        public Builder setStatsHistory(RealtimeSegmentStatsHistory statsHistory) {
            this._statsHistory = statsHistory;
            return this;
        }

        public Builder setPartitionColumn(String partitionColumn) {
            this._partitionColumn = partitionColumn;
            return this;
        }

        public Builder setPartitionFunction(PartitionFunction partitionFunction) {
            this._partitionFunction = partitionFunction;
            return this;
        }

        public Builder setPartitionId(int partitionId) {
            this._partitionId = partitionId;
            return this;
        }

        public Builder setAggregateMetrics(boolean aggregateMetrics) {
            this._aggregateMetrics = aggregateMetrics;
            return this;
        }

        public Builder setNullHandlingEnabled(boolean nullHandlingEnabled) {
            this._nullHandlingEnabled = nullHandlingEnabled;
            return this;
        }

        public Builder setConsumerDir(String consumerDir) {
            this._consumerDir = consumerDir;
            return this;
        }

        public Builder setUpsertMode(UpsertConfig.Mode upsertMode) {
            this._upsertMode = upsertMode;
            return this;
        }

        public Builder setUpsertComparisonColumns(List<String> upsertComparisonColumns) {
            this._upsertComparisonColumns = upsertComparisonColumns;
            return this;
        }

        public Builder setUpsertDeleteRecordColumn(String upsertDeleteRecordColumn) {
            this._upsertDeleteRecordColumn = upsertDeleteRecordColumn;
            return this;
        }

        public Builder setUpsertOutOfOrderRecordColumn(String upsertOutOfOrderRecordColumn) {
            this._upsertOutOfOrderRecordColumn = upsertOutOfOrderRecordColumn;
            return this;
        }

        public Builder setUpsertDropOutOfOrderRecord(boolean upsertDropOutOfOrderRecord) {
            this._upsertDropOutOfOrderRecord = upsertDropOutOfOrderRecord;
            return this;
        }

        public Builder setPartitionUpsertMetadataManager(PartitionUpsertMetadataManager partitionUpsertMetadataManager) {
            this._partitionUpsertMetadataManager = partitionUpsertMetadataManager;
            return this;
        }

        public Builder setPartitionDedupMetadataManager(PartitionDedupMetadataManager partitionDedupMetadataManager) {
            this._partitionDedupMetadataManager = partitionDedupMetadataManager;
            return this;
        }

        public Builder setFieldConfigList(List<FieldConfig> fieldConfigList) {
            this._fieldConfigList = fieldConfigList;
            return this;
        }

        public Builder setIngestionAggregationConfigs(List<AggregationConfig> ingestionAggregationConfigs) {
            this._ingestionAggregationConfigs = ingestionAggregationConfigs;
            return this;
        }

        public RealtimeSegmentConfig build() {
            HashMap indexConfigByCol = Maps.newHashMapWithExpectedSize((int)this._indexConfigByCol.size());
            for (Map.Entry<String, FieldIndexConfigs.Builder> entry : this._indexConfigByCol.entrySet()) {
                indexConfigByCol.put(entry.getKey(), entry.getValue().build());
            }
            return new RealtimeSegmentConfig(this._tableNameWithType, this._segmentName, this._streamName, this._schema, this._timeColumnName, this._capacity, this._avgNumMultiValues, Collections.unmodifiableMap(indexConfigByCol), this._segmentZKMetadata, this._offHeap, this._memoryManager, this._statsHistory, this._partitionColumn, this._partitionFunction, this._partitionId, this._aggregateMetrics, this._nullHandlingEnabled, this._consumerDir, this._upsertMode, this._upsertComparisonColumns, this._upsertDeleteRecordColumn, this._upsertOutOfOrderRecordColumn, this._upsertDropOutOfOrderRecord, this._partitionUpsertMetadataManager, this._partitionDedupMetadataManager, this._fieldConfigList, this._ingestionAggregationConfigs);
        }
    }
}

